#pragma once

#include "Mix/Class/Scene/Common/Factory.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX10{

	class Factory : public Mix::Scene::Common::Factory
	{
	public:
		static Factory* CreateInstance( void );

	private:
		Factory( void );
		virtual ~Factory( void );

	protected:
		virtual void GetShaderBinary( Factory::SHADER_TYPES type, Factory::SHADER_BINARY& out );

		virtual Mix::Scene::IRenderer* CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, const wchar_t* pName );
		virtual Mix::Scene::IMaterial* CreateDefaultMaterial(	const wchar_t* pNameLabel,
																const wchar_t* pName,
																Boolean bWithMagicNumber,
																Mix::File::IReader* pReader,
																Mix::Scene::Common::Factory* pFactory,
																Mix::Graphics::IDevice* pDevice );
	};

}}}}
