#pragma once

#include <set>
#include <vector>

#include "Mix/Geometry/Plane.h"
#include "Mix/Geometry/AABB.h"
#include "Mix/Geometry/Sphere.h"
#include "Mix/Geometry/Frustum.h"
#include "Mix/Scene/IMaterial.h"
#include "Mix/Scene/IRenderer.h"
#include "Mix/Scene/IRendererObject.h"
#include "Mix/Scene/ISkyDome.h"

#include "Mix/Graphics/ITexture.h"
#include "Mix/Graphics/Utility/ITargetTextureChain.h"

#include "Mix/Class/Container.h"
#include "Mix/Class/Scene/Common/RendererTypes.h"
#include "Mix/Class/Scene/Common/Renderer.h"
#include "Mix/Class/Scene/Common/WidgetTypes.h"
#include "Mix/Class/Scene/Common/Octree.h"
#include "Mix/Class/Scene/Common/Camera.h"
#include "Mix/Class/Scene/Common/SkyDome.h"

#ifdef _DEBUG
	#include "Mix/Timer.h"
#endif //_DEBUG

namespace Mix{ namespace Scene{ namespace Common{

	class Factory;
	class ResourceManager;

	class HemisphereLight;
	class DirectionalLight;
	class SpotLight;
	class PointLight;
	class SkyDome;
	class LeavingParticle;
	class ScatterParticle;
	class ScatterParticleUnit;
	class ActorModel;
	class ActorNode;
	class TerrainModel;
	class TerrainNode;
	class Planter;
	class WaterPool;
	class Floor;
	class Ghost;

	class ShadowProjector;
	class LightShaftsCaster;
	class AtmosphereScatter;
	class DynamicsWorld;

}}}

namespace Mix{ namespace Scene{ namespace Standard{ namespace Common{

	class Renderer : public Mix::Scene::IRenderer, public Mix::Scene::Common::Renderer
	{
	protected:
		//el
		enum PROTECTED_VALUE
		{
			LOCAL_LIGHT_MAX			= 4,	// VF[_[ɓn郍[JCg̍ő吔
			WORLD_MAT_MAX			= 20,	// VF[_[ɓn郏[hs̍ő吔
			DOF_SAMPLING_NUM		= 12,	// ʊE[x̃TvO
			SM_SAMPLING_NUM			= 9,	// VhE}bsÕTvO
			GLOBAL_TEX_MAX			= 3,	// O[oeNX`̍ő吔
		};

		//eNX`Xe[W
		enum TS
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// }eA
			////////////////////////////////////////////////////////////////////////////////////////////////////

//			TS_DIFFUSE	= 0,
//			TS_SPECULAR = 1,
//			TS_EMISSIVE = 2,
//			TS_BUMP		= 3,

			TS_DEPTH	= 4,
			TS_SHADOW	= 5,
			TS_REFRACT	= 6,
			TS_REFLECT	= 7,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_SD_BASE	= 0,
			TS_SD_CLOUD1 = 1,
			TS_SD_CLOUD2 = 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// TvO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_SAMPLING_SOURCE = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// u[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_BLUR = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// KEVAu[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_GAUSSIAN_BLUR = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// SSAO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_SSAO_DEPTH	= 0,	// m_pDepthTexChain( R=Z )
			TS_SSAO_NORMAL	= 1,	// m_pDataTex( RGB=XYZ )
			TS_SSAO_BUMP	= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// VhE}bsO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_SM_SHADE	= 0,
			TS_SM_DEPTH	= 1,
			TS_SM_DATA	= 2,
			TS_SM_COLOR	= 3,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// Px
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_LUM_TRANSFORM = 0,

			TS_LUM_ADAPTED_PRE	= 0,
			TS_LUM_ADAPTED_CUR	= 1,

			TS_LUM_TM_COLOR		= 0,
			TS_LUM_TM_ADAPTED	= 1,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// uCgpX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_BP_COLOR		= 0,
			TS_BP_LUM		= 1,
			TS_BP_MASK		= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// CgVtg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// 
			TS_LS_INIT_COLOR	= 0,
			TS_LS_INIT_MASK		= 1,
			TS_LS_INIT_NOISE	= 2,

			// u[
			TS_LS_BLUR_COLOR	= 0,
			TS_LS_BLUR_DEPTH	= 1,
			TS_LS_BLUR_DATA		= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// YtA
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// C[W
			TS_LF_IMAGE_COLOR		= 0,
			TS_LF_IMAGE_GHOST_COLOR	= 1,

			// fBt@C
			TS_LF_MODIFY_IMAGE		= 0,
			TS_LF_MODIFY_DIRT		= 1,
			TS_LF_MODIFY_BRUST		= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tB~bN
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_FI_COLOR	= 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// F
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// C[W
			TS_CA_IMAGE_COLOR			= 0,

			// tBjbV
			TS_CA_FINISH_COLOR			= 0,
			TS_CA_FINISH_IMAGE			= 1,
			TS_CA_FINISH_DEPTH			= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// ʊE[x
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_DOF_DEPTH	= 0,
			TS_DOF_DATA		= 1,
			TS_DOF_COLOR0	= 2,
			TS_DOF_COLOR1	= 3,
			TS_DOF_COLOR2	= 4,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// cȎ
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_LD_COLOR = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// Blbg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TS_VI_COLOR	= 0,
		};

		//_OCxgf[^\
		struct PREPARE_REDNERING_EVENT_ARGS
		{
			Mix::Vector4 eyePos;

			Mix::Matrix4x4 viewMat;
			Mix::Matrix4x4 viewProjMat;

			Mix::Matrix4x4 lightMat;
			Mix::Matrix4x4 lightBiasMat;

			Float32 invFarZ;

			Mix::Vector4 globalAmbientColor;

			Boolean hsEnabled;
			Mix::Vector4 hsAxis;
			Mix::Vector4 hsGroundColor;
			Mix::Vector4 hsSkyColor;

			Boolean sunEnabled;
			Mix::Vector4 sunDir;
			Mix::Vector4 sunColor;

			Boolean fogEnabled;
			Float32 fogParam0;
			Float32 fogParam1;
			Mix::Vector4 fogColor;

			Boolean shadowEnabled;
			Float32 shadowZBias;
			Float32 shadowDensity;
			const Mix::Vector4* shadowSampTable;

			Boolean asEnabled;
			Mix::Vector4 asColor;
			Mix::Vector4 asSunDir;
			Mix::Vector4 asMultipliers;
			Mix::Vector4 asHG;
			Mix::Vector4 asBetaDashR;
			Mix::Vector4 asBetaDashM;
			Mix::Vector4 asBetaRM;
			Mix::Vector4 asOneOverBetaRM;
		};

		//gXtH[Cxgf[^\
		struct TRANSFORM_EVENT_ARGS
		{
			const Mix::Matrix4x4* list;
			UInt32 count;
		};

		//[JCgCxgf[^\
		struct LOCALLIGHT_EVENT_ARGS
		{
			const Mix::Scene::Common::LOCAL_LIGHT** list;
			UInt32 count;
		};

		//VhE}eACxgf[^\
		struct SHADOW_MATERIAL_EVENT_ARGS
		{
			Mix::Vector4 diffuseColor;
		};

		//}eACxgf[^\
		struct MATERIAL_EVENT_ARGS
		{
			Mix::Vector4 ambientColor;
			Mix::Vector4 diffuseColor;
			Mix::Vector4 diffuseParam;
			Mix::Vector4 specularColor;
			Mix::Vector4 specularParam;
			Mix::Vector4 reflectParam0;
			Mix::Vector4 reflectParam1;
			Mix::Vector4 emissiveColor;
			Mix::Vector4 bumpParam0;
			Mix::Vector4 bumpParam1;
			Mix::Vector4 particleParam;
		};

		//XJCh[ : x[Xp[^
		struct SKYDOME_BASE_PARAM
		{
			Float32 texScale;
			Float32 texOpacity;
		};

		//XJCh[ : NEhC[\
		struct SKYDOME_CLOUD_LAYER
		{
			Mix::Vector2 texOffset;
			Float32 texScale;
			Float32 texOpacity;
		};

		//XJCh[ : NEhCeBO
		struct SKYDOME_CLOUD_LIGHTING
		{
			Float32 cornerThreshold;
			Float32 cornerMul;
			Float32 darkness;
		};

		//XJCh[ : ftHgCxgf[^\
		struct SKYDOME_DEFAULT_EVENT_ARGS
		{
			Mix::Matrix4x4 wvpMat;

			Mix::Vector4 baseColor;
			Renderer::SKYDOME_BASE_PARAM baseParam;
			Mix::Vector4 cloudColor;
			Renderer::SKYDOME_CLOUD_LAYER cloudLayers[Mix::Scene::Common::SkyDome::CL_MAX];
		};

		//XJCh[ : CUV~[VCxgf[^\
		struct SKYDOME_ATMOSPHERE_EVENT_ARGS
		{
			Mix::Matrix4x4 worldMat;
			Mix::Matrix4x4 worldViewProjMat;

			Mix::Vector4 sunColor;
			Mix::Vector4 nightColor;

			Renderer::SKYDOME_BASE_PARAM baseParam;

			Mix::Vector4 cloudColor;
			Renderer::SKYDOME_CLOUD_LAYER cloudLayers[Mix::Scene::Common::SkyDome::CL_MAX];
			Renderer::SKYDOME_CLOUD_LIGHTING cloudLighting;
		};

		//XJCh[ : pm}Cxgf[^\
		struct SKYDOME_PANORAMA_EVENT_ARGS
		{
			Mix::Matrix4x4 wvpMat;
			Mix::Matrix4x4 wMat;

			Mix::Vector4 baseColor;
			Float32 dist;
			Float32 fogRatio; // ( 1.0f - dist * invFarZ )
			Float32 texRepeat;
		};

		//ʉCxgf[^\
		struct UNDERWATER_EVENT_ARGS
		{
			Mix::Vector4 color;

			Float32 density;
			Float32 intensity;
			Float32 threshold;
			Float32 offset;
		};

		//TvO\
		struct RENDER_SAMPLING_ARGS
		{
			Mix::Vector2 texelSize;
			Float32 colorScale;
		};

		//u[\
		struct RENDER_BLUR_ARGS
		{
			Mix::Vector4 params[3]; //xy=ItZbg w=EFCg
		};

		//KEVAu[\
		struct RENDER_GAUSSIAN_BLUR_ARGS
		{
			Mix::Vector4 inOffsets[8];
			Mix::Vector4 outOffset;
			Float32 weights[8];
		};

		//KEVAu[EX\
		struct RENDER_GAUSSIAN_BLUR_EX_ARGS
		{
			Float32 halfRadius;
			Mix::Vector3 inc;
			Mix::Vector2 step;
		};

		//ArGgIN[W\
		struct RENDER_AMBIENT_OCCLUSION_ARGS
		{
			Float32 radius;
			Float32 threshold;
			Float32 depth;
			Float32 intensity;
			Mix::Vector2 ntexAspect;
			Mix::Vector4 color;
		};

		//VhE}bsO\
		struct RENDER_SHADOW_MAPPING_ARGS
		{
			Float32 falloutStart;
			Float32 invFalloutDist;
			Mix::Vector4 sunDir;
			Mix::Vector4 color; //rgb=F a=x
		};

		//~iXgXtH[\
		struct RENDER_LUM_TRANSFORM_ARGS
		{
			Mix::Vector2 texelSize;
			Mix::Vector2 lumRange;
		};

		//~iXA_vebh\
		struct RENDER_LUM_ADAPTED_ARGS
		{
			Float32 rods;
			Float32 cones;
			Float32 deltaTime;
		};

		//~iXIy[^\
		struct RENDER_LUM_OPERATOR_ARGS
		{
			Float32 middleGray;
			Float32 invWhite2;
		};

		//uCgpX\
		struct RENDER_BRIGHTPASS_ARGS
		{
			Float32 middleGray;
			Float32 invWhite2;
			Float32 threshold;
			Float32 offset;
		};

		//CgVtg : \
		struct RENDER_LIGHT_SHAFTS_INIT_ARGS
		{
			Float32 whiteness;
			Mix::Vector2 ntexAspect;
		};

		//CgVtg : u[\
		struct RENDER_LIGHT_SHAFTS_BLUR_ARGS
		{
			Mix::Vector2 lightPos;
			Float32 EdotL;
			Float32 density;
			Float32 decay;
			Float32 exposure;
			Float32 fiStart;
			Float32 fiEnd;
			Float32 fiInvDist;
		};

		//YtA : C[W\
		struct RENDER_LENSFLARE_IMAGE_ARGS
		{
			Mix::Vector3 distortion;

			UInt32 numGhost;
			Float32 ghostWeight;
			Float32 ghostDispersion;

			Float32 haloWeight;
			Float32 haloWidth;
		};

		//YtA : fBt@C\
		struct RENDER_LENSFLARE_MODIFY_ARGS
		{
			Float32 dirtIntensity;
			Float32 dirtExposure;

			Float32 brustIntensity;
			Float32 brustExposure;

			Mix::Matrix4x4 camMat;
		};

		//tB~bN : HABLE\
		struct RENDER_FILMIC_HABLE_ARGS
		{
			Float32 exposureBias;
			Float32 shoulderStrength;
			Float32 linearStrength;
			Float32 linearAngle;
			Float32 toeStrength;
			Float32 toeNumerator;
			Float32 toeDenominator;
			Float32 linearWhitePointValue;
		};

		//F : C[W\
		struct RENDER_CHROMATISM_IMAGE_ARGS
		{
			Float32 k;
			Float32 kCube;
			Float32 scale;
			Mix::Vector4 colorFactor;
		};

		//F : tBjbV\
		struct RENDER_CHROMATISM_FINISH_ARGS
		{
			Float32 weight;
			Float32 fiStartZ;
			Float32 fiInvDist;
		};

		//K}\
		struct RENDER_GAMMA_ARGS
		{
			Mix::Vector4 invValue;
		};

		//cȎ\
		struct RENDER_LENS_DISTORTION_ARGS
		{
			Float32 k;
			Float32 kCube;
			Float32 scale;
		};

		//Blbg\
		struct RENDER_VIGNETTE_ARGS
		{
			Float32 start;
			Float32 invDist;
			Mix::Vector4 color;
		};

		//FXAA\
		struct RENDER_FXAA_ARGS
		{
			Mix::Vector4 texCoords[2];
			Mix::Vector4 invScreenSize;
		};

		//ʊE[x\
		struct RENDER_DOF_ARGS
		{
			Float32 nearZ;
			Float32 farZ;
			Float32 invNearDist;
			Float32 invFarDist;

			Float32 blurThreshold;
			Float32 invBlurThreaholdN;
			Float32 invBlurThreaholdF;

			const Mix::Vector4* samplingTable;
		};

	private:
		//el
		enum PRIVATE_VALUE
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// 萔
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// Nbh
			QUAD_VERTEX_NUM = 4,
			QUAD_VERTEX_STRIDE = 24,

			// u[
			BLUR_X			= 0,
			BLUR_Y			= 1,
			BLUR_DIR_MAX	= 2,

			// XJCh[
			SD_BASE_0		= 0,
			SD_BASE_1		= 1,
			SD_BASE_MAX		= 2,
			SD_CLOUD_L0		= 0,
			SD_CLOUD_L1		= 1,
			SD_CLOUD_L2		= 2,
			SD_CLOUD_L_MAX	= 3,
			SD_CLOUD_S_MAX	= 2,

			// XJCh[( pm} )
			SD_PR			= 0,
			SD_PR_FOG		= 1,
			SD_PR_MAX		= 2,

			// ArGgIN[W
			SSAO_SIMPLE		= 0,
			SSAO_TEX		= 1,
			SSAO_TYPE_MAX	= 2,

			// Px( gXtH[ )
			LUM_INITAL	= 0,
			LUM_ITERATE	= 1,
			LUM_FINAL	= 2,
			LUM_TF_MAX	= 3,

			// Px( Iy[V )
			LUM_OP_TA_MAX	= 3, //0: 1:L( ԐF͎w ) 2:L( ԐF͎ )
			LUM_OP_B_MAX	= 2,

			// uCgpX
			BP_L_MAX	= 2,
			BP_A_MAX	= 2,

			// u[
			BLOOM_MIN_SIZE	= 32,

			// CgVtg(  )
			LS_INIT_A_MAX		= 2,

			// CgVtg( u[ )
			LS_BLUR_L			= 0,
			LS_BLUR_M			= 1,
			LS_BLUR_H			= 2,
			LS_BLUR_TYPE_MAX	= 3,

			// cȎ
			LD_K_MAX	= 2,

			// YtA
			LF_I_G_MAX	= 2,
			LF_I_H_MAX	= 2,
			LF_M_D_MAX	= 2,
			LF_M_B_MAX	= 2,

			// F( C[W )
			CA_I_K_MAX	= 2,

			// F( tBjbV )
			CA_F_D_MAX	= 2,

			// ʊE[x
			DOF_SRC0	= 0,
			DOF_SRC1	= 1,
			DOF_TEMP	= 2,
			DOF_TEX_MAX	= 3,

			// fvXobt@
			DEPTH_BUFF_FORMAT_COUNT = 3,

			// 
			TRANSPARENCY_BACK		= 0,
			TRANSPARENCY_FRONT		= 1,
			TRANSPARENCY_TYPE_MAX	= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// Sʂ̒l
			////////////////////////////////////////////////////////////////////////////////////////////////////

			VISIBLE_LOCALLIGHT__DEF_SIZE = 32,
			VISIBLE_LOCALLIGHT__RESIZE_STEP = 2,

			VISIBLE_WATERPOOL__DEF_SIZE = 32,
			VISIBLE_WATERPOOL__RESIZE_STEP = 2,

			LENSFLARE_COM__DEF_SIZE		= 32,
			LENSFLARE_COM__RESIZE_STEP	= 2,

			LENSFLARE_VB__DEF_SIZE		= LENSFLARE_COM__DEF_SIZE * 16,
			LENSFLARE_VB__RESIZE_STEP	= 4,

			LOCALLIGHT__DEF_SIZE = 128,
			LOCALLIGHT__RESIZE_STEP = 8,

			WORLDMAT__DEF_SIZE = 2048,
			WORLDMAT__RESIZE_STEP = 128,

#ifdef _DEBUG
			DEB__DEF_SIZE = 1024,
			DEB__RESIZE_STEP = 64,
#endif //_DEBUG

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// EBWFbg̒l
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// TuZbg

			WIDGET_SUBSET_DEF_COUNT = 256,
			WIDGET_SUBSET_RESIZE_STEP = 16,

			// IuWFNg( [JCeBO )

			WIDGET_OBJECT_DEF_COUNT = 128,
			WIDGET_OBJECT_RESIZE_STEP = 8,

			// Nbh

			WIDGET_QUAD_DEF_COUNT = 512,
			WIDGET_QUAD_RESIZE_STEP = 32,

			// o[ebNXobt@

			WIDGET_VB_DEF_PRIMITIVE_COUNT = ( WIDGET_QUAD_DEF_COUNT * Mix::Scene::Common::WIDGET_QUAD_POINT_NUM ),
			WIDGET_VB_RESIZE_STEP = ( WIDGET_QUAD_RESIZE_STEP * Mix::Scene::Common::WIDGET_QUAD_POINT_NUM ),

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// IuWFNg̒l ( EBWFbgAAN^[fAeCf )
			////////////////////////////////////////////////////////////////////////////////////////////////////

			TR_OBJ_DEF_COUNT = 512,
			TR_OBJ_RESIZE_STEP = 32,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// R}h̒l
			////////////////////////////////////////////////////////////////////////////////////////////////////

			COM_SHADOW_DEFCOUNT = 512,
			COM_SHADOW_RESIZESTEP = 32,

			COM_OPACITY_DEFCOUNT = 512,
			COM_OPACITY_RESIZESTEP = 32,

			COM_TRANSPARENCY_DEFCOUNT = 512,
			COM_TRANSPARENCY_RESIZESTEP = 32,

			COM_REFRACTMASK_DEFCOUNT = 32,
			COM_REFRACTMASK_RESIZESTEP = 2,

			COM_REFRACT_DEFCOUNT = 32,
			COM_REFRACT_RESIZESTEP = 2,
		};

		//\[X^O񋓒萔
		enum RESOURCE_TAG
		{
			RTAG_DEPTH_BUFF				= 1,
			RTAG_COLOR_TEX_CHAIN		= 2,
			RTAG_DEPTH_TEX_CHAIN		= 3,
			RTAG_DATA_TEX				= 4,
			RTAG_REFFRACT_TEX			= 5,

			RTAG_TEMP_TEX_0				= 6,
			RTAG_TEMP_TEX_1				= 7,
			RTAG_TEMP_TEX_2				= 8,
			RTAG_TEMP_TEX_CHAIN_0		= 9,

			RTAG_SDW_DEPTH_BUFF			= 10,
			RTAG_SDW_DEPTH_TEX			= 11,
			RTAG_SDW_MAP_TEX			= 0x00000800,

			RTAG_LUM_INITIAL_TEX		= 12,
			RTAG_LUM_ITEXRATE_TEX		= 13,
			RTAG_LUM_FINAL_TEX			= 14,
			RTAG_LUM_ADAPTED_TEX_CHAIN	= 15,

#ifdef _DEBUG
			RTAG_DEBUG_TEX				= 256,
#endif //_DEBUG
		};

		//eNX`Xg
		typedef std::vector<Mix::Graphics::ITexture*> TextureList;
		//eNX``FCXg
		typedef std::vector<Mix::Graphics::Utility::ITargetTextureChain*> TextureChainList;
		
		//J\
		struct CAMERA
		{
			Mix::Scene::ICamera* pInterface;
			Mix::Scene::Common::Camera* pInternalInterface;

			CAMERA( Mix::Scene::ICamera* _pInterface, Mix::Scene::Common::Camera* _pInternalInterface )
			{
				pInterface = _pInterface;
				pInternalInterface = _pInternalInterface;
			}

			bool operator == ( const CAMERA& cam ) const
			{
				return ( pInterface == cam.pInterface );
			}
		};

		//r[(J)\
		struct VIEW
		{
			// r[̒ǉɍ쐬Ar[̍폜ɉ

			Mix::Scene::Common::Camera* pInternalCamera;
			UInt32 resOwner;

			// J̐ݒɂāA쐬A

			Mix::Dynamics::IObjectDragger* pObjDragger;
			Boolean bDragObj;

			Mix::Rectangle viewport;
			Mix::Graphics::ITexture* pDepthBuff;
			Mix::Graphics::Utility::ITargetTextureChain* pColorTexChain;
			Mix::Graphics::Utility::ITargetTextureChain* pDepthTexChain;
			Mix::Graphics::ITexture* pDataTex;
			Mix::Graphics::ITexture* pRefractTex;

			Mix::Scene::Common::RENDERER_SAMPLING_TYPE AOSamplingType;
			Mix::Graphics::ITexture* pAOTex;
			Mix::Graphics::Utility::ITargetTextureChain* pAOTexChain;

			Mix::Matrix4x4 SdwBiasMat;
			Mix::Rectangle SdwDepthViewport;
			Mix::Vector4 SdwSamplingTable[Mix::Scene::Common::RENDERER_SM_SAMPLING_NUM];
			Mix::Scene::Common::RENDERER_SAMPLING_TYPE SdwMapSamplingType;
			Mix::Graphics::ITexture* pSdwDepthBuff;
			Mix::Graphics::ITexture* pSdwDepthTex;
			Mix::Graphics::ITexture* pSdwMapTex;
			Mix::Graphics::Utility::ITargetTextureChain* pSdwMapTexChain;

			Mix::Graphics::ITexture* pLumInitalTex;
			Renderer::TextureList LumIterateTexList;
			Mix::Graphics::ITexture* pLumFinalTex;
			Mix::Graphics::Utility::ITargetTextureChain* pLumAdaptedTexChain;

			Mix::Scene::Common::RENDERER_SAMPLING_TYPE BloomSamplingType;
			Renderer::TextureChainList BloomTexChainList;

			Mix::Rectangle LSViewport;
			Mix::Graphics::Utility::ITargetTextureChain* pLSTexChain;

			Mix::Rectangle LFViewport;
			Mix::Scene::Common::RENDERER_SAMPLING_TYPE LFSamplingType;
			Mix::Graphics::Utility::ITargetTextureChain* pLFTexChain;

			Mix::Rectangle CAViewport;
			Mix::Scene::Common::RENDERER_SAMPLING_TYPE CASamplingType;
			Mix::Graphics::Utility::ITargetTextureChain* pCATexChain;

			Mix::Rectangle DofViewport;
			Mix::Scene::Common::RENDERER_SAMPLING_TYPE DofSamplingType;
			Mix::Vector4 DofSamplingTable[Mix::Scene::Common::RENDERER_DOF_SAMPLING_NUM];
			Mix::Graphics::ITexture* pDofBokehTex0;
			Mix::Graphics::ITexture* pDofBokehTex1;
			Mix::Graphics::ITexture* pDofTempTex;
#ifdef _DEBUG
			Mix::Graphics::ITexture* pDebLSBrightPassTex;
			Mix::Graphics::ITexture* pDebBloomBrightPassTex;
			Mix::Graphics::ITexture* pDebLFBrightPassTex;
#endif //_DEBUG

			// vt@C

#ifdef _DEBUG
			Mix::Scene::DEBUG_PROFILE_CAMERA_GENERAL debProfGeneral;
			Mix::Scene::DEBUG_PROFILE_CAMERA_OCTREE debProfOctree;
			Mix::Scene::DEBUG_PROFILE_CAMERA_LIGHT debProfLight;
			Mix::Scene::DEBUG_PROFILE_CAMERA_WATER_POOL debProfWaterPool;
			Mix::Scene::DEBUG_PROFILE_CAMERA_WIDGET debProfWidget;
			Mix::Scene::DEBUG_PROFILE_CAMERA_MODEL debProfActorModel;
			Mix::Scene::DEBUG_PROFILE_CAMERA_MODEL debProfTerrainModel;
			Mix::Scene::DEBUG_PROFILE_CAMERA_PROJ_SHADOW debProfProjShadow;
			Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_OPACITY debProfDrawOpacity;
			Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_NEUTRALITY debProfDrawNeut;
			Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_REFRACT debProfDrawRefract;
			Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_TRANSPARENCY debProfDrawTransp;
			Mix::Scene::DEBUG_PROFILE_CAMERA_POST_PROCESS debProfPostProc;
#endif //_DEBUG
		};

		//u[^Cv񋓒萔
		enum BLUR_TYPE
		{
			BLUR_3x3 = 0,
			BLUR_5x5 = 1,

			BLUR_TYPE_MAX = 2,
		};

		//KEVAu[LbV\
		struct GAUSSIAN_BLUR_CACHE
		{
			UInt32 width;
			UInt32 height;
			Float32 dispersion;
			Renderer::RENDER_GAUSSIAN_BLUR_ARGS args;
		};

		//Nbho[ebNX\
		struct QUAD_VERTEX
		{
			Mix::Vector4 pos;
			Mix::Vector2 tex;
		};

		//foCXXe[g\
		struct DEVICE_STATE
		{
			Mix::Rectangle scissor;
			Mix::Rectangle viewport;
			Mix::Graphics::RASTERIZER_DESC rasterizer;
			Mix::Graphics::DEPTH_DESC depth;
			Mix::Graphics::BLEND_DESC blend;
			Mix::Graphics::ITexture* pTargetTexture[Mix::Graphics::TARGET_MAX];
			Mix::Graphics::ITexture* pDepthTexture;
		};

		//tHOp[^
		struct INTERNAL_FOG_SETTINGS
		{
			Float32 p0;
			Float32 p1;
		};

		//EH[^[rWA\
		struct WATER_VISUAL
		{
			Mix::Vector4 color;
			Float32 density;
			Float32 intensity;
			Float32 threshold;
			Float32 offset;
		};

		//EH[^[v[\
		struct WATER_POOL
		{
			const Mix::Geometry::AABB* pBounds;
			const Mix::Scene::IWaterPoolContext* pContext;
		};

		//[JCg̊ReLXg\
		struct ASSIGN_LOCAL_LIGHT_CONTEXT
		{
			UInt32 preCount;

			UInt32* id;
			UInt32* count;

#ifdef _DEBUG
			ASSIGN_LOCAL_LIGHT_CONTEXT( void )
			{
				preCount = 0;
				id = NULL;
				count = NULL;
			}
#endif //_DEBUG
		};

		//IuWFNg^Cv񋓒萔
		enum TRANSPARENCY_OBJECT_TYPE
		{
			TO_WIDGET	= 0,	// EBWFbg
			TO_MODEL	= 1,	// f
			TO_TERM		= 2,	// I[
		};

		//IuWFNg\
		struct TRANSPARENCY_OBJECT
		{
			//  //

			UInt32 type; // TRANSPARENCY_OBJECT_TYPE

			// \[g //

			UInt32 refractClass;

			Float32 minZ;
			Float32 maxZ;

			UInt32 priority;

			Float32 z;

			// ʂ̃R}h //

			UInt32 worldMatID;
			UInt32 worldMatNum;

			UInt32 localLightID;
			UInt32 localLightNum;

			Mix::Scene::IMaterial::TRANSFORM_TYPE trType;
			Mix::Graphics::PRIMITIVE_TYPE prType;

			Mix::Scene::IMaterial* pMaterial;

			// ŗL̃R}h //

			union
			{
				UInt8 data[32];

				//EBWFbg
				struct
				{
					UInt32 quadNum;
					Mix::Scene::Common::WIDGET_QUAD** quads;
				};

				//f
				struct
				{
					UInt32 vertexStart;
					UInt32 vertexNum;

					UInt32 indexStart;
					UInt32 indexNum;

					Mix::Graphics::IVertexBuffer* pVertexBuffer;
					Mix::Graphics::IIndexBuffer* pIndexBuffer;
				};
			};
		};

		//IuWFNg\[^[
		class TransparencyObjectSorter
		{
		private:
			Int32* m_LeftStack;
			Int32* m_RightStack;
			UInt32 m_StackCapacity;
			UInt32 m_ResizeStep;

		public:
			TransparencyObjectSorter( UInt32 defStackCapacity, UInt32 resizeStep );
			~TransparencyObjectSorter( void );

			void Execute( Renderer::TRANSPARENCY_OBJECT** list, Int32 left, Int32 right );

		private:
			static inline Int32 Compare( const Renderer::TRANSPARENCY_OBJECT* lhs, const Renderer::TRANSPARENCY_OBJECT* rhs )
			{
				if( lhs->minZ > rhs->maxZ )
				{
					return +1;
				}
				else if( lhs->maxZ < rhs->minZ )
				{
					return -1;
				}

				if( lhs->priority < rhs->priority )
				{
					if( lhs->minZ < rhs->z )
					{
						return +1;
					}
				}
				else if( lhs->priority > rhs->priority )
				{
					if( rhs->maxZ > lhs->z )
					{
						return -1;
					}
				}

				if( lhs->z > rhs->z )
				{
					return 1;
				}
				else if( lhs->z < rhs->z )
				{
					return -1;
				}

				return 0;
			}
		};

		//`R}h\
		struct DRAW_COMMAND
		{
			UInt32 worldMatID;
			UInt32 worldMatCount;

			UInt32 vertexStart;
			UInt32 vertexCount;
			UInt32 indexStart;
			UInt32 indexCount;

			Mix::Scene::IMaterial* pMaterial;
			Mix::Scene::IMaterial::TRANSFORM_TYPE trType;

			Mix::Graphics::IVertexBuffer* pVertexBuffer;
			Mix::Graphics::IIndexBuffer* pIndexBuffer;

			Mix::Graphics::PRIMITIVE_TYPE primitiveType;
		};

		//VhER}h\
		struct SHADOW_COMMAND : public DRAW_COMMAND
		{
			Boolean bTransparency;
		};

		//J[R}h\
		struct COLOR_COMMAND : public DRAW_COMMAND
		{
			UInt32 localLightID;
			UInt32 localLightCount;
		};

		//sR}h\
		struct OPACITY_COMMAND : public Renderer::COLOR_COMMAND
		{
			UInt64 sortKey;
		};

		//R}h\
		struct TRANSPARENCY_COMMAND : public Renderer::COLOR_COMMAND
		{
			UInt32 refractClass;
		};

		typedef std::vector<UInt32> IndexList;
		typedef std::vector<Renderer::CAMERA> CameraList;
		typedef std::vector<Renderer::VIEW> ViewList;
		typedef std::vector<Mix::Scene::Common::SpotLight*> SpotLightList;
		typedef std::vector<Mix::Scene::Common::PointLight*> PointLightList;
		typedef std::vector<Mix::Scene::Common::WaterPool*> WaterPoolList;
		typedef std::vector<Mix::Scene::Common::LeavingParticle*> LeavingParticleList;
		typedef std::vector<Mix::Scene::Common::ScatterParticle*> ScatterParticleList;
		typedef std::vector<Mix::Scene::Common::ActorModel*> ActorModelList;
		typedef std::vector<Mix::Scene::Common::TerrainModel*> TerrainModelList;
		typedef std::vector<Mix::Scene::Common::Planter*> PlanterList;
		typedef std::vector<Mix::Scene::Common::Ghost*> GhostList;

		typedef Mix::DynamicContainer<Mix::Scene::Common::LOCAL_LIGHT> VisibleLocalLightList;
		typedef Mix::Container<const Mix::Scene::Common::LOCAL_LIGHT*> LocalLightList;
		typedef Mix::Container<Renderer::WATER_POOL> VisibleWaterPoolList;
		typedef Mix::Container<Mix::Matrix4x4> MatrixList;
		typedef Mix::Container<Mix::Scene::Common::WIDGET_SUBSET*> WidgetSubsetList;
		typedef Mix::DynamicContainer<Mix::Scene::Common::WIDGET_OBJECT> WidgetObjectList;
		typedef Mix::DynamicContainer<Renderer::TRANSPARENCY_OBJECT> TransparencyObjectList;
		typedef Mix::DynamicContainer<Renderer::SHADOW_COMMAND> ShadowCommandList;
		typedef Mix::DynamicContainer<Renderer::OPACITY_COMMAND> OpacityCommandList;
		typedef Mix::DynamicContainer<Renderer::TRANSPARENCY_COMMAND> TransparencyCommandList;
		typedef Mix::Container<Renderer::TRANSPARENCY_COMMAND*> TransparencyCommandPtrList;
		typedef Mix::Container<Renderer::DRAW_COMMAND> RefractMaskCommandList;

#ifdef _DEBUG
		typedef Mix::Container<Mix::Scene::Common::SpotLight*> DebugSpotLightList;
		typedef Mix::Container<Mix::Scene::Common::PointLight*> DebugPointLightList;
		typedef Mix::Container<Mix::Scene::Common::WaterPool*> DebugWaterPoolList;
		typedef Mix::Container<Mix::Scene::Common::Planter*> DebugVisiblePlanterList;
		typedef Mix::Container<Mix::Scene::Common::LeavingParticle*> DebugLeavingParticleList;
		typedef Mix::Container<Mix::Scene::Common::ScatterParticleUnit*> DebugScatterParticleUnitList;
		typedef Mix::Container<Mix::Scene::Common::ActorModel*> DebugActorModelList;
		typedef Mix::Container<Mix::Geometry::Sphere> DebugSphereList;
		typedef Mix::Container<Mix::Geometry::AABB> DebugAABBList;
#endif //_DEBUG

	protected:
		Mix::IEngine* m_pEngine;
		Mix::Graphics::IManager* m_pGraphicsMgr;
		Mix::Graphics::IDevice* m_pGraphicsDev;
		Mix::Scene::Common::Factory* m_pFactory;

		Mix::Scene::Common::ResourceManager* m_pResourceMgr;
		Mix::Scene::Common::Octree* m_pOctree;

		Float32 m_QuadOffset;
		Mix::Graphics::IVertexBuffer* m_pQuadBuffer;

		Mix::Graphics::IVertexLayout* m_pSamplingVL;
		Mix::Graphics::IVertexShader* m_pSamplingVS;
		Mix::Graphics::IPixelShader* m_pSamplingPS[Mix::Scene::Common::RST_MAX];

		Mix::Graphics::IPixelShader* m_pBlurPS[Renderer::BLUR_TYPE_MAX][Renderer::BLUR_DIR_MAX];

		Renderer::GAUSSIAN_BLUR_CACHE m_GaussianBlurCache;
		Mix::Graphics::IVertexShader* m_pGaussianBlurVS[Renderer::BLUR_DIR_MAX];
		Mix::Graphics::IPixelShader* m_pGaussianBlurPS[Renderer::BLUR_DIR_MAX];

		Mix::Graphics::IPixelShader* m_pGaussianBlurExPS;

		Mix::Graphics::IPixelShader* m_pLumTransformPS[Renderer::LUM_TF_MAX];
		Mix::Graphics::IPixelShader* m_pLumAdaptedPS;
		Mix::Graphics::IPixelShader* m_pLumOperatorPS[Renderer::LUM_OP_TA_MAX][Renderer::LUM_OP_B_MAX];

		Mix::Graphics::IPixelShader* m_pBrightPassPS[Renderer::BP_L_MAX][Renderer::BP_A_MAX];

		Mix::Graphics::IVertexLayout* m_pSkyDomeVL;
		Mix::Graphics::IVertexShader* m_pSkyDomeVS;
		Mix::Graphics::IPixelShader* m_pSkyDomePS[Renderer::SD_BASE_MAX][Renderer::SD_CLOUD_L_MAX][Renderer::SD_CLOUD_S_MAX];

		Mix::Graphics::IVertexLayout* m_pPanoramaVL;
		Mix::Graphics::IVertexShader* m_pPanoramaVS[Renderer::SD_PR_MAX];
		Mix::Graphics::IPixelShader* m_pPanoramaPS[Renderer::SD_PR_MAX];

		Mix::Graphics::IPixelShader* m_pAmbOcclPS[Renderer::SSAO_TYPE_MAX];

		Mix::Graphics::IPixelShader* m_pSdwMapSamplingPS[Mix::Scene::Common::RST_MAX];
		Mix::Graphics::IPixelShader* m_pSdwMapFinishPS;

		Mix::Graphics::IPixelShader* m_pUnderWaterPS;

		Mix::Graphics::IPixelShader* m_pLSInitPS[Renderer::LS_INIT_A_MAX];
		Mix::Graphics::IPixelShader* m_pLSBlurPS[Renderer::LS_BLUR_TYPE_MAX];

		Mix::Graphics::IPixelShader* m_pLFImagePS[Renderer::LF_I_G_MAX][Renderer::LF_I_H_MAX];
		Mix::Graphics::IPixelShader* m_pLFModifyPS[Renderer::LF_M_D_MAX][Renderer::LF_M_B_MAX];

		Mix::Graphics::IPixelShader* m_pFilmicPS[Mix::Scene::Common::Camera::FI_MAX];

		Mix::Graphics::IPixelShader* m_pCAImagePS[Renderer::CA_I_K_MAX];
		Mix::Graphics::IPixelShader* m_pCAFinishPS[Renderer::CA_F_D_MAX];

		Mix::Graphics::IPixelShader* m_pGammaPS;

		Mix::Graphics::IPixelShader* m_pDofPS;

		Mix::Graphics::IPixelShader* m_pLensDistortionPS[Renderer::LD_K_MAX];

		Mix::Graphics::IPixelShader* m_pVignettePS;

		Mix::Graphics::IPixelShader* m_pAntiAliasingPS;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// ̃Xy[X̓r[( Renderer::VIEW )WĴƁAr[ɊւC^[tF[XA
		// p[^WĴɂȂ܂B
		// ƂɃC^[tFXׂ̉͂炸

		Mix::Scene::Common::Camera* m_pCamera;

		Mix::Vector4 m_BackgroundColor;

		Mix::Rectangle m_Viewport;
		Mix::Graphics::ITexture* m_pDepthBuff;
		Mix::Graphics::Utility::ITargetTextureChain* m_pColorTexChain;
		Mix::Graphics::Utility::ITargetTextureChain* m_pDepthTexChain;
		Mix::Graphics::ITexture* m_pDataTex;
		Mix::Graphics::ITexture* m_pRefractTex;

		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_AOSamplingType;
		Mix::Graphics::ITexture* m_pAOTex;
		Mix::Graphics::Utility::ITargetTextureChain* m_pAOTexChain;

		Mix::Rectangle m_SdwViewport;
		Mix::Matrix4x4 m_SdwBiasMat;
		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_SdwMapSamplingType;
		Mix::Vector4* m_pSdwMapSamplingTable;
		Mix::Graphics::ITexture* m_pSdwDepthBuff;
		Mix::Graphics::ITexture* m_pSdwDepthTex;
		Mix::Graphics::ITexture* m_pSdwMapTex;
		Mix::Graphics::Utility::ITargetTextureChain* m_pSdwMapTexChain;

		Mix::Graphics::ITexture* m_pLumInitalTex;
		Mix::Graphics::ITexture* m_pLumFinalTex;
		Renderer::TextureList* m_pLumIterateTexList;
		Mix::Graphics::Utility::ITargetTextureChain* m_pLumAdaptedTexChain;

		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_BloomSamplingType;
		Renderer::TextureChainList* m_pBloomTexChainList;

		Mix::Rectangle m_LSViewport;
		Mix::Graphics::Utility::ITargetTextureChain* m_pLSTexChain;

		Mix::Rectangle m_LFViewport;
		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_LFSamplingType;
		Mix::Graphics::Utility::ITargetTextureChain* m_pLFTexChain;

		Mix::Rectangle m_CAViewport;
		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_CASamplingType;
		Mix::Graphics::Utility::ITargetTextureChain* m_pCATexChain;

		Mix::Scene::Common::RENDERER_SAMPLING_TYPE m_DofSamplingType;
		Mix::Vector4* m_pDofSamplingTable;
		Mix::Graphics::ITexture* m_pDofBokehTex0;
		Mix::Graphics::ITexture* m_pDofBokehTex1;
		Mix::Graphics::ITexture* m_pDofTempTex;

#ifdef _DEBUG
		Mix::Graphics::ITexture* m_pDebBloomBrightPassTex;
		Mix::Graphics::ITexture* m_pDebLSBrightPassTex;
		Mix::Graphics::ITexture* m_pDebLFBrightPassTex;

		Mix::Scene::DEBUG_PROFILE_CAMERA_GENERAL* m_pDebCProfGeneral;
		Mix::Scene::DEBUG_PROFILE_CAMERA_OCTREE* m_pDebCProfOctree;
		Mix::Scene::DEBUG_PROFILE_CAMERA_LIGHT* m_pDebCProfLight;
		Mix::Scene::DEBUG_PROFILE_CAMERA_WATER_POOL* m_pDebCProfWaterPool;
		Mix::Scene::DEBUG_PROFILE_CAMERA_WIDGET* m_pDebCProfWidget;
		Mix::Scene::DEBUG_PROFILE_CAMERA_MODEL* m_pDebCProfActorModel;
		Mix::Scene::DEBUG_PROFILE_CAMERA_MODEL* m_pDebCProfTerrainModel;
		Mix::Scene::DEBUG_PROFILE_CAMERA_PROJ_SHADOW* m_pDebCProfProjShadow;
		Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_OPACITY* m_pDebCProfDrawOpacity;
		Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_NEUTRALITY* m_pDebCProfDrawNeut;
		Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_REFRACT* m_pDebCProfDrawRefract;
		Mix::Scene::DEBUG_PROFILE_CAMERA_DRAW_TRANSPARENCY* m_pDebCProfDrawTransp;
		Mix::Scene::DEBUG_PROFILE_CAMERA_POST_PROCESS* m_pDebCProfPostProc;
#endif //_DEBUG

		////////////////////////////////////////////////////////////////////////////////////////////////////

		Mix::StringW m_Name;

		Mix::Scene::RENDERER_CONFIG m_Config;

		Boolean m_bDynamicsAvailable;
		Boolean m_bAtmosphereAvailable;
		Boolean m_bFogAvailable;
		Boolean m_bWidgetAvailable;
		Boolean m_bShadowMappingAvailable;
		Boolean m_bAmbientOcclusionAvailable;
		Boolean m_bLuminosityAvailable;
		Boolean m_bBloomAvailable;
		Boolean m_bLightShaftsAvailable;
		Boolean m_bLensFlareAvailable;
		Boolean m_bChromatismAvailable;
		Boolean m_bDepthOfFieldAvailable;

		Mix::Vector4 m_GlobalAmbientColor;

		Mix::Graphics::ITexture* m_pGlobalTextures[Renderer::GLOBAL_TEX_MAX];

		Boolean m_bFogEnabled;
		Mix::Scene::IRenderer::FOG_SETTINGS m_FogSettings;
		Renderer::INTERNAL_FOG_SETTINGS m_InternalFogSettings;

		Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE m_WidgetLightingMode;

		Renderer::CameraList m_CameraList;
		Renderer::ViewList m_ViewList;
		Mix::Scene::Common::HemisphereLight* m_pHemisphereLight;
		Mix::Scene::Common::DirectionalLight* m_pDirectionalLight;
		Renderer::SpotLightList m_SpotLightList;
		Renderer::PointLightList m_PointLightList;
		Mix::Scene::Common::SkyDome* m_pSkyDome;
		Renderer::LeavingParticleList m_LeavingParticleList;
		Renderer::ScatterParticleList m_ScatterParticleList;
		Renderer::ActorModelList m_ActorModelList;
		Renderer::TerrainModelList m_TerrainModelList;
		Renderer::PlanterList m_PlanterList;
		Renderer::WaterPoolList m_WaterPoolList;
		Mix::Scene::Common::Floor* m_pFloor;
		Renderer::GhostList m_GhostList;

		Mix::Scene::Common::AtmosphereScatter* m_pAtmosphereScatter;
		Mix::Scene::Common::ShadowProjector* m_pShadowProjector;
		Mix::Scene::Common::LightShaftsCaster* m_pLightShaftsCaster;
		Mix::Scene::Common::DynamicsWorld* m_pDynamicsWorld;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		Renderer::DEVICE_STATE m_DeviceState;

		Mix::Matrix4x4 m_SdwLightMat;
		Mix::Matrix4x4 m_SdwLightBiasMat;
		Renderer::ShadowCommandList m_ShadowComList;

		Renderer::VisibleWaterPoolList m_VisibleWaterPoolList;
		Renderer::WATER_VISUAL m_WaterVisual;
		Mix::Scene::Common::RENDERER_REFRACT_CLASS m_RefractClassTable[Mix::Scene::WCR_MAX];

		Renderer::VisibleLocalLightList m_VisibleLocalLightList;

		UInt32 m_WidgetQuadCount;
		Renderer::WidgetSubsetList m_WidgetSubsetList;
		Renderer::WidgetObjectList m_WidgetObjectList;
		Mix::Graphics::IVertexBuffer* m_pWidgetBuffer;

		Renderer::LocalLightList m_LocalLightList;
		Renderer::MatrixList m_WorldMatrixList;
		Renderer::TransparencyObjectSorter m_TransparencyObjSorter;
		Renderer::TransparencyObjectList m_TransparencyObjList;
		Renderer::OpacityCommandList m_OpacityComList;
		Renderer::TransparencyCommandList m_TransparencyComList;
		Renderer::TransparencyCommandPtrList m_TransparencyBackComList;
		Renderer::TransparencyCommandPtrList m_TransparencyFrontComList;
		Renderer::RefractMaskCommandList m_RefractMaskComList;
		Renderer::OpacityCommandList m_RefractComList;

		UInt32 m_CurWorldMatID;
		Mix::Scene::IMaterial* m_pCurMaterial;
		UInt32 m_CurLocalLightID;

	private:
#ifdef _DEBUG
		Mix::Timer m_DebTotalTimer;
		Mix::Timer m_DebTimer;

		UInt32 m_DebRProfGeneIndex;
		Mix::Scene::DEBUG_PROFILE_RENDERER_GENERAL m_DebRProfGeneral[2];
		Mix::Scene::DEBUG_PROFILE_RENDERER_GENERAL* m_pDebRProfGeneralCur;
		Mix::Scene::DEBUG_PROFILE_RENDERER_GENERAL* m_pDebRProfGeneral;
		Mix::Scene::DEBUG_PROFILE_RENDERER_OCTREE m_DebRProfOctree;
		Mix::Scene::DEBUG_PROFILE_RENDERER_DYNAMICS m_DebRProfDynamics;

		Renderer::DebugSpotLightList m_DebSpotLightList;
		Renderer::DebugPointLightList m_DebPointLightList;
		Renderer::DebugWaterPoolList m_DebWaterPoolList;
		Renderer::DebugVisiblePlanterList m_DebVisiblePlanterList;
		Renderer::DebugLeavingParticleList m_DebLeavingParticleList;
		Renderer::DebugScatterParticleUnitList m_DebScatterParticleUnitList;
		Renderer::DebugAABBList m_DebWidgetBoundsList;
		Renderer::DebugActorModelList m_DebActorModelList;
		Renderer::DebugAABBList m_DebTerrainBoundsList;

		Mix::Graphics::Utility::ILineArt* m_pDebLineArt;
		Mix::Graphics::Utility::ICanvas* m_pDebCanvas;
#endif //_DEBUG

	private:
		Boolean UpdateConfig( const wchar_t* pErrorTitle, const Mix::Scene::RENDERER_CONFIG& config );

		// eR}h //////////

		void CollectShadowCommand( void );

		void CollectShadowCommand_ActorModel( const Mix::Geometry::Sphere& clipBounds );
		Boolean AddShadowCommand( const Mix::Geometry::Sphere& clipBounds, Mix::Scene::Common::ActorModel* pModel );

		void CollectShadowCommand_TerrainModel( const Mix::Geometry::Sphere& clipBounds );
		Boolean AddShadowCommand(	const Mix::Geometry::Sphere& clipBounds,
									UInt32 worldMatID,
									Mix::Scene::Common::TerrainModel* pModel,
									Mix::Scene::Common::TerrainNode* pNode,
									UInt32& meshCount );

		// `R}h //////////

		void CollectDrawCommand( void );

		void CollectDrawCommand_LocalLight( void );
		static void SortLocalLight( Mix::Scene::Common::LOCAL_LIGHT** list, Int32 first, Int32 last ); //O( maxZ )

		void CollectDrawCommand_WaterPool( void );

		void CollectDrawCommand_Widget( void );
		void CollectWidgetSubset_Planter( void );
		void CollectWidgetSubset_LeavingParticle( void );
		void CollectWidgetSubset_ScatterParticle( void );
		void FinishWidget_Everyone( void );
		void FinishWidget_Detailed( void );
		void FinishWidget_GenerateTransparencyObjects( void );
		void FinishWidget_GenerateTransparencyObjects( UInt32 localLightID, UInt32 localLightCount );
		Boolean NeedsWidgetObject( Boolean bLightingObject, Float32 objZ, Float32 lightingZ );
		static void SortWidgetObjects_MinZ( Mix::Scene::Common::WIDGET_OBJECT** list, Int32 first, Int32 last ); //O( minZ )

		void CollectDrawCommand_ActorModel( void );
		Boolean AddDrawCommand(	const Mix::Geometry::Frustum& frustum,
								const Mix::Geometry::Plane& nearPlane,
								Mix::Scene::Common::ActorModel* pModel );

		void CollectDrawCommand_TerrainModel( void );
		Boolean AddDrawCommand(	const Mix::Geometry::Frustum& frustum,
								const Mix::Geometry::Plane& nearPlane,
								UInt32 worldMatID,
								Mix::Scene::Common::TerrainModel* pModel,
								Mix::Scene::Common::TerrainNode* pNode,
								UInt32& meshCount );

		void CollectDrawCommand_FinishTransparency( void );

		UInt32 ReserveWorldMatrix( void );
		UInt32 AssignWorldMatrix( const Mix::Matrix4x4& mat );
		void AssignWorldMatrix( const Mix::Matrix4x4& mat, UInt32 id );
		UInt32 AssignWorldMatrix( const std::vector<Mix::Matrix4x4>& matList );

		void AssignLocalLight( const Mix::Geometry::Plane& nearPlane, const Mix::Geometry::Sphere& bounds, UInt32& id, UInt32& count );
		void AssignLocalLight( const Mix::Geometry::Plane& nearPlane, const Mix::Geometry::AABB& bounds, UInt32& id, UInt32& count );
		void AssignLocalLight( const Mix::Geometry::AABB& bounds, Float32 minZ, Float32 maxZ, UInt32& id, UInt32& count );
		void AssignLocalLight( UInt32 objNum, Mix::Scene::Common::WIDGET_OBJECT** objs, UInt32& id, UInt32& count );
		Boolean AssignLocalLight_Begin( Renderer::ASSIGN_LOCAL_LIGHT_CONTEXT& ctx, UInt32& id, UInt32& count );
		void AssignLocalLight_End( Renderer::ASSIGN_LOCAL_LIGHT_CONTEXT& ctx );
		static void AssignLocalLight_Sort( const Mix::Scene::Common::LOCAL_LIGHT** list, Int32 first, Int32 last );

		Mix::Scene::Common::RENDERER_REFRACT_CLASS ClassifyRefract( Mix::Scene::WATER_CONTAINS_RESULT wcr, const Mix::Geometry::Sphere& bounds ) const;
		Mix::Scene::Common::RENDERER_REFRACT_CLASS ClassifyRefract( Mix::Scene::WATER_CONTAINS_RESULT wcr, const Mix::Geometry::AABB& bounds ) const;

		// R}h̏ //////////

		void ProcessCommand( void );

		static void SortShadowCommand( Renderer::SHADOW_COMMAND** list, Int32 first, Int32 last );
		static void SortOpacityCommand( Renderer::OPACITY_COMMAND** list, Int32 first, Int32 last );

		void ProcessCommand_AmbientOcclusion( void );

		Mix::Matrix4x4 SkyDome_ComputeWorldMatrix( void ) const;
		Mix::Graphics::IPixelShader* SkyDome_GetPixelShader( void ) const;
		void ProcessCommand_RenderSkyDome_Default( Mix::Graphics::FILL_TYPE fillType );
		void ProcessCommand_RenderSkyDome_AtmosphereScattering( Mix::Graphics::FILL_TYPE fillType );
		void ProcessCommand_RenderSkyDome_Panorama( Mix::Graphics::FILL_TYPE fillType );

		void ProcessCommand_RenderTransparency( Mix::Container<Renderer::TRANSPARENCY_COMMAND*>& list, Mix::Graphics::FILL_TYPE fillType, Float32 invFarZ );

		void Command_PrepareRendering( Float32 invFarZ );
		void Command_Reset( void );
		void Command_Transform( const Renderer::DRAW_COMMAND* pCom );
		void Command_ChangeMaterial_Shadow( const Renderer::SHADOW_COMMAND* pCom );
		void Command_ChangeMaterial_Mask( const Renderer::DRAW_COMMAND* pCom );
		void Command_ChangeMaterial_Color( const Renderer::COLOR_COMMAND* pCom, Float32 invFarZ );
		void Command_PlacementLocalLight( const Renderer::COLOR_COMMAND* pCom );
		void Command_DrawPrimitives( const Renderer::DRAW_COMMAND* pCom );

		// |XgvZX //////////

		void PostProcess( void );
		void PostProcess_ShadowMapping( void );
		void PostProcess_UnderWater( void );
		void PostProcess_LumTransform( void );
		void PostProcess_Bloom(	void );
		void PostProcess_LightShafts( void );
		void PostProcess_LensFlare( void );
		void PostProcess_LumOperation( void );
		void PostProcess_Filmic( void );
		void PostProcess_GammaCorrection( void );
		void PostProcess_Chromatism( void );
		void PostProcess_Dof( void );
		void PostProcess_LensDistortion( void );
		void PostProcess_Vignette( void );
		void PostProcess_AntiAliasing( void );
		void PostProcess_Final( void );

		// N[Abv //////////

		void CleanupWork( void );

		// ̑ //////////

		void RenderSampling(	Mix::Graphics::Utility::ITargetTextureChain* pTexChain );
		void RenderSampling(	Mix::Graphics::COLOR_WRITE_MASK mask,
								Mix::Graphics::ITexture* pSource, Mix::Graphics::ITexture* pTarget );
		void RenderSampling(	Mix::Scene::Common::RENDERER_SAMPLING_TYPE type,
								Float32 colorScale,
								Mix::Graphics::BLEND_TYPE blendMode,
								Mix::Graphics::TEXTURE_FILTER_TYPE filter,
								Mix::Graphics::ITexture* pSoruce,
								Mix::Graphics::ITexture* pTarget );
		void RenderSampling(	Mix::Scene::Common::RENDERER_SAMPLING_TYPE type,
								Mix::Graphics::COLOR_WRITE_MASK mask,
								Mix::Graphics::BLEND_TYPE blendMode,
								Mix::Graphics::TEXTURE_FILTER_TYPE filter,
								Mix::Graphics::ITexture* pSoruce,
								Mix::Graphics::ITexture* pTarget );

		void RenderBrightPass( const Mix::Scene::BRIGHT_PASS& bp, Mix::Graphics::ITexture* pSourceTex, Mix::Graphics::ITexture* pTargetTex );

		void RenderBlur(	const Mix::Scene::BLUR& param, Mix::Graphics::Utility::ITargetTextureChain* pTextureChain );
		void RenderBlur(	const Mix::Scene::BLUR& param,
							Mix::Graphics::ITexture* pSourceTex,
							Mix::Graphics::ITexture* pTargetTex,
							Mix::Graphics::ITexture* pTempTex );

		void RenderBlur(	Renderer::BLUR_TYPE type, Int32 iteration,
							Mix::Graphics::Utility::ITargetTextureChain* pTextureChain );
		void RenderBlur(	Renderer::BLUR_TYPE type, Int32 iteration,
							Mix::Graphics::ITexture* pSourceTex,
							Mix::Graphics::ITexture* pTargetTex,
							Mix::Graphics::ITexture* pTempTex );

		void RenderGaussianBlur(	Float32 dispersion,
									Mix::Graphics::Utility::ITargetTextureChain* pTextureChain );
		void RenderGaussianBlur(	Float32 dispersion,
									Mix::Graphics::ITexture* pSourceTex,
									Mix::Graphics::ITexture* pTargetTex,
									Mix::Graphics::ITexture* pTempTex );

		const Renderer::RENDER_GAUSSIAN_BLUR_ARGS& ComputeGauusianBlurArgs( UInt32 width, UInt32 height, Float32 dispersion );

		void RenderGaussianBlurEx(	Int32 radius,
									Mix::Graphics::Utility::ITargetTextureChain* pTextureChain );
		void RenderGaussianBlurEx(	Int32 radius,
									Mix::Graphics::ITexture* pSourceTex,
									Mix::Graphics::ITexture* pTargetTex,
									Mix::Graphics::ITexture* pTempTex );

		static Renderer::RENDER_GAUSSIAN_BLUR_EX_ARGS ComputeGaussianExArgs( Int32 radius );

		void RenderChromatismImage( Float32 k, Float32 kCube, Float32 scale,
									const Mix::Vector4& colorFactor,
									Mix::Graphics::ITexture* pSourceTex,
									Mix::Graphics::ITexture* pTargetTex );

		void RenderSamplingSM(	Mix::Scene::Common::RENDERER_SAMPLING_TYPE type,
								Mix::Graphics::BLEND_TYPE blendMode,
								Mix::Graphics::TEXTURE_FILTER_TYPE filter,
								Mix::Graphics::ITexture* pSoruce,
								Mix::Graphics::ITexture* pTarget );

		void RenderSmoothShade(	Boolean bShadowMapping,
								Mix::Scene::Common::RENDERER_SAMPLING_TYPE smpType,
								const Mix::Scene::BLUR& blur,
								Mix::Graphics::ITexture* pTex,
								Mix::Graphics::Utility::ITargetTextureChain* pTexChain );

		void DrawQuad( void );
		void DrawQuad( UInt32 tw, UInt32 th, Float32 dx, Float32 dy, Float32 dw, Float32 dh );

		// fobO //////////

#ifdef _DEBUG
		void Debug_Draw3D( void );
		void Debug_Draw2D( void );

		void Debug_DrawDistortion2D( Float32 k, Float32 kCube, Float32 scale );
		Mix::Vector2 Debug_Distortion( const Mix::Vector2& p, Float32 k, Float32 kCube, Float32 scale );

		void Debug_DrawFilmic( void );
		Float32 Debug_TonemapHejl( Float32 x );
		Float32 Debug_TonemapHable( Float32 A, Float32 B, Float32 C, Float32 D, Float32 E, Float32 F, Float32 x );

		Boolean Debug_CollectTerrainBounds(	const Mix::Geometry::Frustum& frustum,
											Mix::Scene::Common::TerrainModel* pModel,
											Mix::Scene::Common::TerrainNode* pNode,
											UInt32& meshCount );

		static UInt32 Debug_CountPrimitive( Mix::Graphics::PRIMITIVE_TYPE type, UInt32 indexCount );
#endif //_DEBUG

	protected:
		Renderer( Mix::Scene::Common::Factory* pFactory, const wchar_t* pName );
		virtual ~Renderer( void );

		virtual void OnPrepareRendering( const Renderer::PREPARE_REDNERING_EVENT_ARGS& e ) {}
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_DEFAULT_EVENT_ARGS& e ) {}
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_ATMOSPHERE_EVENT_ARGS& e ) {}
		virtual void OnRenderPanorama( const Renderer::SKYDOME_PANORAMA_EVENT_ARGS& e ) {}
		virtual void OnTransform( const Renderer::TRANSFORM_EVENT_ARGS& e ) {}
		virtual void OnPlacementLocalLight( const Renderer::LOCALLIGHT_EVENT_ARGS& e ) {}

		virtual void OnRenderUnderWater( const Renderer::UNDERWATER_EVENT_ARGS& e ) {}
		virtual void OnRenderAmbientOcclusion( const Renderer::RENDER_AMBIENT_OCCLUSION_ARGS& e ) {}
		virtual void OnRenderShadowMapping( const Renderer::RENDER_SHADOW_MAPPING_ARGS& e ) {}
		virtual void OnRenderLumTransform( const Renderer::RENDER_LUM_TRANSFORM_ARGS& e ) {}
		virtual void OnRenderLumAdapted( const Renderer::RENDER_LUM_ADAPTED_ARGS& e ) {}
		virtual void OnRenderLumOperator( const Renderer::RENDER_LUM_OPERATOR_ARGS& e ) {}
		virtual void OnRenderLightShaftsInit( const Renderer::RENDER_LIGHT_SHAFTS_INIT_ARGS& e ) {}
		virtual void OnRenderLightShaftsBlur( const Renderer::RENDER_LIGHT_SHAFTS_BLUR_ARGS& e ) {}
		virtual void OnRenderLensFlareImage( const Renderer::RENDER_LENSFLARE_IMAGE_ARGS& e ) {}
		virtual void OnRenderLensFlareModify( const Renderer::RENDER_LENSFLARE_MODIFY_ARGS& e ) {}
		virtual void OnRenderFilmicHable( const Renderer::RENDER_FILMIC_HABLE_ARGS& e ) {}
		virtual void OnRenderChromatismImage( const Renderer::RENDER_CHROMATISM_IMAGE_ARGS& e ) {}
		virtual void OnRenderChromatismFinish( const Renderer::RENDER_CHROMATISM_FINISH_ARGS& e ) {}
		virtual void OnRenderGammaCorrect( const Renderer::RENDER_GAMMA_ARGS& e ) {}
		virtual void OnRenderLensDistortion( const Renderer::RENDER_LENS_DISTORTION_ARGS& e ) {}
		virtual void OnRenderDof( const Renderer::RENDER_DOF_ARGS& e ) {}
		virtual void OnRenderVignette( const Renderer::RENDER_VIGNETTE_ARGS& e ) {}
		virtual void OnRenderFXAA( const Renderer::RENDER_FXAA_ARGS& e ) {}

		virtual void OnRenderSampling( const Renderer::RENDER_SAMPLING_ARGS& e ) {}
		virtual void OnRenderBlur( const Renderer::RENDER_BLUR_ARGS& e ) {}
		virtual void OnRenderGaussianBlur( const Renderer::RENDER_GAUSSIAN_BLUR_ARGS& e ) {}
		virtual void OnRenderGaussianBlurEx( const Renderer::RENDER_GAUSSIAN_BLUR_EX_ARGS& e ) {}
		virtual void OnRenderBrightPass( const Renderer::RENDER_BRIGHTPASS_ARGS& e ) {}

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Standard::Renderer
		////////////////////////////////////////////////////////////////////////////////////////////////////

		Boolean Initialize( const Mix::Scene::RENDERER_CONFIG& config, const void* pData );

		void ReleaseCameraResource( Renderer::VIEW* pView );
		void CancelDragObject( Renderer::VIEW* pView );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::Renderer
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual void AddCameraView( Mix::Scene::Common::Camera* pInternalCamera );
		virtual void RemoveCameraView( UInt32 viewID );
		virtual Boolean UpdateCameraConfig( UInt32 viewID, const Mix::Scene::CAMERA_CONFIG& config, UInt32& modCaps );

		virtual Boolean DragObject( UInt32 viewID, const Mix::Rectangle& viewRect, const Mix::Point& pos );

		virtual void Draw( UInt32 viewID );
		virtual void Finish( void );

#ifdef _DEBUG
		virtual UInt32 Debug_GetCameraProfile( UInt32 viewID, UInt32 type, void* pProf, UInt32 size ) const;
		virtual UInt32 Debug_GetCameraImageNum( UInt32 viewID, UInt32 type ) const;
		virtual Boolean Debug_GetCameraImage( UInt32 viewID, UInt32 type, UInt32 index, Mix::Graphics::ITexture** ppTexture );
#endif //_DEBUG

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRenderer
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRenderer::TYPE GetType( void ) const;

		virtual const wchar_t* GetName( void ) const;

		virtual const Mix::Scene::RENDERER_CONFIG& GetConfig( void ) const;
		virtual Boolean SetConfig( const Mix::Scene::RENDERER_CONFIG& cfg );

		virtual Boolean IsDynamicsAvailable( void ) const;
		virtual Boolean IsAtmosphereAvailable( void ) const;
		virtual Boolean IsFogAvailable( void ) const;
		virtual Boolean IsWidgetAvailable( void ) const;
		virtual Boolean IsShadowMappingAvailable( void ) const;
		virtual Boolean IsAmbientOcclusionAvailable( void ) const;
		virtual Boolean IsLuminosityAvailable( void ) const;
		virtual Boolean IsBloomAvailable( void ) const;
		virtual Boolean IsLightShaftsAvailable( void ) const;
		virtual Boolean IsLensFlareAvailable( void ) const;
		virtual Boolean IsChromatismAvailable( void ) const;
		virtual Boolean IsDofAvailable( void ) const;

		virtual void Update( Float32 dt, Float32 baseDt );
		virtual void Refresh( void );

		virtual const Mix::Geometry::AABB& GetOctreeBounds( void ) const;

		virtual const Mix::Vector4& GetGlobalAmbientColor( void ) const;
		virtual void SetGlobalAmbientColor( const Mix::Vector4& color );

		virtual Boolean ExistsGlobalTexture( Mix::Scene::IRenderer::GLOBAL_TEXTURE_TYPE type );
		virtual Boolean GetGlobalTexture( Mix::Scene::IRenderer::GLOBAL_TEXTURE_TYPE type, Mix::Graphics::ITexture** ppTexture );
		virtual Boolean SetGlobalTexture( Mix::Scene::IRenderer::GLOBAL_TEXTURE_TYPE type, Mix::Graphics::ITexture* ppTexture );

		virtual Boolean IsFogEnabled( void ) const;
		virtual void SetFogEnabled( Boolean state );
		virtual const Mix::Scene::IRenderer::FOG_SETTINGS& GetFogSettings( void ) const;
		virtual void SetFogSettings( const Mix::Scene::IRenderer::FOG_SETTINGS& param );

		virtual UInt32 GetCameraCount( void ) const;
		virtual void GetCameraByIndex( UInt32 index, Mix::Scene::ICamera** ppCamera );
		virtual Boolean ContainsCamera( Mix::Scene::ICamera* pCamera ) const;
		virtual Boolean AddUniversalCamera( const Mix::Scene::CAMERA_CONFIG& config, Mix::Scene::IUniversalCamera** ppCamera, const wchar_t* pDebugName );
		virtual Boolean AddViewCamera( const Mix::Scene::CAMERA_CONFIG& config, Mix::Scene::IViewCamera** ppCamera, const wchar_t* pDebugName );
		virtual Boolean RemoveCamera( Mix::Scene::ICamera* pCamera );
		virtual void RemoveCameraByIndex( UInt32 index );
		virtual void RemoveAllCamera( void );

		virtual Boolean ExistsHemisphereLight( void ) const;
		virtual Boolean GetHemisphereLight( Mix::Scene::IHemisphereLight** ppHemisphereLight );
		virtual Boolean CreateHemisphereLight( Mix::Scene::IHemisphereLight** ppHemisphereLight );
		virtual void DestroyHemisphereLight( void );

		virtual Boolean ExistsDirectionalLight( void ) const;
		virtual Boolean GetDirectionalLight( Mix::Scene::IDirectionalLight** ppDirectionalLight );
		virtual Boolean CreateDirectionalLight( Mix::Scene::IDirectionalLight** ppDirectionalLight );
		virtual void DestroyDirectionalLight( void );

		virtual UInt32 GetSpotLightCount( void ) const;
		virtual void GetSpotLightByIndex( UInt32 index, Mix::Scene::ISpotLight** ppSpotLight );
		virtual Boolean ContainsSpotLight( Mix::Scene::ISpotLight* pSpotLight ) const;
		virtual Boolean AddSpotLight( Mix::Scene::ISpotLight** ppSpotLight );
		virtual Boolean RemoveSpotLight( Mix::Scene::ISpotLight* pSpotLight );
		virtual void RemoveSpotLightByIndex( UInt32 index );
		virtual void RemoveAllSpotLight( void );

		virtual UInt32 GetPointLightCount( void ) const;
		virtual void GetPointLightByIndex( UInt32 index, Mix::Scene::IPointLight** ppPointLight );
		virtual Boolean ContainsPointLight( Mix::Scene::IPointLight* pPointLight ) const;
		virtual Boolean AddPointLight( Mix::Scene::IPointLight** ppPointLight );
		virtual Boolean RemovePointLight( Mix::Scene::IPointLight* pPointLight );
		virtual void RemovePointLightByIndex( UInt32 index );
		virtual void RemoveAllPointLight( void );

		virtual void GetShadowProjector( Mix::Scene::IShadowProjector** ppShadowProjector );
		virtual void GetLightShaftsCaster( Mix::Scene::ILightShaftsCaster** ppLightShaftsCaster );

		virtual Boolean ExistsSkyDome( void ) const;
		virtual Boolean GetSkyDome( Mix::Scene::ISkyDome** ppSkyDome );
		virtual Boolean CreateSkyDome(	Float32 radius, Float32 height,
										Mix::Scene::ISkyDome::QUALITY heQuality,
										Mix::Scene::ISkyDome** ppSkyDome,
										const wchar_t* pDebugName = NULL );
		virtual Boolean CreateSkyDome(	Float32 radius, Float32 height,
										Mix::Scene::ISkyDome::QUALITY heQuality,
										Mix::Scene::ISkyDome::QUALITY paQuality,
										Mix::Scene::ISkyDome** ppSkyDome,
										const wchar_t* pDebugName );
		virtual void DestroySkyDome( void );

		virtual UInt32 GetLeavingParticleCount( void ) const;
		virtual void GetLeavingParticleByIndex( UInt32 index, Mix::Scene::IParticle** ppParticle );
		virtual Boolean ContainsLeavingParticle( Mix::Scene::IParticle* pParticle ) const;
		virtual Boolean AddLeavingParticle( Mix::Scene::ILeavingParticle* pParticle );
		virtual Boolean RemoveLeavingParticle( Mix::Scene::IParticle* pParticle );
		virtual void RemoveLeavingParticleByIndex( UInt32 index );
		virtual void RemoveAllLeavingParticle( void );

		virtual UInt32 GetScatterParticleCount( void ) const;
		virtual void GetScatterParticleByIndex( UInt32 index, Mix::Scene::IParticle** ppParticle );
		virtual Boolean ContainsScatterParticle( Mix::Scene::IParticle* pParticle ) const;
		virtual Boolean AddScatterParticle( Mix::Scene::IScatterParticle* pParticle );
		virtual Boolean RemoveScatterParticle( Mix::Scene::IParticle* pParticle );
		virtual void RemoveScatterParticleByIndex( UInt32 index );
		virtual void RemoveAllScatterParticle( void );

		virtual UInt32 GetActorModelCount( void ) const;
		virtual void GetActorModelByIndex( UInt32 index, Mix::Scene::IActorModel** ppActorModel );
		virtual Boolean ContainsActorModel( Mix::Scene::IActorModel* pActorModel ) const;
		virtual Boolean AddActorModel( Mix::Scene::IActorModel* pActorModel );
		virtual Boolean RemoveActorModel( Mix::Scene::IActorModel* pActorModel );
		virtual void RemoveActorModelByIndex( UInt32 index );
		virtual void RemoveAllActorModel( void );

		virtual UInt32 GetTerrainModelCount( void ) const;
		virtual void GetTerrainModelByIndex( UInt32 index, Mix::Scene::ITerrainModel** ppTerrainModel );
		virtual Boolean ContainsTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel );
		virtual Boolean AddTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel );
		virtual Boolean RemoveTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel );
		virtual void RemoveTerrainModelByIndex( UInt32 index );
		virtual void RemoveAllTerrainModel( void );

		virtual UInt32 GetPlanterCount( void ) const;
		virtual void GetPlanterByIndex( UInt32 index, Mix::Scene::IPlanter** ppPlanter );
		virtual Boolean ContainsPlanter( Mix::Scene::IPlanter* pPlanter ) const;
		virtual Boolean AddPlanter( Mix::Scene::IMaterial* pMaterial,
									UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
									UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
									Mix::Scene::IPlanter** ppPlanter,
									const wchar_t* pDebugName );
		virtual Boolean AddPlanter( const Mix::Matrix4x4& worldMat,
									Mix::Scene::IMaterial* pMaterial,
									UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
									UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
									Mix::Scene::IPlanter** ppPlanter,
									const wchar_t* pDebugName );
		virtual Boolean RemovePlanter( Mix::Scene::IPlanter* pPlanter );
		virtual void RemovePlanterByIndex( UInt32 index );
		virtual void RemoveAllPlanter( void );

		virtual UInt32 GetWaterPoolCount( void ) const;
		virtual void GetWaterPoolByIndex( UInt32 index, Mix::Scene::IWaterPool** ppWaterPool );
		virtual Boolean ContainsWaterPool( Mix::Scene::IWaterPool* pWaterPool ) const;
		virtual Boolean AddWaterPool( const Mix::Vector3& halfExtents, const Mix::Vector3& worldPos, Mix::Scene::IWaterPool** ppWaterPool, const wchar_t* pDebugName );
		virtual Boolean AddWaterPool( Mix::Scene::IWaterPoolContext* pContext, const Mix::Matrix4x4& worldMat, Mix::Scene::IWaterPool** ppWaterPool, const wchar_t* pDebugName );
		virtual Boolean RemoveWaterPool( Mix::Scene::IWaterPool* pWaterPool );
		virtual void RemoveWaterPoolByIndex( UInt32 index );
		virtual void RemoveAllWaterPool( void );

		virtual Boolean ExistsFloor( void ) const;
		virtual Boolean GetFloor(Mix::Scene::IFloor** ppFloor );
		virtual Boolean CreateFloor( Mix::Scene::IFloor** ppFloor );
		virtual Boolean CreateFloor( const Mix::Vector3& normal, Float32 offset, Mix::Scene::IFloor** ppFloor );
		virtual void DestroyFloor( void );

		virtual UInt32 GetGhostCount( void ) const;
		virtual void GetGhostByIndex( UInt32 index, Mix::Scene::IGhost** ppGhost );
		virtual Boolean ContainsGhost( Mix::Scene::IGhost* pGhost ) const;
		virtual Boolean AddBasisGhost( const wchar_t* pName, Mix::Dynamics::IShape* pShape, Boolean bCollide, Mix::Scene::IGhost** ppGhost );
		virtual Boolean AddKinematicGhost( const wchar_t* pName, Float32 height, Float32 radius, Float32 stepHeight, Mix::Scene::IGhost** ppGhost );
		virtual Boolean RemoveGhost( Mix::Scene::IGhost* pGhost );
		virtual void RemoveGhostByIndex( UInt32 index );
		virtual void RemoveAllGhost( void );

		virtual void GetDynamicsWorld( Mix::Scene::IDynamicsWorld** ppDynamicsWorld );
		virtual void GetAtmosphereScatter( Mix::Scene::IAtmosphereScatter** ppAtmosphereScatter );
		virtual Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE GetWidgetLightingMode( void ) const;
		virtual void SetWidgetLightingMode( Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE mode );

		virtual UInt32 Debug_GetProfile( UInt32 type, void* pProf, UInt32 size ) const;
		virtual Boolean Debug_GetLineArt( Mix::Graphics::Utility::ILineArt** ppLineArt );
		virtual void Debug_SetLineArt( Mix::Graphics::Utility::ILineArt* pLineArt );
		virtual Boolean Debug_GetCanvas( Mix::Graphics::Utility::ICanvas** ppCanvas );
		virtual void Debug_SetCanvas( Mix::Graphics::Utility::ICanvas* pCanvas );

	private:
		static const wchar_t* FAILED_CHANGE_CFG;
		static const wchar_t* FAILED_ADD_UNIVERSAL_CAMERA;
		static const wchar_t* FAILED_ADD_VIEW_CAMERA;
		static const wchar_t* FAILED_ADD_SPOTLIGHT;
		static const wchar_t* FAILED_ADD_POINTLIGHT;

		static const Mix::Graphics::FORMAT DEPTH_BUFF_FORMAT_TABLE[Renderer::DEPTH_BUFF_FORMAT_COUNT];
		static const Mix::Vector4 DOF_SAMPLING_OFFSET_TABLE[Renderer::DOF_SAMPLING_NUM];
		static const Mix::Vector4 SM_SAMPLING_OFFSET_TABLE[Renderer::SM_SAMPLING_NUM];
	};

}}}}
