﻿#include "Mix/Class/Scene/Common/UniversalCamera.h"
#include "Mix/Geometry.h"

namespace Mix{ namespace Scene{ namespace Common{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::Common::UniversalCamera
////////////////////////////////////////////////////////////////////////////////////////////////////

UniversalCamera* UniversalCamera::CreateInstance( Mix::Scene::Common::Renderer* pRenderer, Mix::Scene::Common::OctreeView* pOctView )
{
	return new UniversalCamera( pRenderer, pOctView );
}

UniversalCamera::UniversalCamera(	Mix::Scene::Common::Renderer* pRenderer,
									Mix::Scene::Common::OctreeView* pOctView ) : Mix::Scene::Common::Camera( pRenderer, pOctView ),
m_Up( 0.0f, 10.0f, 0.0f )
{
}

UniversalCamera::~UniversalCamera( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::IUniversalCamera
////////////////////////////////////////////////////////////////////////////////////////////////////

const Mix::Vector3& UniversalCamera::GetUp( void ) const
{
	return m_Up;
}

void UniversalCamera::SetView( const Mix::Vector3& eye, const Mix::Vector3& at, const Mix::Vector3& up )
{
	m_Eye = eye;
	m_At = at;
	m_Up = up;

	Mix::Matrix4x4::LookAtLH( m_Eye, m_At, m_Up, m_ViewMat );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::ICamera
////////////////////////////////////////////////////////////////////////////////////////////////////

UInt32 UniversalCamera::GetID( void ) const
{
	return Camera::GetID();
}

Boolean UniversalCamera::IsAvailabled( void ) const
{
	return Camera::IsAvailabled();
}

const Mix::Scene::CAMERA_CONFIG& UniversalCamera::GetConfig( void ) const
{
	return Camera::GetConfig();
}

Boolean UniversalCamera::SetConfig( const Mix::Scene::CAMERA_CONFIG& config )
{
	return Camera::SetConfig( config );
}

const Mix::Vector4& UniversalCamera::GetBackgroundColor( void ) const
{
	return Camera::GetBackgroundColor();
}

void UniversalCamera::SetBackgroundColor( const Mix::Vector4& color )
{
	Camera::SetBackgroundColor( color );
}

Mix::Graphics::TEXTURE_FILTER_TYPE UniversalCamera::GetFilterType( void ) const
{
	return Camera::GetFilterType();
}

void UniversalCamera::SetFilterType( Mix::Graphics::TEXTURE_FILTER_TYPE type )
{
	Camera::SetFilterType( type );
}

void UniversalCamera::SetProjection( Float32 fovY, Float32 nearZ, Float32 farZ )
{
	Camera::SetProjection( fovY, nearZ, farZ );
}

void UniversalCamera::SetProjection( Float32 fovY, Float32 aspect, Float32 nearZ, Float32 farZ )
{
	Camera::SetProjection( fovY, aspect, nearZ, farZ );
}

void UniversalCamera::SetProjection( Float32 fovY, UInt32 width, UInt32 height, Float32 nearZ, Float32 farZ )
{
	Camera::SetProjection( fovY, width, height, nearZ, farZ );
}

Float32 UniversalCamera::GetFovY( void ) const
{
	return Camera::GetFovY();
}

Float32 UniversalCamera::GetAspect( void ) const
{
	return Camera::GetAspect();
}

Float32 UniversalCamera::GetNearZ( void ) const
{
	return Camera::GetNearZ();
}

Float32 UniversalCamera::GetFarZ( void ) const
{
	return Camera::GetFarZ();
}

const Mix::Matrix4x4& UniversalCamera::GetProjectionMatrix( void ) const
{
	return Camera::GetProjectionMatrix();
}

const Mix::Vector3& UniversalCamera::GetEye( void ) const
{
	return m_Eye;
}

const Mix::Vector3& UniversalCamera::GetAt( void ) const
{
	return m_At;
}

const Mix::Vector3& UniversalCamera::GetViewVector( void ) const
{
	return Camera::GetViewVector();
}

const Mix::Vector3& UniversalCamera::GetViewForward( void ) const
{
	return Camera::GetViewForward();
}

const Mix::Vector3& UniversalCamera::GetViewUpward( void ) const
{
	return Camera::GetViewUpward();
}

const Mix::Vector3& UniversalCamera::GetViewCrossDirection( void ) const
{
	return Camera::GetViewCrossDirection();
}

const Mix::Matrix4x4& UniversalCamera::GetViewMatrix( void ) const
{
	return m_ViewMat;
}

const Mix::Geometry::Frustum& UniversalCamera::GetFrustum( void ) const
{
	return Camera::GetFrustum();
}

const Mix::Matrix4x4& UniversalCamera::GetViewProjectionMatrix( void ) const
{
	return Camera::GetViewProjectionMatrix();
}

const Mix::Matrix4x4& UniversalCamera::GetInvViewProjectionMatrix( void ) const
{
	return Camera::GetInvViewProjectionMatrix();
}

const Mix::Matrix4x4& UniversalCamera::GetBillboardMatrix( void ) const
{
	return Camera::GetBillboardMatrix();
}

const Mix::Matrix4x4& UniversalCamera::GetBillboardMatrixY( void ) const
{
	return Camera::GetBillboardMatrixY();
}

const Mix::Scene::ICamera::LOCAL_LIGHT_SETTINGS& UniversalCamera::GetLocalLightSettings( void ) const
{
	return Camera::GetLocalLightSettings();
}

void UniversalCamera::SetLocalLightSettings( const Mix::Scene::ICamera::LOCAL_LIGHT_SETTINGS& settings )
{
	Camera::SetLocalLightSettings( settings );
}

const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& UniversalCamera::GetParticleSettings( void ) const
{
	return Camera::GetParticleSettings();
}

void UniversalCamera::SetParticleSettings( const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& settings )
{
	Camera::SetParticleSettings( settings );
}

const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& UniversalCamera::GetActorModelSettings( void ) const
{
	return Camera::GetActorModelSettings();
}

void UniversalCamera::SetActorModelSettings( const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& settings )
{
	Camera::SetActorModelSettings( settings );
}

const Mix::Scene::ICamera::PLANTER_SETTINGS& UniversalCamera::GetPlanterSettings( void ) const
{
	return Camera::GetPlanterSettings();
}

void UniversalCamera::SetPlanterSettings( const Mix::Scene::ICamera::PLANTER_SETTINGS& settings )
{
	Camera::SetPlanterSettings( settings );
}

Boolean UniversalCamera::IsAmbientOcclusionEnabled( void ) const
{
	return Camera::IsAmbientOcclusionEnabled();
}

void UniversalCamera::SetAmbientOcclusionEnabled( Boolean state )
{
	Camera::SetAmbientOcclusionEnabled( state );
}

const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& UniversalCamera::GetAmbientOcclusionSettings( void ) const
{
	return Camera::GetAmbientOcclusionSettings();
}

void UniversalCamera::SetAmbientOcclusionSettings( const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& settings )
{
	Camera::SetAmbientOcclusionSettings( settings );
}

Boolean UniversalCamera::IsShadowMappingEnabled( void ) const
{
	return Camera::IsShadowMappingEnabled();
}

void UniversalCamera::SetShadowMappingEnabled( Boolean state )
{
	Camera::SetShadowMappingEnabled( state );
}

const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& UniversalCamera::GetShadowMappingSettings( void ) const
{
	return Camera::GetShadowMappingSettings();
}

void UniversalCamera::SetShadowMappingSettings( const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& settings )
{
	Camera::SetShadowMappingSettings( settings );
}

const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& UniversalCamera::GetLuminositySettings( void ) const
{
	return Camera::GetLuminositySettings();
}

void UniversalCamera::SetLuminositySettings( const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& settings )
{
	Camera::SetLuminositySettings( settings );
}

UInt32 UniversalCamera::ResumeLuminosityAdaptation( void )
{
	return Camera::ResumeLuminosityAdaptation();
}

UInt32 UniversalCamera::SusupendLuminosityAdaptation( void )
{
	return Camera::SusupendLuminosityAdaptation();
}

UInt32 UniversalCamera::GetLuminosityAdaptationSuspendCount( void ) const
{
	return Camera::GetLuminosityAdaptationSuspendCount();
}

void UniversalCamera::ForceLuminosityAdaptation( void )
{
	Camera::ForceLuminosityAdaptation();
}

void UniversalCamera::SetLuminosityAdaptation( Float32 lum )
{
	Camera::SetLuminosityAdaptation( lum );
}

Boolean UniversalCamera::IsBloomEnabled( void ) const
{
	return Camera::IsBloomEnabled();
}

void UniversalCamera::SetBloomEnabled( Boolean state )
{
	Camera::SetBloomEnabled( state );
}

UInt32 UniversalCamera::GetBloomOverflowNum( void ) const
{
	return Camera::GetBloomOverflowNum();
}

const Mix::Scene::ICamera::BLOOM_OVERFLOW& UniversalCamera::GetBloomOverflow( UInt32 index ) const
{
	return Camera::GetBloomOverflow( index );
}

void UniversalCamera::SetBloomOverflow( UInt32 index, const Mix::Scene::ICamera::BLOOM_OVERFLOW& overflow )
{
	Camera::SetBloomOverflow( index, overflow );
}

const Mix::Scene::ICamera::BLOOM_SETTINGS& UniversalCamera::GetBloomSettings( void ) const
{
	return Camera::GetBloomSettings();
}

void UniversalCamera::SetBloomSettings( const Mix::Scene::ICamera::BLOOM_SETTINGS& settings )
{
	Camera::SetBloomSettings( settings );
}

Boolean UniversalCamera::IsLightShaftsEnabled( void ) const
{
	return Camera::IsLightShaftsEnabled();
}

void UniversalCamera::SetLightShaftsEnabled( Boolean state )
{
	Camera::SetLightShaftsEnabled( state );
}

const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& UniversalCamera::GetLightShaftsSettings( void ) const
{
	return Camera::GetLightShaftsSettings();
}

void UniversalCamera::SetLightShaftsSettings( const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& settings )
{
	Camera::SetLightShaftsSettings( settings );
}

Boolean UniversalCamera::IsLensFlareEnabled( void ) const
{
	return Camera::IsLensFlareEnabled();
}

void UniversalCamera::SetLensFlareEnabled( Boolean state )
{
	Camera::SetLensFlareEnabled( state );
}

const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& UniversalCamera::GetLensFlareSettings( void ) const
{
	return Camera::GetLensFlareSettings();
}

void UniversalCamera::SetLensFlareSettings( const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& settings )
{
	Camera::SetLensFlareSettings( settings );
}

Boolean UniversalCamera::GetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture** ppTexture )
{
	return Camera::GetLensFlareTexture( type, ppTexture );
}

void UniversalCamera::SetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture* pTexture )
{
	Camera::SetLensFlareTexture( type, pTexture );
}

Mix::Scene::ICamera::FILMIC_TYPE UniversalCamera::GetFilmicType( void ) const
{
	return Camera::GetFilmicType();
}

Boolean UniversalCamera::GetFilmicSettings( void* pSettings, UInt32 size ) const
{
	return Camera::GetFilmicSettings( pSettings, size );
}

Boolean UniversalCamera::SetFilmicType( Mix::Scene::ICamera::FILMIC_TYPE type, const void* pSettings, UInt32 settingsSize )
{
	return Camera::SetFilmicType( type, pSettings, settingsSize );
}

Boolean UniversalCamera::IsGammaEnabled( void ) const
{
	return Camera::IsGammaEnabled();
}

void UniversalCamera::SetGammaEnabled( Boolean state )
{
	Camera::SetGammaEnabled( state );
}

const Mix::Vector3& UniversalCamera::GetGammaValue( void ) const
{
	return Camera::GetGammaValue();
}

void UniversalCamera::SetGammaValue( const Mix::Vector3& value )
{
	Camera::SetGammaValue( value );
}

void UniversalCamera::SetGammaValue( Float32 value )
{
	Camera::SetGammaValue( value );
}

Boolean UniversalCamera::IsChromatismEnabled( void ) const
{
	return Camera::IsChromatismEnabled();
}

void UniversalCamera::SetChromatismEnabled( Boolean state )
{
	Camera::SetChromatismEnabled( state );
}

const Mix::Scene::ICamera::CHROMATISM_SETTINGS& UniversalCamera::GetChromatismSettings( void ) const
{
	return Camera::GetChromatismSettings();
}

void UniversalCamera::SetChromatismSettings( const Mix::Scene::ICamera::CHROMATISM_SETTINGS& settings )
{
	Camera::SetChromatismSettings( settings );
}

Boolean UniversalCamera::IsDofEnabled( void ) const
{
	return Camera::IsDofEnabled();
}

void UniversalCamera::SetDofEnabled( Boolean state )
{
	Camera::SetDofEnabled( state );
}

const Mix::Scene::ICamera::DOF_SETTINGS& UniversalCamera::GetDofSettings( void ) const
{
	return Camera::GetDofSettings();
}

void UniversalCamera::SetDofSettings( const Mix::Scene::ICamera::DOF_SETTINGS& settings )
{
	Camera::SetDofSettings( settings );
}

Boolean UniversalCamera::IsLensDistortionEnabled( void ) const
{
	return Camera::IsLensDistortionEnabled();
}

void UniversalCamera::SetLensDistortionEnabled( Boolean state )
{
	Camera::SetLensDistortionEnabled( state );
}

const Mix::Scene::ICamera::DISTORTION_SETTINGS& UniversalCamera::GetLendDistortionSettings( void ) const
{
	return Camera::GetLendDistortionSettings();
}

void UniversalCamera::SetLendDistortionSettings( const Mix::Scene::ICamera::DISTORTION_SETTINGS& settings )
{
	Camera::SetLendDistortionSettings( settings );
}

Boolean UniversalCamera::IsVignetteEnabled( void ) const
{
	return Camera::IsVignetteEnabled();
}

void UniversalCamera::SetVignetteEnabled( Boolean state )
{
	Camera::SetVignetteEnabled( state );
}

const Mix::Scene::ICamera::VIGNETTE_SETTINGS& UniversalCamera::GetVignetteSettings( void ) const
{
	return Camera::GetVignetteSettings();
}

void UniversalCamera::SetVignetteSettings( const Mix::Scene::ICamera::VIGNETTE_SETTINGS& settings )
{
	Camera::SetVignetteSettings( settings );
}

Mix::Scene::ICamera::ANTIALIASING_TYPE UniversalCamera::GetAntiAliasingType( void ) const
{
	return Camera::GetAntiAliasingType();
}

void UniversalCamera::SetAntiAliasingType( Mix::Scene::ICamera::ANTIALIASING_TYPE type )
{
	Camera::SetAntiAliasingType( type );
}

Boolean UniversalCamera::IsUnderWater( void ) const
{
	return Camera::IsUnderWater();
}

Mix::Point UniversalCamera::Project( const Mix::Vector3& pos ) const
{
	return Camera::Project( pos );
}

Mix::Point UniversalCamera::Project( const Mix::Point& screenPos, const Mix::Vector3& pos ) const
{
	return Camera::Project( screenPos, pos );
}

Mix::Point UniversalCamera::Project( const Mix::Rectangle& screenRect, const Mix::Vector3& pos ) const
{
	return Camera::Project( screenRect, pos );
}

Mix::Vector3 UniversalCamera::Unproject( const Mix::Point& pos, Float32 z ) const
{
	return Camera::Unproject( pos, z );
}

Mix::Vector3 UniversalCamera::Unproject( const Mix::Point& screenPos, const Mix::Point& pos, Float32 z ) const
{
	return Camera::Unproject( screenPos, pos, z );
}

Mix::Vector3 UniversalCamera::Unproject( const Mix::Rectangle& screenRect, const Mix::Point& pos, Float32 z ) const
{
	return Camera::Unproject( screenRect, pos, z );
}

Boolean UniversalCamera::DragObject( const Mix::Point& pos )
{
	return Camera::DragObject( pos );
}

Boolean UniversalCamera::DragObject( const Mix::Point& screenPos, const Mix::Point& pos )
{
	return Camera::DragObject( screenPos, pos );
}

Boolean UniversalCamera::DragObject( const Mix::Rectangle& screenRect, const Mix::Point& pos )
{
	return Camera::DragObject( screenRect, pos );
}

void UniversalCamera::Update( void )
{
	Camera::Update();
}

Boolean UniversalCamera::Draw( void )
{
	return Camera::Draw();
}

void UniversalCamera::Debug_SetFillType( Mix::Graphics::FILL_TYPE type )
{
	Camera::Debug_SetFillType( type );
}

Mix::Graphics::FILL_TYPE UniversalCamera::Debug_GetFillType( void ) const
{
	return Camera::Debug_GetFillType();
}

void UniversalCamera::Debug_SetDrawMethod( Mix::Scene::DEBUG_DRAW_METHOD method )
{
	Camera::Debug_SetDrawMethod( method );
}

Mix::Scene::DEBUG_DRAW_METHOD UniversalCamera::Debug_GetDrawMethod( void ) const
{
	return Camera::Debug_GetDrawMethod();
}

void UniversalCamera::Debug_SetDrawFlags( UInt32 flags )
{
	Camera::Debug_SetDrawFlags( flags );
}

UInt32 UniversalCamera::Debug_GetDrawFlags( void ) const
{
	return Camera::Debug_GetDrawFlags();
}

const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& UniversalCamera::Debug_GetDrawFilmicSettings( void ) const
{
	return Camera::Debug_GetDrawFilmicSettings();
}

void UniversalCamera::Debug_SetDrawFilmicSettings( const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& settings )
{
	Camera::Debug_SetDrawFilmicSettings( settings );
}

UInt32 UniversalCamera::Debug_GetProfile( UInt32 type, void* pProf, UInt32 size ) const
{
	return Camera::Debug_GetProfile( type, pProf, size );
}

UInt32 UniversalCamera::Debug_GetImageNum( UInt32 type ) const
{
	return Camera::Debug_GetImageNum( type );
}

Boolean UniversalCamera::Debug_GetImage( UInt32 type, UInt32 index, Mix::Graphics::ITexture** ppTexture )
{
	return Camera::Debug_GetImage( type, index, ppTexture );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::IRendererResource
////////////////////////////////////////////////////////////////////////////////////////////////////

Boolean UniversalCamera::IsDisposed( void ) const
{
	return Camera::IsDisposed();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::IRendererObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Scene::IRendererObject::TYPE UniversalCamera::GetType( void ) const
{
	return Mix::Scene::IRendererObject::UNIVERSAL_CAMERA;
}

}}}
