#pragma once

#include <vector>
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{ namespace Common{

	class TerrainMesh;

	class TerrainNode
	{
	private:
		typedef std::vector<TerrainNode*> ChildList;

	private:
		Mix::Geometry::AABB m_DefaultBounds;
		Mix::Geometry::AABB m_Bounds;

		Mix::Scene::Common::TerrainMesh* m_pMesh;

		Int32 m_ParentIndex;
		TerrainNode::ChildList m_ChildList;

	public:
		TerrainNode( void );
		~TerrainNode( void );

		void SetBounds( const Float32* aabb );
		void SetBounds( const Mix::Geometry::AABB& aabb );
		void UpdateBounds( const Mix::Vector3& worldPos );
		const Mix::Geometry::AABB& GetBounds( void ) const;
		const Mix::Geometry::AABB& GetDefaultBounds( void ) const;

		void SetMesh( Mix::Scene::Common::TerrainMesh* pMesh );
		Mix::Scene::Common::TerrainMesh* GetMeshPtr( void ) const;

		void SetParent( Int32 parentIndex, TerrainNode* pParent );
		Int32 GetParentIndex( void ) const;

		void ReserveChildList( UInt32 count );
		UInt32 GetChildCount( void ) const;
		TerrainNode* GetChildPtr( UInt32 index ) const;
	};

}}}
