#pragma once

#include <vector>
#include "Mix/Class/Scene/Common/Mesh.h"

namespace Mix{ namespace Scene{ namespace Common{

	class TerrainMesh : public Mix::Scene::Common::Mesh
	{
	private:
		static const wchar_t* CREATE_FAILED;

	public:
		struct OPACITY_SUBSET
		{
			UInt32 vertexStart;
			UInt32 vertexCount;
			UInt32 indexStart;
			UInt32 indexCount;
		};

		struct TRANSPARENCY_SUBSET
		{
			UInt32 vertexStart;
			UInt32 vertexCount;
			UInt32 indexStart;
			UInt32 indexCount;
			Mix::Vector3 sortKey;
			UInt32 reserve;
		};

		typedef std::vector<TerrainMesh::OPACITY_SUBSET> OpacitySubsetList;
		typedef std::vector<TerrainMesh::TRANSPARENCY_SUBSET> TransparencySubsetList;

		struct DRAW
		{
			UInt32 materialSlotIndex;
			TerrainMesh::OpacitySubsetList opSubsets;
			TerrainMesh::TransparencySubsetList trSubsets[Mix::Scene::MATERIAL_TRANSPARENCY_MAX];
		};

		typedef std::vector<TerrainMesh::DRAW> DrawTable;

	private:
		struct MM_DESC
		{
			UInt32 drawNum;
			UInt32 vertexStride;
			UInt32 vertexNum;
			UInt32 indexStride;
			UInt32 indexNum;
			UInt32 reserve;
		};

		struct MM_DRAW_DESC
		{
			UInt32 slotIndex;
			UInt32 opSubsetNum;
			UInt32 trSubsetNum[Mix::Scene::MATERIAL_TRANSPARENCY_MAX];
		};

	private:
		TerrainMesh::DrawTable m_DrawTable;

	public:
		static TerrainMesh* CreateInstance( Mix::Graphics::IDevice* pDevice, Mix::File::IReader* pReader, const wchar_t* pName );

	private:
		TerrainMesh( void );
		virtual ~TerrainMesh( void );

	public:
		const TerrainMesh::DrawTable& GetDrawTable( void ) const;
	};

}}}
