#include "Mix/Class/Scene/Common/TerrainLoader.h"

#include "Mix/File/IReader.h"
#include "Mix/Memory/IBuffer.h"
#include "Mix/Graphics/IManager.h"
#include "Mix/Graphics/IDevice.h"
#include "Mix/Graphics/IVertexBuffer.h"
#include "Mix/Graphics/IIndexBuffer.h"
#include "Mix/Dynamics/IManager.h"
#include "Mix/Dynamics/IStaticMesh.h"
#include "Mix/Scene/IMaterial.h"

#include "Mix/Class/Scene/Common/Manager.h"
#include "Mix/Class/Scene/Common/Factory.h"
#include "Mix/Class/Scene/Common/TerrainMesh.h"
#include "Mix/Class/Scene/Common/TerrainNode.h"
#include "Mix/Class/Scene/Common/TerrainModel.h"

namespace Mix{ namespace Scene{ namespace Common{

const wchar_t* TerrainLoader::FAILED_CREATE = L"n`f̍쐬Ɏs";

TerrainLoader::TerrainLoader( Mix::Scene::Common::Factory* pFactory ) :
m_pFactory( pFactory ),
m_pDynamicsManager( NULL ),
m_pGraphicsDevice( NULL )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////

	MIX_ASSERT( pFactory != NULL );

	m_pFactory = pFactory;	//zQƂɂȂ̂ŃJE^͉񂳂Ȃ

	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Dynamics::IManager* pDynamicsMgr = Mix::Dynamics::GetManagerPtr();

	//_Ci~NXɂĂĂgpł悤ɂ邽߂̃AT[g͂Ȃ
	MIX_ADD_REF( pDynamicsMgr );
	m_pDynamicsManager = pDynamicsMgr;

	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();

	MIX_ASSERT( pGraphicsMgr != NULL );

	if( pGraphicsMgr->GetDevice( &m_pGraphicsDevice ) == False )
	{
		MIX_ASSERT( m_pGraphicsDevice != NULL );
	}
}

TerrainLoader::~TerrainLoader( void )
{
	MIX_RELEASE( m_pGraphicsDevice );
	MIX_RELEASE( m_pDynamicsManager );
}

Mix::Scene::ITerrainModel* TerrainLoader::Create( Mix::File::IReader* pReader, const wchar_t* pName )
{
	MIX_ASSERT( pReader != NULL );
	MIX_ASSERT( MIX_STR_LENGTH( pName ) > 0 );

	Mix::Scene::Common::TerrainModel* pModel = NULL;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// C^[tF[X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	pModel = TerrainModel::CreateInstance( pName );
	if( pModel == NULL )
	{
		MIX_LOG_INFO( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_OUTOFMEMORY, pName );
		return NULL;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ǂݍ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( Create( pReader, pName, pModel ) == False )
	{
		MIX_RELEASE( pModel );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ㏈
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_MeshList.size() > 0 )
	{
		for( TerrainLoader::MeshList::iterator it = m_MeshList.begin(); it != m_MeshList.end(); ++it )
		{
			MIX_RELEASE( ( *it ) );
		}

		m_MeshList.clear();
	}

	m_NodeList.clear();

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return pModel;
}

Boolean TerrainLoader::Create( Mix::File::IReader* pReader, const wchar_t* pName, Mix::Scene::Common::TerrainModel* pModel )
{
	MIX_ASSERT( pModel != NULL );

	UInt32 i;
	UInt32 nodeByeSize;
	Mix::String strTemp;

	TerrainLoader::MTM_FILE_HEADER_1_0_0_0 fileHeader;
	TerrainLoader::MTM_DATA_HEADER_1_0_0_0 dataHeader;

	bool bExistsCollision = False;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// t@Cwb_
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( pReader->Read( &fileHeader, sizeof( fileHeader ) ) != sizeof( fileHeader ) )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	if( fileHeader.magicNumber != TerrainLoader::MTM_MAGICNUMBER )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	MIX_LOG_INFO( L"t@Cwb_ : MagicNumber[0x%08x] Version[0x%08x]", fileHeader.magicNumber, fileHeader.version );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// f[^wb_
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( pReader->Read( &dataHeader, sizeof( dataHeader ) ) != sizeof( dataHeader ) )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	if( ( dataHeader.materialNum == 0 ) ||
		( dataHeader.meshNum == 0 ) ||
		( dataHeader.nodeNum == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	if( ( dataHeader.collShapeSize == 0 ) &&
		( dataHeader.collPolygonNum == 0 ) &&
		( dataHeader.collMaterialNum == 0 ) )
	{
		//RWĂȂ
		bExistsCollision = False;
	}
	else if(	( dataHeader.collShapeSize > 0 ) &&
				( dataHeader.collPolygonNum > 0 ) &&
				( dataHeader.collMaterialNum > 0 ) )
	{
		//RWĂ
		bExistsCollision = True;
	}
	else if(	( dataHeader.collShapeSize == 0 ) ||
				( dataHeader.collPolygonNum == 0 ) ||
				( dataHeader.collMaterialNum == 0 ) )
	{
		//sȃtH[}bg
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// }eA
	////////////////////////////////////////////////////////////////////////////////////////////////////

	pModel->ReserveMaterialSlots( dataHeader.materialNum );

	for( i = 0; i < dataHeader.materialNum; i++ )
	{
		wchar_t slotName[32];
		Mix::Scene::IMaterial* pMaterial = NULL;

		if( pReader->Read( slotName, sizeof( slotName ) ) != sizeof( slotName ) )
		{
			MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
			return False;
		}

		strTemp.Sprintf( L"%s\\%s", pName, slotName );

		pMaterial = m_pFactory->CreateMaterialWithoutMagicNumber( strTemp.GetConstPtr(), pReader );
		if( pMaterial == NULL )
		{
			return False;
		}

		pModel->AddMaterialSlot( slotName, pMaterial );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// bV
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_MeshList.reserve( dataHeader.meshNum );

	for( i = 0; i < dataHeader.meshNum; i++ )
	{
		Mix::Scene::Common::TerrainMesh* pMesh = NULL;

		strTemp.Sprintf( L"%s\\Mesh%d", pName, i );

		pMesh = Mix::Scene::Common::TerrainMesh::CreateInstance( m_pGraphicsDevice, pReader, strTemp.GetConstPtr() );
		if( pMesh == NULL )
		{
			MIX_LOG_ERROR( L"%s : bV쐬ł܂ł : FilePath[%s]", FAILED_CREATE, pName );
			return False;
		}

		m_MeshList.push_back( pMesh );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// m[h
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Scene::Common::TerrainNode** nodeList;

	m_NodeList.clear();
	m_NodeList.resize( dataHeader.nodeNum );

	nodeByeSize = sizeof( TerrainLoader::MTM_NODE_1_0_0_0 ) * dataHeader.nodeNum;

	if( pReader->Read( &( m_NodeList[0] ), nodeByeSize ) != nodeByeSize )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
		return False;
	}

	nodeList = pModel->AllocateNodeList( dataHeader.nodeNum );
	if( nodeList == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_OUTOFMEMORY, pName );
		return False;
	}

	for( i = 0; i < dataHeader.nodeNum; i++ )
	{
		const TerrainLoader::MTM_NODE_1_0_0_0& srcNode = m_NodeList[i];
		Mix::Scene::Common::TerrainNode* pDstNode = nodeList[i];

		pDstNode->SetBounds( srcNode.aabb );
		pDstNode->SetMesh( ( srcNode.mesh >= 0 )? m_MeshList[srcNode.mesh] : NULL );
		pDstNode->SetParent( srcNode.parent, ( srcNode.parent >= 0 )? nodeList[srcNode.parent] : NULL );
		pDstNode->ReserveChildList( srcNode.childCount );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// RW
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( ( m_pDynamicsManager != NULL ) && ( bExistsCollision == True ) )
	{
		/*
			_Ci~NX : X^eBbNbV : 쐬
		*/

		Mix::Memory::IBuffer* pBuffer = NULL;
		Mix::Dynamics::IStaticMesh* pStaticMesh = NULL;
		UInt32* polygonMaterialIndices = NULL;
		Mix::Dynamics::MATERIAL* materials = 0;
			
		if( Mix::Memory::CreateBuffer( dataHeader.collShapeSize, NULL, &pBuffer ) == False )
		{
			MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_OUTOFMEMORY, pName );
			return False;
		}

		if( pReader->Read( pBuffer->GetPointer(), pBuffer->GetSize() ) != pBuffer->GetSize() )
		{
			MIX_RELEASE( pBuffer );
			return False;
		}

		if( m_pDynamicsManager->CreateStaticMesh( pBuffer, dataHeader.collMaterialNum, &pStaticMesh, pName ) == False )
		{
			MIX_RELEASE( pBuffer );
			return False;
		}

		MIX_RELEASE( pBuffer );

		/*
			_Ci~NX : X^eBbNbV : |S̃}eAQƃXg
		*/

		if( pStaticMesh->LockMaterialIndices( 0, 0, dataHeader.collPolygonNum, &polygonMaterialIndices ) == dataHeader.collPolygonNum )
		{
			UInt32 readSize = sizeof( UInt32 ) * dataHeader.collPolygonNum;

			if( pReader->Read( polygonMaterialIndices, readSize ) != readSize )
			{
				MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
				MIX_RELEASE( pStaticMesh );
				return False;
			}
		}
		else
		{
			MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
			MIX_RELEASE( pStaticMesh );
			return False;
		}

		/*
			_Ci~NX : X^eBbNbV : }eAXg
		*/

		if( pStaticMesh->LockMaterials( 0, dataHeader.collMaterialNum, &materials ) == dataHeader.collMaterialNum )
		{
			UInt32 readSize = sizeof( Mix::Dynamics::MATERIAL ) * dataHeader.collMaterialNum;

			if( pReader->Read( materials, readSize ) != readSize )
			{
				MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_ILLEGALFORMAT, pName );
				MIX_RELEASE( pStaticMesh );
				return False;
			}
		}
		else
		{
			MIX_RELEASE( pStaticMesh );
			return False;
		}

		/*
			V[ : RC_[̍쐬
		*/

		if( pModel->CreateCollider( pStaticMesh ) == False )
		{
			MIX_LOG_ERROR( L"%s : %s : FilePath[%s]", FAILED_CREATE, Mix::STR_OUTOFMEMORY, pName );
			MIX_RELEASE( pStaticMesh );
			return False;
		}

		/*
			㏈
		*/

		MIX_RELEASE( pStaticMesh );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return True;
}

}}}
