#pragma once

#include "Mix/Scene/IShadowProjector.h"
#include "Mix/Geometry/Sphere.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Camera;

	class ShadowProjector : public Mix::Scene::IShadowProjector
	{
	public:
		static ShadowProjector* CreateInstance( void );

	private:
		Mix::Vector3 m_Dir;
		Mix::Scene::IShadowProjector::DETAIL m_Detail;

		Mix::Geometry::Sphere m_ClipBounds;
		Mix::Geometry::AABB m_CastBounds;
		Boolean m_bCast;

		Boolean m_bDisposed;

	private:
		ShadowProjector( void );
		virtual ~ShadowProjector( void );

		void CalcPSM( Mix::Scene::Common::Camera* pCamera, Mix::Matrix4x4& lightMat );
		void CalcLiSPSM( Mix::Scene::Common::Camera* pCamera, Float32 EdotL, Mix::Matrix4x4& lightMat );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::ShadowProjector
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void Reset( Mix::Scene::Common::Camera* pCamera ); //center=eye radius=dist

		void AppendCast( const Mix::Geometry::Sphere& bounds );
		void AppendCast( const Mix::Geometry::AABB& bounds );

		Mix::Matrix4x4 CalculateLightMatrix( Mix::Scene::Common::Camera* pCamera ); //viewDir=J̕

		const Mix::Geometry::Sphere& GetClipBounds( void ) const;

		Boolean IsCast( void ) const;
		const Mix::Geometry::AABB& GetCastBounds( void ) const;

		void Dispose( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IShadowProjector
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetDirection( void ) const;
		virtual void SetDirection( const Mix::Vector3& dir );

		virtual const Mix::Scene::IShadowProjector::DETAIL& GetDetail( void ) const;
		virtual void SetDetail( const Mix::Scene::IShadowProjector::DETAIL& detail );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
	};

}}}
