#include "Mix/Class/Scene/Common/ShadowProjector.h"
#include "Mix/Class/Scene/Common/Camera.h"

namespace Mix{ namespace Scene{ namespace Common{

ShadowProjector* ShadowProjector::CreateInstance( void )
{
	return new ShadowProjector();
}

ShadowProjector::ShadowProjector( void ) :
m_Dir( 0.0f, -1.0f, 0.0f ),
m_bCast( False ),
m_bDisposed( False )
{
	m_Detail.nearClip = 0.001f;
	m_Detail.castPadding = 0.001f;
	m_Detail.errValue = 0.001f;
}

ShadowProjector::~ShadowProjector( void )
{
}

void ShadowProjector::CalcPSM( Mix::Scene::Common::Camera* pCamera, Mix::Matrix4x4& lightMat )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ϐ錾
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Vector3 dummyVec;
	Mix::Vector3 upVec;
	Mix::Vector3 target;
	Mix::Matrix4x4 viewMat;
	Mix::Matrix4x4 projMat;
	Mix::Geometry::AABB bounding;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// VhEpr[sZo
	////////////////////////////////////////////////////////////////////////////////////////////////////

	//xNgZo
	Mix::PlaneSpace( m_Dir, upVec, dummyVec );

	//^[Qbg
	target = ( m_CastBounds.min + m_CastBounds.max ) * 0.5f;

	//sZo
	Mix::Matrix4x4::LookAtLH( target - m_Dir * pCamera->GetShadowMappingSettings().maxDist, target, upVec, viewMat );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// VhEpˉesZo
	////////////////////////////////////////////////////////////////////////////////////////////////////

	//JAABB쐬( r[ )
	bounding = m_CastBounds;
	bounding.ComputeMinMax( viewMat );

	//sZo
	Mix::Matrix4x4::OrthoOffCenterLH( bounding.min, bounding.max, projMat );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Cgs߂
	////////////////////////////////////////////////////////////////////////////////////////////////////

	lightMat = viewMat * projMat;
}

void ShadowProjector::CalcLiSPSM( Mix::Scene::Common::Camera* pCamera, Float32 EdotL, Mix::Matrix4x4& lightMat )
{
	const Mix::Vector3& eyePos = pCamera->GetEye();
	const Mix::Vector3& viewDir = pCamera->GetViewForward();

	Mix::Vector3 dummyVec;
	Mix::Vector3 upVec;
	Mix::Vector3 lightPos;
	Mix::Matrix4x4 viewMat;
	Mix::Matrix4x4 projMat;
	Mix::Matrix4x4 lispMat;
	Mix::Matrix4x4 lispViewMat;
	Mix::Geometry::AABB bounding;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// J AABB ̒_WZo
	////////////////////////////////////////////////////////////////////////////////////////////////////

	bounding = m_CastBounds;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// r[s쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

#if 0
	Mix::Vector3 newDir;

	for( UInt32 i = 0; i < 8; i++ )
	{
		newDir += ( bounding.points[i] - eyePos );
	}

	newDir.Normalize();

	upVec = ComputeUpVector( newDir, lightDir );
#else
	Mix::PlaneSpace( m_Dir, upVec, dummyVec );
#endif

	Mix::Matrix4x4::LookAtLH( eyePos, ( eyePos + m_Dir ), upVec, viewMat );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// J AABB ̍ŏlAőlZo
	////////////////////////////////////////////////////////////////////////////////////////////////////

	bounding.ComputeMinMax( viewMat );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Zo
	////////////////////////////////////////////////////////////////////////////////////////////////////

	const Float32 nearZ = m_Detail.nearClip;
	const Float32 sinGamma = sqrtf( 1.0f - EdotL * EdotL );

	const Float32 factor = MIX_FLOAT_DIV( 1.0f, sinGamma );
	const Float32 z_n = factor * nearZ;
	const Float32 d = abs( bounding.max.y - bounding.min.y );

#if 1
	const Float32 z0 = -z_n;
	const Float32 z1 = -( z_n + d * sinGamma );
	const Float32 n = MIX_FLOAT_DIV( d, ( sqrtf( MIX_FLOAT_DIV( z1, z0 ) ) - 1.0f ) );
#else
	const Float32 z_f = z_n + d * sinGamma;
	const Float32 n = ( z_n + sqrtf( z_f * z_n ) ) * factor;
#endif

	const Float32 f = n + d;

	//Cg̈ʒu( ̎_ )Zo
//	lightPos = eyePos + upVec * ( n - nearZ );
	lightPos = ( ( m_CastBounds.min + m_CastBounds.max ) * 0.5f ) + upVec * ( n - nearZ );

	//Cgr[sZo
	Mix::Matrix4x4::LookAtLH( lightPos, ( lightPos + m_Dir ), upVec, viewMat );

	//CgԂ̎ˉesZo
	lispMat.m11 = MIX_FLOAT_DIV( f, ( f - n ) );
	lispMat.m31 = -f * MIX_FLOAT_DIV( n, ( f - n ) );

	//CgԂ̓ϊsZo
	lispViewMat = lispMat;
	lispViewMat *= viewMat;

	//CgԂł̍ŏlAőlZo
	bounding.ComputeMinMax( lispViewMat );

	//CgˉesZo
	Mix::Matrix4x4::OrthoOffCenterLH( bounding.min, bounding.max, projMat );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Cgs߂
	////////////////////////////////////////////////////////////////////////////////////////////////////

	lightMat = viewMat * projMat;
}

void ShadowProjector::Reset( Mix::Scene::Common::Camera* pCamera )
{
	MIX_ASSERT( pCamera != NULL );

	// Nbv߂
	m_ClipBounds.center = pCamera->GetEye();
	m_ClipBounds.radius = pCamera->GetShadowMappingSettings().maxDist;

	// LXgNA
	m_CastBounds.min = Mix::Vector3( +MIX_FLOAT_MAX, +MIX_FLOAT_MAX, +MIX_FLOAT_MAX );
	m_CastBounds.max = Mix::Vector3( -MIX_FLOAT_MAX, -MIX_FLOAT_MAX, -MIX_FLOAT_MAX );

	m_bCast = False;
}

void ShadowProjector::AppendCast( const Mix::Geometry::Sphere& bounds )
{
	m_CastBounds += bounds;
	m_bCast = True;
}

void ShadowProjector::AppendCast( const Mix::Geometry::AABB& bounds )
{
	m_CastBounds += bounds;
	m_bCast = True;
}

Mix::Matrix4x4 ShadowProjector::CalculateLightMatrix( Mix::Scene::Common::Camera* pCamera )
{
	MIX_ASSERT( pCamera != NULL );

	if( m_bCast == False )
	{
		return Mix::Matrix4x4::Identity();
	}

	Mix::Matrix4x4 lightMat;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// r[oEfBÔW̓_߂
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Float32 pad = m_Detail.castPadding;
	Mix::Vector3 padVec( pad, pad, pad );

	m_CastBounds.min -= padVec;
	m_CastBounds.max += padVec;

	m_CastBounds.ComputePoints();

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Cgs߂
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Float32 EdotL = Mix::Vector3::Dot( pCamera->GetViewForward(), m_Dir );
	Float32 errCos = 1.0f - m_Detail.errValue;

	if( ( EdotL >= +errCos ) || ( EdotL <= -errCos ) )
	{
		//eƎdȂꍇ PSM gp
		CalcPSM( pCamera, lightMat );
	}
	else
	{
		CalcLiSPSM( pCamera, EdotL, lightMat );
	}

	return lightMat;
}

const Mix::Geometry::Sphere& ShadowProjector::GetClipBounds( void ) const
{
	return m_ClipBounds;
}

Boolean ShadowProjector::IsCast( void ) const
{
	return m_bCast;
}

const Mix::Geometry::AABB& ShadowProjector::GetCastBounds( void ) const
{
	return m_CastBounds;
}

void ShadowProjector::Dispose( void )
{
	m_bDisposed = True;
}

const Mix::Vector3& ShadowProjector::GetDirection( void ) const
{
	return m_Dir;
}

void ShadowProjector::SetDirection( const Mix::Vector3& dir )
{
	m_Dir = dir;
}

const Mix::Scene::IShadowProjector::DETAIL& ShadowProjector::GetDetail( void ) const
{
	return m_Detail;
}

void ShadowProjector::SetDetail( const Mix::Scene::IShadowProjector::DETAIL& detail )
{
	m_Detail.nearClip = max( 0.0001f, detail.nearClip );
	m_Detail.castPadding = max( 0.0f, detail.castPadding );
	m_Detail.errValue = MIX_CLAMP( detail.errValue, 0.0f, 1.0f );
}

Boolean ShadowProjector::IsDisposed( void ) const
{
	return m_bDisposed;
}

Mix::Scene::IRendererObject::TYPE ShadowProjector::GetType( void ) const
{
	return Mix::Scene::IRendererObject::SHADOW_PROJECTOR;
}

}}}
