#include "Mix/Class/Scene/Common/Sensor.h"

#include "Mix/Class/Dynamics/Sensor.h"
#include "Mix/Dynamics/IShape.h"
#include "Mix/Scene/IRendererObject.h"

namespace Mix{ namespace Scene{ namespace Common{
	
////////////////////////////////////////////////////////////////////////////////////////////////////
// tB^[
////////////////////////////////////////////////////////////////////////////////////////////////////

const UInt16 Sensor::FILTER_GROUP	= Mix::Dynamics::OF_SENSOR;
const UInt16 Sensor::FILTER_MASK	= Mix::Dynamics::OF_DEFAULT | Mix::Dynamics::OF_STATIC | Mix::Dynamics::OF_KINEMATIC;
	
////////////////////////////////////////////////////////////////////////////////////////////////////
// Sensor
////////////////////////////////////////////////////////////////////////////////////////////////////

Sensor* Sensor::CreateInstance( const wchar_t* pName, const Mix::Matrix4x4& centerMat, Mix::Dynamics::ISensor* pObject )
{
	return new Sensor( pName, centerMat, pObject );
}

Sensor* Sensor::CreateInstance( Mix::Scene::IRendererObject* pOwner, const wchar_t* pName, const Mix::Matrix4x4& centerMat, Mix::Dynamics::ISensor* pObject )
{
	return new Sensor( pOwner, pName, centerMat, pObject );
}

Sensor::Sensor( const wchar_t* pName, const Mix::Matrix4x4& centerMat, Mix::Dynamics::ISensor* pObject ) :
m_pOwner( NULL ),
m_Name( L"" ),
m_CenterMat( centerMat ),
m_pObject( NULL )
{
	MIX_ASSERT( pName != NULL );
	MIX_ASSERT( pObject != NULL );

	m_Name = pName;

	MIX_ADD_REF( pObject );
	m_pObject = pObject;

	m_pObject->SetFilterGroup( Sensor::FILTER_GROUP );
	m_pObject->SetFilterMask( Sensor::FILTER_MASK );

	DynamicsObject::Initialize( this );
}

Sensor::Sensor( Mix::Scene::IRendererObject* pOwner, const wchar_t* pName, const Mix::Matrix4x4& centerMat, Mix::Dynamics::ISensor* pObject ) :
m_pOwner( NULL ),
m_Name( L"" ),
m_CenterMat( centerMat ),
m_pObject( NULL )
{
	MIX_ASSERT( pOwner != NULL );
	MIX_ASSERT( pName != NULL );
	MIX_ASSERT( pObject != NULL );

	m_pOwner = pOwner;

	m_Name = pName;

	MIX_ADD_REF( pObject );
	m_pObject = pObject;

	m_pObject->SetFilterGroup( Sensor::FILTER_GROUP );
	m_pObject->SetFilterMask( Sensor::FILTER_MASK );

	DynamicsObject::Initialize( this );
}

Sensor::~Sensor( void )
{
	MIX_ASSERT( m_pOwner == NULL );
	MIX_RELEASE( m_pObject );
}

void Sensor::SetOwner( Mix::Scene::IRendererObject* pOwner )
{
	MIX_ASSERT( pOwner != NULL );
	MIX_ASSERT( m_pOwner == NULL );

	m_pOwner = pOwner;
}

void Sensor::Reset( const Mix::Matrix4x4& baseMat )
{
	MIX_ASSERT( m_pObject != NULL );

	Mix::Matrix4x4 worldMat = m_CenterMat * baseMat;

	m_pObject->SetWorldTransform( worldMat.GetRotation(), worldMat.GetTranslation() );
}

Mix::Dynamics::ISensor* Sensor::GetInternalSensorPtr( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject;
}

Sensor* Sensor::Clone( void )
{
	Mix::Scene::Common::Sensor* pDstSensor = NULL;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// IuWFNg𕡐
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Dynamics::IShape* pSrcShape = NULL;
	Mix::Dynamics::Sensor* pDstObject = NULL;

	m_pObject->GetShape( &pSrcShape );
	MIX_ASSERT( pSrcShape != NULL );

	pDstObject = Mix::Dynamics::Sensor::CreateInstance( pSrcShape );
	if( pDstObject != NULL )
	{
		if( pDstObject->Initialize( m_Name.GetConstPtr() ) == True )
		{
			pDstObject->SetMaterial( m_pObject->GetMaterial() );

			//[hgXtH[͂ƂŐݒ
		}
		else
		{
			MIX_RELEASE( pSrcShape );
			return NULL;
		}
	}
	else
	{
		MIX_RELEASE( pSrcShape );
		return NULL;
	}

	MIX_RELEASE( pSrcShape );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// g𕡐
	////////////////////////////////////////////////////////////////////////////////////////////////////

	pDstSensor = Mix::Scene::Common::Sensor::CreateInstance( m_Name.GetConstPtr(), m_CenterMat, pDstObject );
	if( pDstSensor == NULL )
	{
		MIX_RELEASE( pDstObject );
		return NULL;
	}

	MIX_RELEASE( pDstObject );

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return pDstSensor;
}

void Sensor::Dispose( void )
{
	m_pOwner = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::Common::DynamicsObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Dynamics::IObject* Sensor::GetInternalObjectPtr( void ) const
{
	return m_pObject;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::ISensor
////////////////////////////////////////////////////////////////////////////////////////////////////

const wchar_t* Sensor::GetName( void ) const
{
	return m_Name.GetConstPtr();
}

UInt16 Sensor::GetFilterGroup( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetFilterGroup();
}

void Sensor::SetFilterGroup( UInt16 filterGroup )
{
	MIX_ASSERT( m_pObject != NULL );

	m_pObject->SetFilterGroup( filterGroup );
}


UInt16 Sensor::GetFilterMask( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetFilterMask();
}

void Sensor::SetFilterMask( UInt16 filterMask )
{
	MIX_ASSERT( m_pObject != NULL );

	m_pObject->SetFilterMask( filterMask );
}

const Mix::Dynamics::MATERIAL& Sensor::GetMaterial( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetMaterial();
}

void Sensor::SetMaterial( const Mix::Dynamics::MATERIAL& material )
{
	MIX_ASSERT( m_pObject != NULL );

	m_pObject->SetMaterial( material );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene::IDynamicsObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Scene::IDynamicsObject::TYPE Sensor::GetType( void ) const
{
	return Mix::Scene::IDynamicsObject::SENSOR;
}

Boolean Sensor::GetOwner( Mix::Scene::IRendererObject** ppOwner )
{
	if( m_pOwner != NULL )
	{
		MIX_ADD_REF( m_pOwner );
		( *ppOwner ) = m_pOwner;
	}
	else
	{
		return False;
	}

	return True;
}

Mix::Scene::IRendererObject* Sensor::GetOwnerPtr( void ) const
{
	return m_pOwner;
}

Mix::Matrix4x4 Sensor::GetWorldMatrix( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetWorldMatrix();
}

Mix::Quaternion Sensor::GetWorldRotation( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetWorldRotation();
}

Mix::Vector3 Sensor::GetWorldPosition( void ) const
{
	MIX_ASSERT( m_pObject != NULL );

	return m_pObject->GetWorldPosition();
}

Boolean Sensor::HasContactListener( void ) const
{
	return DynamicsObject::HasContactListener();
}

Boolean Sensor::ContainsContactListener( Mix::Scene::IContactListener* pListener ) const
{
	return DynamicsObject::ContainsContactListener( pListener );
}

Boolean Sensor::AddContactListener( Mix::Scene::IContactListener* pListener )
{
	return DynamicsObject::AddContactListener( pListener );
}

Boolean Sensor::RemoveContactListener( Mix::Scene::IContactListener* pListener )
{
	return DynamicsObject::RemoveContactListener( pListener );
}

void Sensor::ClearContactListener( void )
{
	DynamicsObject::ClearContactListener();
}

Int32 Sensor::GetUserIndex( void )  const
{
	return DynamicsObject::GetUserIndex();
}

void Sensor::SetUserIndex( Int32 index )
{
	DynamicsObject::SetUserIndex( index );
}

void* Sensor::GetUserPtr( void ) const
{
	return DynamicsObject::GetUserPtr();
}

void Sensor::SetUserPtr( void* ptr )
{
	DynamicsObject::SetUserPtr( ptr );
}

}}}
