#pragma once

#ifdef _MIX_DEVELOP
	//fobOł\[X̋LłĂ邩ǂmF邽߂ɂ
	#define _MIX_SCENE_RES_MGR_DEBUG
#else //_MIX_DEVELOP
	#ifdef _DEBUG
		#define _MIX_SCENE_RES_MGR_DEBUG
	#endif //_DEBUG
#endif //_MIX_DEVELOP

namespace Mix{ namespace Scene{ namespace Common{

	// I[i[( owner ) : tO
	// ^O( tag ) : CfbNX
	class ResourceManager
	{
	public:
		enum TAG
		{
			TAG_DEPTH_BUFF				= 0,
			TAG_COLOR_TEX_CHAIN			= 1,
			TAG_DEPTH_TEX_CHAIN			= 2,
			TAG_DATA_TEX				= 3,
			TAG_REFFRACT_TEX			= 4,

			TAG_TEMP_TEX_0				= 5,
			TAG_TEMP_TEX_1				= 6,
			TAG_TEMP_TEX_2				= 7,
			TAG_TEMP_TEX_CHAIN_0		= 8,

			TAG_SDW_DEPTH_BUFF			= 9,
			TAG_SDW_DEPTH_TEX			= 10,
			TAG_SDW_MAP_TEX				= 11,

			TAG_LUM_INITIAL_TEX			= 12,
			TAG_LUM_ITEXRATE_TEX		= 13,
			TAG_LUM_FINAL_TEX			= 14,
			TAG_LUM_ADAPTED_TEX_CHAIN	= 15,

#ifdef _DEBUG
			TAG_DEBUG_TEX				= 256,
#endif //_DEBUG
		};
	private:
		struct BASE_OBJECT
		{
			UInt32 owner;
			UInt32 tag;
#ifdef _MIX_SCENE_RES_MGR_DEBUG
			Mix::StringW debName;
			UInt32 debIndex;
#endif //_MIX_SCENE_RES_MGR_DEBUG

			BASE_OBJECT( UInt32 _tag );
			BASE_OBJECT( UInt32 _owner, UInt32 _tag );
#ifdef _MIX_SCENE_RES_MGR_DEBUG
			BASE_OBJECT( UInt32 _owner, UInt32 _tag, const wchar_t* pDebName );
#endif //_MIX_SCENE_RES_MGR_DEBUG
		};

		struct TEXTURE_OBJECT : public BASE_OBJECT
		{
			Mix::Point size;
			Mix::Graphics::FORMAT format;

			TEXTURE_OBJECT( UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format );
			TEXTURE_OBJECT( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format );
#ifdef _MIX_SCENE_RES_MGR_DEBUG
			TEXTURE_OBJECT( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format, const wchar_t* pDebName );
#endif //_MIX_SCENE_RES_MGR_DEBUG

			bool operator == ( const TEXTURE_OBJECT& b ) const;
		};

		struct TARGET_TEXTURE : public TEXTURE_OBJECT
		{
			Mix::Graphics::ITexture* pInterface;

			TARGET_TEXTURE( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format, Mix::Graphics::ITexture* _pInterface );
#ifdef _MIX_SCENE_RES_MGR_DEBUG
			TARGET_TEXTURE( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format, Mix::Graphics::ITexture* _pInterface, const wchar_t* pDebName );
#endif //_MIX_SCENE_RES_MGR_DEBUG
		};

		struct TARGET_TEXTURE_CHAIN : public TEXTURE_OBJECT
		{
			Mix::Graphics::Utility::ITargetTextureChain* pInterface;

			TARGET_TEXTURE_CHAIN( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format, Mix::Graphics::Utility::ITargetTextureChain* _pInterface );
#ifdef _MIX_SCENE_RES_MGR_DEBUG
			TARGET_TEXTURE_CHAIN( UInt32 _owner, UInt32 _tag, const Mix::Point& _size, Mix::Graphics::FORMAT _format, Mix::Graphics::Utility::ITargetTextureChain* _pInterface, const wchar_t* pDebName );
#endif //_MIX_SCENE_RES_MGR_DEBUG
		};

		typedef std::vector<ResourceManager::TARGET_TEXTURE> TargetTextureList;
		typedef std::vector<ResourceManager::TARGET_TEXTURE_CHAIN> TargetTextureChainList;

	private:
		Mix::StringW m_Name;

		Mix::Graphics::IManager* m_pGraphicsMgr;
		Mix::Graphics::IDevice* m_pGraphicsDev;

		ResourceManager::TargetTextureList m_TargetTexList;
		ResourceManager::TargetTextureChainList m_TargetTexChainList;

	public:
		ResourceManager( const wchar_t* pName, Mix::Graphics::IManager* pGraphicsMgr );
		~ResourceManager( void );

		Mix::Graphics::ITexture* CreateDepthTexture( UInt32 owner, UInt32 tag, const Mix::Point& size, Mix::Graphics::FORMAT format, const wchar_t* pDebugName = NULL );
		Mix::Graphics::ITexture* CreateTargetTexture( UInt32 owner, UInt32 tag, const Mix::Point& size, Mix::Graphics::FORMAT format, const wchar_t* pDebugName = NULL );
		Mix::Graphics::Utility::ITargetTextureChain* CreateTargetTextureChain( UInt32 owner, UInt32 tag, const Mix::Point& size, Mix::Graphics::FORMAT format, const wchar_t* pDebugName = NULL );

		void ReleaseAll( void );
		void ReleaseOwner( UInt32 owner );

		static UInt32 CameraOwner( UInt32 index );
	};

}}}
