#pragma once

#include "Mix/Geometry/Sphere.h"

namespace Mix{ namespace Scene{ namespace Common{

	//VhE}bsÕTvO( PCF )
	static const UInt32 RENDERER_SM_SAMPLING_NUM = 9;
	static const Mix::Vector4 SM_SAMPLING_OFFSET_TABLE[Mix::Scene::Common::RENDERER_SM_SAMPLING_NUM] =
	{
		Mix::Vector4( -1.0f, -1.0f, 0.0f, 0.0f ),
		Mix::Vector4(  0.0f, -1.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f, -1.0f, 0.0f, 0.0f ),

		Mix::Vector4( -1.0f,  0.0f, 0.0f, 0.0f ),
		Mix::Vector4(  0.0f,  0.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f,  0.0f, 0.0f, 0.0f ),

		Mix::Vector4( -1.0f, +1.0f, 0.0f, 0.0f ),
		Mix::Vector4(  0.0f, +1.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f, +1.0f, 0.0f, 0.0f ),
	};

	//ʊE[x̃TvO
	static const UInt32 RENDERER_DOF_SAMPLING_NUM = 12;
	static const Mix::Vector4 DOF_SAMPLING_OFFSET_TABLE[Mix::Scene::Common::RENDERER_DOF_SAMPLING_NUM] =
	{
		Mix::Vector4(  0.0f, -1.5f, 0.0f, 0.0f ),

		Mix::Vector4( -1.0f, -1.0f, 0.0f, 0.0f ),
		Mix::Vector4(  0.0f, -1.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f, -1.0f, 0.0f, 0.0f ),

		Mix::Vector4( -1.5f,  0.0f, 0.0f, 0.0f ),
		Mix::Vector4( -1.0f,  0.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f,  0.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.5f,  0.0f, 0.0f, 0.0f ),

		Mix::Vector4( -1.0f, +1.0f, 0.0f, 0.0f ),
		Mix::Vector4(  0.0f, +1.0f, 0.0f, 0.0f ),
		Mix::Vector4( +1.0f, +1.0f, 0.0f, 0.0f ),

		Mix::Vector4(  0.0f, +1.5f, 0.0f, 0.0f ),
	};

	//~mVeB̃gXtH[eNX`̃XP[
	static const Int32 RENDERER_LUM_TRANSFORM_SCALE	= 4;

	// TvO^Cv񋓒萔
	enum RENDERER_SAMPLING_TYPE
	{
		RST_COPY		= 0,	// Rs[
		RST_DOWN2x		= 1,	// _E 1/2
		RST_DOWN4x		= 2,	// _E 1/4

		RST_MAX			= 3,	// TvO^Cv
	};

	// ܃NX񋓒萔
	enum RENDERER_REFRACT_CLASS
	{
		RRC_UNKNOWN			= 0,	// s
		RRC_FRONT			= 1,	// ܖʂO
		RRC_BACK			= 2,	// ܖʂ
		RRC_OVERLAP			= 3,	// ܖʂƏdȂĂ ( OŏdĂQɂ킽ĕ`悵Ă邽߁AptH[}Xቺ )
	};

	// [JCg\
	struct LOCAL_LIGHT
	{
		//^Cv( Mix::Scene::IRendererObject::POINT_LIGHT or Mix::Scene::IRendererObject::SPOT_LIGHT )
		UInt32 type;

		//
		Mix::Vector3 pos;
		Mix::Vector3 atten;
		Mix::Vector4 color;

		//X|bg
		Mix::Vector3 dir;
		Float32 range;
		Float32 innerCos;
		Float32 outerCos;
		Float32 exp;

		//|Cg
		Float32 outerRadius;
		Float32 invDiffRadius;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Ɨp : VF[_[ɓnƂ͂Ȃ
		////////////////////////////////////////////////////////////////////////////////////////////////////

		/*
			E莞ɐݒ肳
		*/

		Mix::Geometry::Sphere bounds;
		Float32 z;
		Float32 minZ;
		Float32 maxZ;

		/*
			CeBOIuWFNgɕω(\[gp)
		*/

		Float32 offsetZ; //IuWFNg_ƂđO֌W
		Float32 effect;	//IuWFNgɑ΂ẴCg̉e( Cg̔a + IuWFNg̔a - S̋ )
	};

}}}
