#pragma once

namespace Mix{ namespace Scene{ namespace Common{

	class Factory;
	class Camera;

	class Renderer
	{
	protected:
		virtual ~Renderer( void ) {}

		virtual Boolean OnInitialize( const Mix::Scene::RENDERER_CONFIG& config ){ return True; }
		virtual Boolean OnUpdateConfig( const Mix::Scene::RENDERER_CONFIG& config ) { return True; }

	public:
		virtual void AddCameraView( Mix::Scene::Common::Camera* pInternalCamera ) = 0;
		virtual void RemoveCameraView( UInt32 viewID ) = 0;
		virtual Boolean UpdateCameraConfig( UInt32 viewID, const Mix::Scene::CAMERA_CONFIG& config, UInt32& modCaps ) = 0;

		virtual Boolean DragObject( UInt32 viewID, const Mix::Rectangle& viewRect, const Mix::Point& pos ) = 0;

		virtual void Draw( UInt32 viewID ) = 0;
		virtual void Finish( void ) = 0;

#ifdef _DEBUG
		virtual UInt32 Debug_GetCameraProfile( UInt32 viewID, UInt32 type, void* pProf, UInt32 size ) const = 0;
		virtual UInt32 Debug_GetCameraImageNum( UInt32 viewID, UInt32 type ) const = 0;
		virtual Boolean Debug_GetCameraImage( UInt32 viewID, UInt32 type, UInt32 index, Mix::Graphics::ITexture** ppTexture ) = 0;
#endif //_DEBUG

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}}
