#pragma once

#include "Mix/Geometry/Sphere.h"
#include "Mix/Scene/IPointLight.h"
#include "Mix/Class/Scene/Common/OctreeObject.h"

namespace Mix{ namespace Scene{ namespace Common{

	class PointLight : public Mix::Scene::IPointLight
	{
	public:
		struct PARAM
		{
			Mix::Vector3 pos;
			Mix::Vector3 atten;
			Mix::Vector4 color;
			Float32 outerRadius;
			Float32 invDiffRadius;
		};

	public:
		static PointLight* CreateInstance( void );

	private:
		Boolean m_bEnabled;
		Boolean m_bDisposed;
		Mix::Scene::Common::LocalLightObject* m_pOctObj;
		Mix::Geometry::Sphere m_Bounds;
		PointLight::PARAM m_Param;
		Float32 m_InnerRadius;

	private:
		PointLight( void );
		virtual ~PointLight( void );

		void UpdateBounds( void );

	public:
		void SetOctreeObject( Mix::Scene::Common::LocalLightObject* pOctreeObj );
		const PointLight::PARAM& GetParam( void ) const;
		void Dispose( void );

#ifdef _DEBUG
		void Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, UInt32 flags );
#endif //_DEBUG

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IPointLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Float32 GetInnerRadius( void ) const;
		virtual Float32 GetOuterRadius( void ) const;
		virtual void SetRadius( Float32 innerRadius, Float32 outerRadius );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILocalLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector4& GetColor( void ) const;
		virtual void SetColor( const Mix::Vector4& color );

		virtual Float32 GetLinearAttenuation( void ) const;
		virtual Float32 GetQuadraticAttenuation( void ) const;
		virtual Float32 GetExponentAttenuation( void ) const;
		virtual void SetAttenuation( Float32 l, Float32 q, Float32 e );

		virtual const Mix::Vector3& GetPosition( void ) const;
		virtual void SetPosition( const Mix::Vector3& pos );

		virtual void Refresh( void );

		virtual const Mix::Geometry::Sphere& GetBounds() const;

		virtual Boolean IsIllegal( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;

	public:
		static const Float32 MIN_DIFF_RADIUS;
		static const Float32 MIN_INV_DIFF_RADIUS;
	};

}}}
