#pragma once

#include <vector>

#include "Mix/Scene/IPlanter.h"
#include "Mix/Class/Container.h"
#include "Mix/Class/Scene/Common/RendererTypes.h"
#include "Mix/Class/Scene/Common/WidgetTypes.h"
#include "Mix/Class/Scene/Common/OctreeObject.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Planter : public Mix::Scene::IPlanter
	{
	private:
		enum PRIVATE_VALUE
		{
			TEX_COORD_SIMPLE	= 0,
			TEX_COORD_CROSS		= 4,
			TEX_COORD_MAX		= 12,

			DAT_NEAR			= 0,
			DAT_MID				= 1,
			DAT_FAR				= 2,
			DAT_MAX				= 3,

			QUADS_DEF_SIZE		= 64,
			QUADS_RESIZE_STEP	= 4,
		};

		struct INTERNAL_MODEL_DATA
		{
			UInt32 texCoordsPoint;
			const Mix::Vector2* texCoords;

			UInt32 numPoint;
			const Mix::Vector3* points;
		};

		struct INTERNAL_MODEL
		{
			Mix::Vector2 texCoords[Planter::TEX_COORD_MAX];
			INTERNAL_MODEL_DATA dat[Planter::DAT_MAX];
		};

		struct INTERNAL_UNIT
		{
			const INTERNAL_MODEL* pModel;
			Mix::Matrix4x4 worldMat;
			UInt32 quadStart;
		};

		typedef std::vector<INTERNAL_MODEL> ModelList;
		typedef std::vector<INTERNAL_UNIT> UnitList;
		typedef std::vector<Mix::Scene::Common::WIDGET_SPHERE_SUBSET> SubsetList;

	public:
		static Boolean CheckMaterial( Mix::Scene::IMaterial* pMaterial, const wchar_t* pLabel, const wchar_t* pDebugName );

		static Planter* CreateInstance( Mix::Scene::IMaterial* pMaterial,
										UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
										UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
										const wchar_t* pDebugName );

		static Planter* CreateInstance( const Mix::Matrix4x4& worldMat,
										Mix::Scene::IMaterial* pMaterial,
										UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
										UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
										const wchar_t* pDebugName );

	private:
		Planter::ModelList m_ModelList;
		Planter::UnitList m_UnitList;

		UInt32 m_Status;
		Mix::DynamicContainer<Mix::Scene::Common::WIDGET_QUAD> m_Quads;
		Planter::SubsetList m_SubsetList;
		Mix::Geometry::AABB m_Bounds;
		Mix::Scene::Common::PlanterObject* m_pOctObj;

		Mix::Scene::IMaterial* m_pMaterial;
		Boolean m_bLocalLighting;

		Boolean m_bDraw;
		UInt32 m_TRPriority;
		Mix::Scene::WATER_CONTAINS_RESULT m_WCResult;

#ifdef _DEBUG
		Mix::StringW m_DebugName;
#endif //_DEBUG

	protected:
		Planter(	Mix::Scene::IMaterial* pMaterial,
					UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
					UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
					const wchar_t* pDebugName );

		Planter(	const Mix::Matrix4x4& worldMat,
					Mix::Scene::IMaterial* pMaterial,
					UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
					UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
					const wchar_t* pDebugName );

		virtual ~Planter( void );

	private:
		void Initialize(	Mix::Scene::IMaterial* pMaterial,
							UInt32 numModel, const Mix::Scene::IPlanter::GRASS_MODEL* models,
							UInt32 numUnit, const Mix::Scene::IPlanter::GRASS_UNIT* units,
							const wchar_t* pDebugName );

		void TransformUnits( const Mix::Matrix4x4& mat );

		void UpdateQuads( UInt32 index );
		void FlashSubsets( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::Planter
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void SetOctreeObject( Mix::Scene::Common::PlanterObject* pOctObj );

		Boolean InternalRefresh( Float32 foStartZ, Float32 foMidZ, Float32 foEndZ, Float32 z );

		UInt32 GetSubsetCount( void ) const;
		Mix::Scene::Common::WIDGET_SPHERE_SUBSET* GetSubsets( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IPlanter
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Geometry::AABB& GetBounds( void ) const;

		virtual Boolean IsIgnored( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IWidget
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual void GetMaterial( Mix::Scene::IMaterial** ppMaterial );
		virtual Boolean SetMaterial( Mix::Scene::IMaterial* pMaterial );

		virtual Boolean CanLocalLighting( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IEntity
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDraw( void ) const;
		virtual void SetDraw( Boolean state );

		virtual Boolean IsLocalLighting( void ) const;
		virtual void SetLocalLighting( Boolean state );

		virtual UInt32 GetTransparencyPriority( void ) const;
		virtual void SetTransparencyPriority( UInt32 priority );

		virtual Mix::Scene::WATER_CONTAINS_RESULT GetDefaultWaterContainsResult( void ) const;
		virtual void SetDefaultWaterContainsResult( Mix::Scene::WATER_CONTAINS_RESULT result );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;

	private:
		static const UInt32 VS_INPUT_SIGUNATURE;

		static const Mix::Vector3 SIMPLE_POS_TABLE[4];
		static const Mix::Vector3 CROSS1_POS_TABLE[16];
		static const Mix::Vector3 CROSS2_POS_TABLE[24];

		static const UInt32 DEF_STATUS;

	public:
		static const wchar_t* FAILED_CREATE;
		static const wchar_t* FAILED_SET_MATERIAL;
	};

}}}
