#pragma once

#include <vector>

namespace Mix{ namespace Scene{ namespace Common{

	//NH[^jIL[\
	struct MOTION_QUATERNION_KEY
	{
		Float32 time;
		Float32 reserve;
		Mix::Quaternion value;

		bool operator () ( const MOTION_QUATERNION_KEY& l, const MOTION_QUATERNION_KEY& r )
		{
			return l.time < r.time;
		}

		bool operator () ( const float& l, const MOTION_QUATERNION_KEY& r )
		{
			return l < r.time;
		}

		bool operator () ( const MOTION_QUATERNION_KEY& l, const float& r )
		{
			return l.time < r;
		}
	};

	//NH[^jIL[Xg
	typedef std::vector<MOTION_QUATERNION_KEY> MotionQuaternionKeyList;

	//xN^[L[\
	struct MOTION_VECTOR_KEY
	{
		Float32 time;
		Mix::Vector3 value;

		bool operator () ( const MOTION_VECTOR_KEY& l, const MOTION_VECTOR_KEY& r )
		{
			return l.time < r.time;
		}

		bool operator () ( const float& l, const MOTION_VECTOR_KEY& r )
		{
			return l < r.time;
		}

		bool operator () ( const MOTION_VECTOR_KEY& l, const float& r )
		{
			return l.time < r;
		}
	};

	//xN^[L[Xg
	typedef std::vector<MOTION_VECTOR_KEY> MotionVectorKeyList;

	//Gg[Xe[g\
	struct MOTION_ENTRY_STATE
	{
		Boolean bPassed;
		Boolean bCall;

		MOTION_ENTRY_STATE( void )
		{
			bPassed = False;
			bCall = False;
		}
	};

	//[guh\
	struct MOTION_ROOT_BLEND
	{
		Float32 ratio;

		Mix::Quaternion rotation;
		Mix::Vector3 translation;
	};

	//{fBuh\
	struct MOTION_BODY_BLEND
	{
		UInt32 nodeIndex;

		Float32 ratio;

		Mix::Vector3 scaling;
		Mix::Quaternion rotation;
		Mix::Vector3 translation;

		Float32 transitionRatio;
		Mix::Vector3 prevScaling;
		Mix::Quaternion prevRotation;
		Mix::Vector3 prevTranslation;
	};

}}}
