#include "Mix/Class/Scene/Common/MotionState.h"
#include "Mix/Class/Scene/Common/MotionController.h"

namespace Mix{ namespace Scene{ namespace Common{

MotionState* MotionState::CreateInstance( MotionController* pController, const Mix::Scene::MOTION_HANDLE& handle )
{
	return new MotionState( pController, handle );
}

MotionState::MotionState( MotionController* pController, const Mix::Scene::MOTION_HANDLE& handle ) :
m_pController( pController ),
m_Handle( handle ),
m_Speed( 1.0f ),
m_BlendRatio( 1.0f ),
m_Frame( 0.0f ),
m_LoopCount( 0 ),
m_TransitionRatio( 0.0f )
{
}

MotionState::~MotionState( void )
{
}

void MotionState::Dispose( void )
{
	m_pController = NULL;
	m_Handle = NULL;
}

void MotionState::SetSpeed( Float32 speed )
{
	m_Speed = max( 0.0f, speed );
}

Float32 MotionState::GetSpeed( void ) const
{
	return m_Speed;
}

void MotionState::SetBlendRatio( Float32 blendRatio )
{
	m_BlendRatio = MIX_FLOAT_SATURATE( blendRatio );
}

Float32 MotionState::GetBlendRatio( void ) const
{
	return m_BlendRatio;
}

void MotionState::SetFrame( Float32 frame )
{
	m_Frame = frame;
}

Float32 MotionState::GetFrame( void ) const
{
	return m_Frame;
}

void MotionState::SetLoopCount( UInt32 loopCount )
{
	m_LoopCount = loopCount;
}

UInt32 MotionState::GetLoopCount( void ) const
{
	return m_LoopCount;
}

UInt32 MotionState::GetCondition( void ) const
{
	return m_pController->GetCondition( m_Handle );
}

void MotionState::SetTransitionRatio( Float32 ratio )
{
	m_TransitionRatio = MIX_FLOAT_SATURATE( ratio );
}

Float32 MotionState::GetTransitionRatio( void ) const
{
	return m_TransitionRatio;
}

}}}
