#pragma once

#include <vector>
#include "Mix/Reference.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Motion;

	class MotionEntryProcesser : public Mix::Reference
	{
	private:
		struct ENTRY
		{
			const Mix::Scene::MOTION_ENTRY_DESC* pDesc;

			Boolean bNotified;

			ENTRY( const Mix::Scene::MOTION_ENTRY_DESC* _pDesc )
			{
				pDesc = _pDesc;
				bNotified = False;
			}
		};

		typedef std::vector<MotionEntryProcesser::ENTRY> EntryList;

	public:
		static MotionEntryProcesser* CreateInstance( void );

	private:
		Mix::Scene::Common::Motion* m_pSubject;
		Mix::Scene::MOTION_HANDLE m_Handle;
		Mix::Scene::IMotionListener* m_pListener;
		MotionEntryProcesser::EntryList m_EntryList;

	private:
		MotionEntryProcesser( void );
		virtual ~MotionEntryProcesser( void );

	public:
		void SetSubjectPtr( Mix::Scene::Common::Motion* pSubject );
		void Build( const Mix::Scene::MOTION_ENTRY_DESC* entries, UInt32 count );

	public:
		void SetHandle( const Mix::Scene::MOTION_HANDLE& handle );
		void SetListener( Mix::Scene::IMotionListener* pListener );
		void ResetNotify( void );
		void Notify( Float32 startFrame, Float32 endFrame );
	};

}}}
