#pragma once

#include <vector>

#include "Mix/Reference.h"

#include "Mix/Class/Container.h"
#include "Mix/Class/Scene/Common/MotionTypes.h"

namespace Mix{ namespace Scene{ namespace Common{

	class ActorModel;
	class Motion;
	class MotionCurve;

	class MotionDeformer : public Mix::Reference
	{
	private:
		struct CURVE
		{
			MotionCurve* pInterface;
			UInt32 nodeIndex;

			CURVE( MotionCurve* _pInterface, UInt32 _nodeIndex );
		};

		typedef std::vector<MotionDeformer::CURVE> CurveList;

	public:
		static MotionDeformer* CreateInstance(	Mix::Scene::Common::ActorModel* pModel,
												Mix::Scene::Common::Motion* pMotion );

	private:
		MotionDeformer::CurveList m_CurveList;

	private:
		MotionDeformer(	Mix::Scene::Common::ActorModel* pModel,
						Mix::Scene::Common::Motion* pMotion );

		virtual ~MotionDeformer( void );

	public:
		void Execute( Float32 blendRatio, Float32 frame, Mix::Container<Mix::Scene::Common::MOTION_BODY_BLEND>& container );
	};

}}}
