#pragma once

#include <vector>

#include "Mix/Reference.h"
#include "Mix/Class/Scene/Common/MotionTypes.h"

namespace Mix{ namespace File{
	class IReader;
}}

namespace Mix{ namespace Scene{ namespace Common{

	class MotionCurve : public Mix::Reference
	{
	private:
		struct MOT_CURV_DESC
		{
			wchar_t linkNodeName[32];
			UInt32 scalingKeyNum;
			UInt32 rotationKeyNum;
			UInt32 translationKeyNum;
			UInt32 reserve;
		};

	private:
		Mix::String m_LinkNodeName;
		Mix::Scene::Common::MotionVectorKeyList m_ScalingKeyList;
		Mix::Scene::Common::MotionQuaternionKeyList m_RotationKeyList;
		Mix::Scene::Common::MotionVectorKeyList m_TranslationKeyList;

	public:
		static MotionCurve* CreateInstance( Mix::File::IReader* pReader, const wchar_t* pNameLabel, const wchar_t* pName );

	private:
		MotionCurve( void );
		virtual ~MotionCurve( void );

	public:
		const wchar_t* GetLinkNodeName( void ) const;

		Mix::Vector3 GetScaling( float time );
		Mix::Quaternion GetRotation( float time );
		Mix::Vector3 GetTranslation( float time );

	private:
		static const wchar_t* FAILED_CREATE;
	};

}}}
