#include "Mix/Class/Scene/Common/Mesh.h"

#include "Mix/Graphics/IVertexBuffer.h"
#include "Mix/Graphics/IIndexBuffer.h"

namespace Mix{ namespace Scene{ namespace Common{

Mesh::Mesh( void ) :
m_pVertexBuffer( NULL ),
m_pIndexBuffer( NULL )
{
}

Mesh::~Mesh( void )
{
	MIX_RELEASE( m_pVertexBuffer );
	MIX_RELEASE( m_pIndexBuffer );
}

Mix::Graphics::IVertexBuffer* Mesh::GetVertexBufferPtr( void ) const
{
	return m_pVertexBuffer;
}

Mix::Graphics::IIndexBuffer* Mesh::GetIndexBufferPtr( void ) const
{
	return m_pIndexBuffer;
}

}}}
