#pragma once

#include <map>
#include <vector>
#include "Mix/AtomicValue.h"
#include "Mix/Scene/IManager.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Renderer;

	class Manager : public Mix::Scene::IManager
	{
	private:
		typedef std::map<Mix::Scene::IMaterial*, Mix::AtomicValue> UpdateMaterialMap;
		typedef std::vector<Mix::Scene::Common::Renderer*> RendererList;

	private:
		Mix::File::IManager* m_pFileManager;
		Mix::Graphics::IDevice* m_pGraphicsDevice;

		Manager::UpdateMaterialMap m_UpdateMaterialMap;
		Manager::RendererList m_RendererList;

	public:
		static Manager* CreateInstance( void );
		void Dispose( void );

	private:
		Manager( void );
		virtual ~Manager( void );

	public:
		void Update( Float32 dt );

		void AddUpdateMaterial( Mix::Scene::IMaterial* pMaterial );
		void RemoveUpdateMaterial( Mix::Scene::IMaterial* pMaterial );

		void AddRenderer( Mix::Scene::Common::Renderer* pRenderer );
		void RemoveRenderer( Mix::Scene::Common::Renderer* pRenderer );

	public:
		virtual Boolean CreateFactory( const wchar_t* pMEPDirPath, const wchar_t* pMEPName, Mix::Scene::IFactory** ppFactory );

		virtual const Mix::Vector4& Debug_GetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type ) const;
		virtual void Debug_SetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type, const Mix::Vector4& color );
	};

}}}
