#pragma once

#include "Mix/Scene/ILightShaftsCaster.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Camera;

	class LightShaftsCaster : public Mix::Scene::ILightShaftsCaster
	{
	public:
		struct PARAM
		{
			Mix::Vector2 pos;
			Float32 EdotL;
		};

	public:
		static LightShaftsCaster* CreateInstance( void );

	private:
		Mix::Vector3 m_Pos;
		Boolean m_bDisposed;

	private:
		LightShaftsCaster( void );
		virtual ~LightShaftsCaster( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::LightShaftsCaster
		////////////////////////////////////////////////////////////////////////////////////////////////////

		Boolean GetParam( Mix::Scene::Common::Camera* pCamera, LightShaftsCaster::PARAM& param );

		void Dispose( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILightShaftsCaster
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetPosition( void ) const;
		virtual void SetPosition( const Mix::Vector3& pos );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
	};

}}}
