#include "Mix/Class/Scene/Common/LightShaftsCaster.h"

#include "Mix/Graphics/ITexture.h"
#include "Mix/Class/Scene/Common/Camera.h"

namespace Mix{ namespace Scene{ namespace Common{

LightShaftsCaster* LightShaftsCaster::CreateInstance( void )
{
	return new LightShaftsCaster();
}

LightShaftsCaster::LightShaftsCaster( void ) :
m_bDisposed( False )
{
}

LightShaftsCaster::~LightShaftsCaster( void )
{
}

Boolean LightShaftsCaster::GetParam( Mix::Scene::Common::Camera* pCamera, LightShaftsCaster::PARAM& param )
{
	MIX_ASSERT( pCamera != NULL );

	Mix::Vector3 pos = pCamera->GetViewProjectionMatrix() * m_Pos;

	if( ( pos.z < 0.0f ) || ( pos.z > 1.0f ) )
	{
		return False;
	}

	Float32 invFarZ = MIX_FLOAT_RECIPROCAL( pCamera->GetFarZ() );

	param.pos.x = 1.0f - ( -pos.x * 0.5f + 0.5f );
	param.pos.y = 1.0f - ( +pos.y * 0.5f + 0.5f );
	param.EdotL = Mix::Vector3::Dot( pCamera->GetViewForward(), m_Pos.ToNormalize() );

	return True;
}

void LightShaftsCaster::Dispose( void )
{
	m_bDisposed = True;
}

const Mix::Vector3& LightShaftsCaster::GetPosition( void ) const
{
	return m_Pos;
}

void LightShaftsCaster::SetPosition( const Mix::Vector3& pos )
{
	m_Pos = pos;
}

Boolean LightShaftsCaster::IsDisposed( void ) const
{
	return m_bDisposed;
}

Mix::Scene::IRendererObject::TYPE LightShaftsCaster::GetType( void ) const
{
	return Mix::Scene::IRendererObject::LIGHT_SHAFTS_CASTER;
}

}}}
