#pragma once

#include "Mix/Scene/IParticleProcessor.h"
#include "Mix/Geometry/AABB.h"
#include "Mix/Class/Container.h"
#include "Mix/Class/Scene/Common/WidgetTypes.h"
#include "Mix/Scene/IParticleSystem.h"

namespace Mix{ namespace Scene{ namespace Common{

	class InternalParticle
	{
	protected:
		Mix::Scene::IMaterial* m_pMaterial;
		UInt32 m_VertexDataSize;
		UInt32 m_VertexTWOffset;

		Mix::DynamicContainer<Mix::Scene::Common::WIDGET_QUAD> m_QuadPool; //h̃NXŏ

#ifdef _DEBUG
		Mix::StringW m_DebugName;
		UInt32 m_DebVertexStride;
#endif //_DEBUG
		
	protected:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// 
		////////////////////////////////////////////////////////////////////////////////////////////////////

		InternalParticle( const wchar_t* pDebugName );
		virtual ~InternalParticle( void );

		void GetMaterial( Mix::Scene::IMaterial** ppMaterial );
		Boolean SetMaterial( Mix::Scene::IMaterial* pMaterial );

		void FlashQuads( void ); // NbhɕKvȏݒ
		void ExtendQuadsPool( UInt32 addCount ); // Nbhv[̊g

	public:
		//ݒł}eÃ`FbN
		static Boolean CheckMaterial( Mix::Scene::IMaterial* pMaterial, const wchar_t* pLabel, const wchar_t* pDebugName );
		//TuZbgɃr{[hsKp
		static void FixedBillboardSubset( const Mix::Matrix4x4& mat, Mix::Scene::Common::WIDGET_QUAD** quads, UInt32 quadNum );

	protected:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// [rO
		//   subset  quadCount ppQuads bounds.min bounds.max XV( ComputePoints ͍sĂ܂ )
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void RefreshDefaultSubset(	Boolean bIndividual,
									const Mix::Matrix4x4& worldMat,
									const Mix::Scene::IParticleProcessor::FACE* faces,
									UInt32 faceNum,
									UInt32 quadOffset,
									Mix::Scene::Common::WIDGET_AABB_SUBSET& subset );

		void RefreshBillboardSubset(	Boolean bIndividual,
										const Mix::Matrix4x4& worldMat,
										const Mix::Scene::IParticleProcessor::FACE* faces,
										UInt32 faceNum,
										UInt32 quadOffset,
										Mix::Scene::Common::WIDGET_AABB_SUBSET& subset );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// XLb^[
		//   subset  quadCount ppQuads bounds.center bounds.radius XV
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void RefreshDefaultSubset(	const Mix::Matrix4x4& worldMat,
									const Mix::Scene::IParticleProcessor::FACE* faces,
									UInt32 faceNum,
									UInt32 quadOffset,
									Mix::Scene::Common::WIDGET_SPHERE_SUBSET& subset );

		void RefreshBillboardSubset(	const Mix::Scene::IParticleProcessor::FACE* faces,
										UInt32 faceNum,
										UInt32 quadOffset,
										Mix::Scene::Common::WIDGET_SPHERE_SUBSET& subset );

	protected:
		static const UInt32 ES_POS_COL;
		static const UInt32 ES_TANGENTSPACE;
		static const UInt32 ES_NORMAL;
		static const UInt32 ES_MASK0;
		static const UInt32 ES_MASK1;

		static const wchar_t* STR_ONLY_DEFMATERIAL;
		static const wchar_t* STR_ILLEGAL_IS;
		static const wchar_t* STR_NS_BUMP;
	};

}}}
