#pragma once

#include "Mix/Scene/IHemisphereLight.h"

namespace Mix{ namespace Scene{ namespace Common{

	class HemisphereLight : public Mix::Scene::IHemisphereLight
	{
	private:
		Mix::Vector3 m_Axis;
		Mix::Vector4 m_GroundColor;
		Mix::Vector4 m_SkyColor;
		Boolean m_bEnabled;
		Boolean m_bDisposed;

	public:
		static HemisphereLight* CreateInstance( void );

	private:
		HemisphereLight( void );
		virtual ~HemisphereLight( void );

	public:
		void Dispose( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IHemisphereLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetAxis( void ) const;
		virtual void SetAxis( const Mix::Vector3& axis );

		virtual const Mix::Vector4& GetGroundColor( void ) const;
		virtual void SetGroundColor( const Mix::Vector4& color );

		virtual const Mix::Vector4& GetSkyColor( void ) const;
		virtual void SetSkyColor( const Mix::Vector4& color );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
	};

}}}
