#include "Mix/Class/Scene/Common/HemisphereLight.h"

namespace Mix{ namespace Scene{ namespace Common{

HemisphereLight* HemisphereLight::CreateInstance( void )
{
	return new HemisphereLight();
}

HemisphereLight::HemisphereLight( void ) :
m_Axis( 0.0f, 1.0f, 0.0f ),
m_GroundColor( 0.0f, 0.0f, 0.0f, 1.0f ),
m_SkyColor( 0.0f, 0.0f, 0.0f, 1.0f ),
m_bEnabled( False ),
m_bDisposed( False )
{
}

HemisphereLight::~HemisphereLight( void )
{
}

void HemisphereLight::Dispose( void )
{
	m_bDisposed = True;
}

const Mix::Vector3& HemisphereLight::GetAxis( void ) const
{
	return m_Axis;
}

void HemisphereLight::SetAxis( const Mix::Vector3& axis )
{
	m_Axis = axis.ToNormalize();
}

const Mix::Vector4& HemisphereLight::GetGroundColor( void ) const
{
	return m_GroundColor;
}

void HemisphereLight::SetGroundColor( const Mix::Vector4& color )
{
	m_GroundColor = color.ToSaturate();
}

const Mix::Vector4& HemisphereLight::GetSkyColor( void ) const
{
	return m_SkyColor;
}

void HemisphereLight::SetSkyColor( const Mix::Vector4& color )
{
	m_SkyColor = color.ToSaturate();
}

Boolean HemisphereLight::IsEnabled( void ) const
{
	return m_bEnabled;
}

void HemisphereLight::SetEnabled( Boolean state )
{
	m_bEnabled = state;
}

Boolean HemisphereLight::IsDisposed( void ) const
{
	return m_bDisposed;
}

Mix::Scene::IRendererObject::TYPE HemisphereLight::GetType( void ) const
{
	return Mix::Scene::IRendererObject::HEMISPHERE_LIGHT;
}

}}}
