#pragma once

#include "Mix/Scene/IGhost.h"

namespace Mix{ namespace Dynamics{
	class IWorld;
	class IObject;
	class IObjectListener;
}}

namespace Mix{ namespace Scene{ namespace Common{

	class DynamicsObject;

	class Ghost : public Mix::Scene::IGhost
	{
	private:
		Boolean m_bDisposed;

		Int32 m_UserIndex;
		void* m_pUserPtr;

	protected:
		Ghost( void );
		virtual ~Ghost( void );

	public:
		virtual Mix::Dynamics::IObject* GetInternalObjectPtr( void ) const = 0;

		virtual void Attach( Mix::Dynamics::IWorld* pWorld, Mix::Dynamics::IObjectListener* pObjectListener ) = 0;
		virtual void Detach( Mix::Dynamics::IWorld* pWorld ) = 0;

		virtual void Dispose( void );

	public:
		/*
			Mix::Scene::IGhost
		*/

		virtual Float32 Debug_GetDrawAxisScaling( void ) const;
		virtual void Debug_SetDrawAxisScaling( Float32 scaling );

		/*
			Mix::Scene::IRendererResource
		*/

		virtual Boolean IsDisposed( void ) const;

		/*
			Mix::Scene::IRendererObject
		*/

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;

		virtual Int32 GetUserIndex( void )  const;
		virtual void SetUserIndex( Int32 index );

		virtual void* GetUserPtr( void ) const;
		virtual void SetUserPtr( void* pData );

	public:
		static const wchar_t* FAILED_ADD;
	};

}}}
