#include "Mix/Class/Scene/Common/Ghost.h"

#include "Mix/Dynamics/IObject.h"
#include "Mix/Class/Scene/Common/DynamicsObject.h"

namespace Mix{ namespace Scene{ namespace Common{

const wchar_t* Ghost::FAILED_ADD = L"S[Xg̒ǉɎs";

Ghost::Ghost( void ) :
m_bDisposed( False ),
m_UserIndex( 0 ),
m_pUserPtr( NULL )
{
}

Ghost::~Ghost( void )
{
}

void Ghost::Dispose( void )
{
	m_bDisposed = True;
}

Float32 Ghost::Debug_GetDrawAxisScaling( void ) const
{
#ifdef _DEBUG

	Mix::Dynamics::IObject* pInternalObject = GetInternalObjectPtr();
	if( pInternalObject != NULL )
	{
		return pInternalObject->Debug_GetDrawAxisScaling();
	}

#endif //_DEBUG

	return 0.0f;
}

void Ghost::Debug_SetDrawAxisScaling( Float32 scaling )
{
#ifdef _DEBUG

	Mix::Dynamics::IObject* pInternalObject = GetInternalObjectPtr();
	if( pInternalObject != NULL )
	{
		pInternalObject->Debug_SetDrawAxisScaling( scaling );
	}

#endif //_DEBUG
}

Boolean Ghost::IsDisposed( void ) const
{
	return m_bDisposed;
}

Mix::Scene::IRendererObject::TYPE Ghost::GetType( void ) const
{
	return Mix::Scene::IRendererObject::GHOST;
}

Int32 Ghost::GetUserIndex( void )  const
{
	return m_UserIndex;
}

void Ghost::SetUserIndex( Int32 index )
{
	m_UserIndex = index;
}

void* Ghost::GetUserPtr( void ) const
{
	return m_pUserPtr;
}

void Ghost::SetUserPtr( void* pData )
{
	m_pUserPtr = pData;
}

}}}
