#pragma once

#include <map>
#include "Mix/Scene/IFactory.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Manager;
	class ActorLoader;
	class TerrainLoader;

	class Factory : public Mix::Scene::IFactory
	{
	protected:
		//VF[_[^Cv񋓒萔
		enum SHADER_TYPES
		{
			// ̑ //

			SHADER_SAMPLING_VS					= 1,	// VS : TvO
			SHADER_SAMPLING_COPY_PS				= 2,	// PS : TvO : Rs[
			SHADER_SAMPLING_DOWN2X_PS			= 3,	// PS : TvO : _E2X
			SHADER_SAMPLING_DOWN4X_PS			= 4,	// PS : TvO : _E4X

			SHADER_BLUR3X_X_PS					= 5,	// PS : u[ : 3Tv : X
			SHADER_BLUR3X_Y_PS					= 6,	// PS : u[ : 3Tv : Y
			SHADER_BLUR5X_X_PS					= 7,	// PS : u[ : 5Tv : X
			SHADER_BLUR5X_Y_PS					= 8,	// PS : u[ : 5Tv : Y

			SHADER_GAUSSIAN_BLUR_X_VS			= 9,	// VS : KEVAu[ : ftHg X
			SHADER_GAUSSIAN_BLUR_X_PS			= 10,	// PS : KEVAu[ : ftHg X
			SHADER_GAUSSIAN_BLUR_Y_VS			= 11,	// VS : KEVAu[ : ftHg Y
			SHADER_GAUSSIAN_BLUR_Y_PS			= 12,	// PS : KEVAu[ : ftHg Y

			SHADER_GAUSSIAN_BLUR_EX_PS			= 13,	// PS : KEVAu[ : GNZg

			SHADER_BP____PS						= 14,	// PS : uCgpX --- ( L=LUM A=AUTO_MIDDLEGRAY )
			SHADER_BP_L__PS						= 15,	// PS : uCgpX L--
			SHADER_BP_LA_PS						= 16,	// PS : uCgpX LA-

			// XJCh[ //

			SHADER_SKYDOME_DEFAULT_VS			= 20,	// VS : ftHg
			SHADER_SKYDOME_DEFAULT______PS		= 21,	// PS : ftHg : ---- : ( B=BASE_TEXTURE ( C=CLOUD or C2=CLOUD_LAYER ) L=CLOUD_LIGHTING )
			SHADER_SKYDOME_DEFAULT__C___PS		= 22,	// PS : ftHg : -C--
			SHADER_SKYDOME_DEFAULT__C2__PS		= 23,	// PS : ftHg : _C2-
			SHADER_SKYDOME_DEFAULT_B____PS		= 24,	// PS : ftHg : B---
			SHADER_SKYDOME_DEFAULT_BC___PS		= 25,	// PS : ftHg : BC--
			SHADER_SKYDOME_DEFAULT_BC2__PS		= 26,	// PS : ftHg : BC2-

			SHADER_SKYDOME_ATMOSPHERE_VS		= 27,	// VS : CUV~[V
			SHADER_SKYDOME_ATMOSPHERE______PS	= 28,	// PS : CUV~[V : ----
			SHADER_SKYDOME_ATMOSPHERE__C___PS	= 29,	// PS : CUV~[V : -C--
			SHADER_SKYDOME_ATMOSPHERE__C_L_PS	= 30,	// PS : CUV~[V : -C-L
			SHADER_SKYDOME_ATMOSPHERE__C2__PS	= 31,	// PS : CUV~[V : -C2-
			SHADER_SKYDOME_ATMOSPHERE__C2L_PS	= 32,	// PS : CUV~[V : -C2L
			SHADER_SKYDOME_ATMOSPHERE_B____PS	= 33,	// PS : CUV~[V : B---
			SHADER_SKYDOME_ATMOSPHERE_BC___PS	= 34,	// PS : CUV~[V : BC--
			SHADER_SKYDOME_ATMOSPHERE_BC_L_PS	= 35,	// PS : CUV~[V : BC-L
			SHADER_SKYDOME_ATMOSPHERE_BC2__PS	= 36,	// PS : CUV~[V : BC2-
			SHADER_SKYDOME_ATMOSPHERE_BC2L_PS	= 37,	// PS : CUV~[V : BC2L

			SHADER_SKYDOME_PANORAMA_VS			= 38,	// VS : pm}
			SHADER_SKYDOME_PANORAMA_FA_VS		= 39,	// VS : pm} : tHO ( CUV~[V )
			SHADER_SKYDOME_PANORAMA_PS			= 40,	// PS : pm}
			SHADER_SKYDOME_PANORAMA_FD_PS		= 41,	// PS : pm} : tHO ( ftHg )
			SHADER_SKYDOME_PANORAMA_FA_PS		= 42,	// PS : pm} : tHO ( CUV~[V )

			// |XgGtFNg //

			SHADER_SSAO_PS						= 50,	// PS : SSAO
			SHADER_SSAO_TEX_PS					= 51,	// PS : SSAO( eNX`L )

			SHADER_SM_DOWN2X_PS					= 52,	// PS : VhE}bsO : _E1/2
			SHADER_SM_DOWN4X_PS					= 53,	// PS : VhE}bsO : _E1/4
			SHADER_SM_FINISH_PS					= 54,	// PS : VhE}bsO : tBjbV

			SHADER_UNDER_WATER_PS				= 55,	// PS : 

			SHADER_LUM_TRANSFORM_INITAL_PS		= 56,	// PS : Px : gXtH[ : 
			SHADER_LUM_TRANSFORM_ITERATE_PS		= 57,	// PS : Px : gXtH[ : JԂ
			SHADER_LUM_TRANSFORM_FINAL_PS		= 58,	// PS : Px : gXtH[ : Ō
			SHADER_LUM_ADAPTED_PS				= 59,	// PS : Px : A_vebh

			SHADER_LUM_OPERATOR_STATIC_PS		= 60,	// PS : Px : Iy[^ : ԐF͎w
			SHADER_LUM_OPERATOR_DYNAMIC_PS		= 61,	// PS : Px : Iy[^ : ԐF͎

			SHADER_LUM_OPERATOR___B_PS			= 60,	// PS : Px : Iy[^ __B ( T=TONE_MAPPING A=AUTOMATIC_MIDDLEGRAY B=BLUE_SHIFT )
			SHADER_LUM_OPERATOR_T___PS			= 61,	// PS : Px : Iy[^ T__
			SHADER_LUM_OPERATOR_T_B_PS			= 62,	// PS : Px : Iy[^ T_B
			SHADER_LUM_OPERATOR_TA__PS			= 63,	// PS : Px : Iy[^ TA_
			SHADER_LUM_OPERATOR_TAB_PS			= 64,	// PS : Px : Iy[^ TAB

			SHADER_LS_INIT___PS					= 65,	// PS : CgVtg :  ( A=ACUITY_TEX )
			SHADER_LS_INIT_A_PS					= 66,	// PS : CgVtg : 
			SHADER_LS_BLUR_L_PS					= 67,	// PS : CgVtg : u[( LOW )
			SHADER_LS_BLUR_M_PS					= 68,	// PS : CgVtg : u[( MIDDLE )
			SHADER_LS_BLUR_H_PS					= 69,	// PS : CgVtg : u[( HIGH )

			SHADER_LENS_DIST___PS				= 70,	// PS : Y : fBXg[V( K=K_CUBE )
			SHADER_LENS_DIST_K_PS				= 71,	// PS : Y : fBXg[V

			SHADER_LF_IMAGE____PS				= 72,	// PS : YtA : C[W( G=GHOST_TEX H=HALO )
			SHADER_LF_IMAGE__H_PS				= 73,	// PS : YtA : C[W _H
			SHADER_LF_IMAGE_G__PS				= 74,	// PS : YtA : C[W G_
			SHADER_LF_IMAGE_GH_PS				= 75,	// PS : YtA : C[W GH
			SHADER_LF_MODIFY____PS				= 76,	// PS : YtA : fBt@C( D=DIRT B=BRUSH )
			SHADER_LF_MODIFY_D__PS				= 77,	// PS : YtA : fBt@C D
			SHADER_LF_MODIFY__B_PS				= 78,	// PS : YtA : fBt@C B
			SHADER_LF_MODIFY_DB_PS				= 79,	// PS : YtA : fBt@C DB

			SHADER_FI_HEJL_PS					= 80,	// PS : tB~bN : Jim Hejl
			SHADER_FI_HABLE_PS					= 81,	// PS : tB~bN : John Hable

			SHADER_GAMMA_PS						= 82,	// PS : K}␳

			SHADER_CA_IMAGE___PS				= 83,	// PS : F : C[W _ ( K=K_CUBE )
			SHADER_CA_IMAGE_K_PS				= 84,	// PS : F : C[W K
			SHADER_CA_FINISH___PS				= 85,	// PS : F : tBjbV _ ( D=DEPTH )
			SHADER_CA_FINISH_D_PS				= 86,	// PS : F : tBjbV D

			SHADER_DOF_PS						= 87,	// PS : ʊE[x

			SHADER_VIGNETTE_PS					= 88,	// PS : rlbg

			SHADER_AA_FXAA_PS					= 89,	// PS : A`ACAX : FXAA
		};

		//VF[_[oCi\
		struct SHADER_BINARY
		{
			enum VALUE{ NAME_SIZE = 64, };

			wchar_t name[SHADER_BINARY::NAME_SIZE];
			const void* pData;
			UInt32 dataSize;
		};

	public:
		//GtFNg^Cv񋓒萔
		enum EFFECT_TYPE
		{
			E_RESIDENT = 0,
			E_MATERIAL = 1,
		};

		//풓GtFNgIvV񋓒萔
		enum EFFECT_RESIDENT_OPT
		{
			ER_SAMPLING				= 0,
			ER_BLUR3X				= 1,
			ER_BLUR5X				= 2,
			ER_GAUSSIAN_BLUR		= 3,
			ER_GAUSSIAN_BLUR_EX		= 4,
			ER_BRIGHTPASS			= 5,

			ER_SKYDOME_DEFAULT		= 6,
			ER_SKYDOME_ATMOSPHERE	= 7,
			ER_SKYDOME_PANORAMA_D	= 8,
			ER_SKYDOME_PANORAMA_A	= 9,

			ER_SSAO					= 10,
			ER_SM					= 11,
			ER_UNDER_WATER			= 12,
			ER_LUMINANCE			= 13,
			ER_LIGHT_SHAFTS			= 14,
			ER_LENS_FLARE			= 15,
			ER_FILMIC				= 16,
			ER_GAMMA				= 17,
			ER_CHROMATISM			= 18,
			ER_DOF					= 19,
			ER_LENS_DIST			= 20,
			ER_VIGNETTE				= 21,
			ER_FXAA					= 22,
		};

		//o[ebNXGtFNgVF[_[\
		enum VERTEX_EFFECT_SHADER
		{
			VES_DEFAULT				= 0,

			VES_GAUSSIAN_BLUR_X		= 0,
			VES_GAUSSIAN_BLUR_Y		= 1,

			VES_SKYDOME_PANORAMA	= 0,
			VES_SKYDOME_PANORAMA_F	= 1,

			VES_MATERIAL_COLOR		= 0,
			VES_MATERIAL_MASK		= 1,
			VES_MATERIAL_SHADOW		= 2,
			VES_MATERIAL_MAX		= 3,

			VES_MAX					= 3,
		};

		//sNZGtFNgVF[_[\
		enum PIXEL_EFFECT_SHADER
		{
			PES_DEFAULT					= 0,

			PES_MATERIAL_COLOR			= 0,
			PES_MATERIAL_MASK			= 1,
			PES_MATERIAL_SHADOW			= 2,
			PES_MATERIAL_MAX			= 3,

			PES_SD_DEF_____				= 0,
			PES_SD_DEF__C__				= 1,
			PES_SD_DEF__C2_				= 2,
			PES_SD_DEF_B___				= 3,
			PES_SD_DEF_BC__				= 4,
			PES_SD_DEF_BC2_				= 5,

			PES_SD_ASS_____				= 0,
			PES_SD_ASS__C__				= 1,
			PES_SD_ASS__C_L				= 2,
			PES_SD_ASS__C2_				= 3,
			PES_SD_ASS__C2L				= 4,
			PES_SD_ASS_B___				= 5,
			PES_SD_ASS_BC__				= 6,
			PES_SD_ASS_BC_L				= 7,
			PES_SD_ASS_BC2_				= 8,
			PES_SD_ASS_BC2L				= 9,

			PES_SD_PANORAMA				= 0,
			PES_SD_PANORAMA_F			= 1,

			PES_SAMPLING_COPY			= 0,
			PES_SAMPLING_DOWN2X			= 1,
			PES_SAMPLING_DOWN4X			= 2,

			PES_COMMON_BLUR_X			= 0,
			PES_COMMON_BLUR_Y			= 1,

			PES_BP___					= 0,
			PES_BP_L_					= 1,
			PES_BP_LA					= 2,

			PES_SSAO					= 0,
			PES_SSAO_TEX				= 1,

			PES_SM_DOWN2X				= 0,
			PES_SM_DOWN4X				= 1,
			PES_SM_FINISH				= 2,

			PES_LUM_TR_INITAL			= 0,
			PES_LUM_TR_ITERATE			= 1,
			PES_LUM_TR_FINAL			= 2,
			PES_LUM_ADAPTED				= 3,
			PES_LUM_OP___B				= 4,
			PES_LUM_OP_T__				= 5,
			PES_LUM_OP_T_B				= 6,
			PES_LUM_OP_TA_				= 7,
			PES_LUM_OP_TAB				= 8,

			PES_LS_INIT__				= 0,
			PES_LS_INIT_A				= 1,
			PES_LS_BLUR_L				= 2,
			PES_LS_BLUR_M				= 3,
			PES_LS_BLUR_H				= 4,

			PES_LF_IMAGE___				= 0,
			PES_LF_IMAGE__H				= 1,
			PES_LF_IMAGE_G_				= 2,
			PES_LF_IMAGE_GH				= 3,
			PES_LF_MODIFY___			= 4,
			PES_LF_MODIFY_D_			= 5,
			PES_LF_MODIFY__B			= 6,
			PES_LF_MODIFY_DB			= 7,

			PES_FI_HEJL					= 0,
			PES_FI_HABLE				= 1,

			PES_CA_IMAGE__				= 0,
			PES_CA_IMAGE_K				= 1,
			PES_CA_FINISH__				= 2,
			PES_CA_FINISH_D				= 3,
			
			PES_LD__					= 0,
			PES_LD_K					= 1,

			PES_MAX						= 10,
		};

		//GtFNgvZXtO
		enum EFFECT_PROCESS_FLAG
		{
			EP_FOG			= 0x00000001,
			EP_SHADOW		= 0x00000002,
			EP_REFRACT		= 0x00000004,
			EP_ATMOSPHERE	= 0x00000040,
			EP_SSAO			= 0x00000100,

			// j\
//			EP_SOFTPARTICLE	= 0x00000008,
//			EP_BLOOM		= 0x00000010,
//			EP_DOF			= 0x00000020,
//			EP_LUMINANCE	= 0x00000080,
		};

		//o[ebNXGtFNg\
		struct VERTEX_EFFECT
		{
			Mix::Graphics::IVertexLayout* pLayout;
			Mix::Graphics::IVertexShader* pShader[Factory::VES_MAX];

			VERTEX_EFFECT( void );
			void Dispose( void );
		};

		//sNZGtFNg\
		struct PIXEL_EFFECT
		{
			Mix::Graphics::IPixelShader* pShader[Factory::PES_MAX];

			PIXEL_EFFECT( void );
			void Dispose( void );
		};

		//MEP̒l
		enum MEP_VALUE
		{
			MEP_MAGICNUMBER		= 0x5F50454D,

			MEP_VERSION_OLD		= 0x01000000,
			MEP_VERSION			= 0x01010000,

			MEP_MTL_SHADER_MAX	= 3,
		};

		//MEP_[^Cv񋓒萔
		enum MEP_RENDERER_TYPE
		{
			MEP_RT_STANDARD = 0,
			MEP_RT_MAX		= 1,
		};

		//MEPt@Cwb_\
		struct MEP_FILE_HEADER
		{
			UInt32 magicNumber;
			UInt32 version;
		};

		//MEPf[^wb_\
		struct MEP_DATA_HEADER
		{
			UInt32 rendererType;
			UInt32 processFlags;
			UInt32 vertexShaderNum;
			UInt32 pixelShaderNum;
		};

		//MEPo[ebNXVF[_[wb_\
		struct MEP_VS_HEADER
		{
			UInt32 id;
			UInt32 buffSize[Factory::VES_MATERIAL_MAX];
			UInt32 elementNum;
			UInt32 reserve;
		};

		//MEPsNZVF[_[wb_\
		struct MEP_PS_HEADER
		{
			UInt32 id;
			UInt32 buffSize[Factory::PES_MATERIAL_MAX];
		};

		typedef std::map<UInt32, Factory::VERTEX_EFFECT> VertexEffectMap;
		typedef std::map<UInt32, Factory::PIXEL_EFFECT> PixelEffectMap;

	private:
		Mix::IEngine* m_pEngine;
		Mix::File::IManager* m_pFileManager;
		Mix::Graphics::IDevice* m_pGraphicsDevice;
		Mix::Scene::Common::ActorLoader* m_pActorLoader;
		Mix::Scene::Common::TerrainLoader* m_pTerrainLoader;

		UInt32 m_MEPProcessFlags;
		Factory::VertexEffectMap m_ResidentVEMap;
		Factory::PixelEffectMap m_ResidentPEMap;
		Factory::VertexEffectMap m_MaterialVEMap;
		Factory::PixelEffectMap m_MaterialPEMap;

	protected:
		Factory( void );
		virtual ~Factory( void );

		Mix::IEngine* GetEnginePtr( void ) const;

		virtual void GetShaderBinary( Factory::SHADER_TYPES type, Factory::SHADER_BINARY& out ) = 0;

		virtual Mix::Scene::IRenderer* CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, const wchar_t* pName ) = 0;

		virtual Mix::Scene::IMaterial* CreateDefaultMaterial(	const wchar_t* pNameLabel,
																const wchar_t* pName,
																Boolean bWithMagicNumber,
																Mix::File::IReader* pReader,
																Mix::Scene::Common::Factory* pFactory,
																Mix::Graphics::IDevice* pDevice ) = 0;

	public:
		virtual Boolean Initialize( Mix::Scene::Common::Manager* pSceneManager, Mix::File::IReader* pReader, UInt32 mepProcFlags, UInt32 mepVSNum, UInt32 mepPSNum, const wchar_t* pFilePath );

		static Boolean MEP_LoadHeader( Mix::File::IReader* pReader, Factory::MEP_FILE_HEADER& fileHeader, Factory::MEP_DATA_HEADER& dataHeader, const wchar_t* pFilePath );
		UInt32 MEP_GetProcessFlags( void ) const;

		Factory::VERTEX_EFFECT* GetVertexEffectPtr( Factory::EFFECT_TYPE type, UInt32 opt = 0 );
		Factory::PIXEL_EFFECT* GetPixelEffectPtr( Factory::EFFECT_TYPE type, UInt32 opt = 0 );

		UInt32 ModifyRendererCaps( UInt32 caps ) const;

		Mix::Scene::IMaterial* CreateMaterialWithoutMagicNumber( const wchar_t* pName, Mix::File::IReader* pReader );

	public:
		virtual Boolean CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, Mix::Scene::IRenderer** ppRenderer, const wchar_t* pName );

		virtual Boolean CreateMaterialFromFile( const wchar_t* pFilePath, Mix::Scene::IMaterial** ppMaterial );
		virtual Boolean CreateMaterialFromMemory( const wchar_t* pFilePath, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IMaterial** ppMaterial );

		virtual Boolean CreateMotionFromFile( const wchar_t* pFilePath, Mix::Scene::IMotion** ppMotion );
		virtual Boolean CreateMotionFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IMotion** ppMotion );

		virtual Boolean CreateDefaultParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IDefaultParticleSystem::PLANE_TYPE planeType, Mix::Scene::IDefaultParticleSystem** ppSystem, const wchar_t* pDebugName );
		virtual Boolean CreateBillboardParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IBillboardParticleSystem** ppSystem, const wchar_t* pDebugName );

		virtual Boolean CreateLeavingParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::ILeavingParticle** ppParticle, const wchar_t* pDebugName = NULL );
		virtual Boolean CreateScatterParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::IScatterParticle** ppParticle, const wchar_t* pDebugName = NULL );

		virtual Boolean CreateActorModelFromFile( const wchar_t* pFilePath, Mix::Scene::IActorModel** ppModel );
		virtual Boolean CreateActorModelFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IActorModel** ppModel );

		virtual Boolean CreateTerrainModelFromFile( const wchar_t* pFilePath, Mix::Scene::ITerrainModel** ppModel );
		virtual Boolean CreateTerrainModelFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::ITerrainModel** ppModel );

	public:
		static const wchar_t* FAILED_CREATE;
		static const wchar_t* FAILED_CREATE_MEP_IO_ERROR;

		static const wchar_t* MEP_FILEEXT_TABLE[Mix::Graphics::SHADER_MODEL_MAX];
		static const wchar_t* MEP_RENDERER_TYPE_TABLE[Factory::MEP_RT_MAX];
	};

}}}
