#pragma once

#include "Mix/Scene/IDirectionalLight.h"

namespace Mix{ namespace Scene{ namespace Common{

	class DirectionalLight : public Mix::Scene::IDirectionalLight
	{
	private:
		Mix::Vector3 m_Dir;
		Mix::Vector4 m_Color;
		Boolean m_bEnabled;
		Boolean m_bDisposed;

#ifdef _DEBUG
		Float32 m_DebDrawLength;
#endif //_DEBUG

	public:
		static DirectionalLight* CreateInstance( void );

	private:
		DirectionalLight( void );
		virtual ~DirectionalLight( void );

	public:
		void Dispose( void );

#ifdef _DEBUG
		void Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, UInt32 flags );
#endif //_DEBUG

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Mix::Scene::IDirectionalLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetDirection( void ) const;
		virtual void SetDirection( const Mix::Vector3& dir );

		virtual const Mix::Vector4& GetColor( void ) const;
		virtual void SetColor( const Mix::Vector4& color );

		virtual Float32 Debug_GetDrawLength( void ) const;
		virtual void Debug_SetDrawLength( Float32 len );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Mix::Scene::ILight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
	};

}}}
