#include "Mix/Class/Scene/Common/DirectionalLight.h"

#ifdef _DEBUG
	#include "Mix/Graphics/Utility/ILineArt.h"
	#include "Mix/Class/Scene/Common/Debug.h"
#endif //_DEBUG

namespace Mix{ namespace Scene{ namespace Common{
		
DirectionalLight* DirectionalLight::CreateInstance( void )
{
	return new DirectionalLight();
}

DirectionalLight::DirectionalLight( void ) : 
m_Dir( 0.0f, -1.0f, 0.0f ),
m_Color( 1.0f, 1.0f, 1.0f, 1.0f ),
m_bEnabled( True ),
m_bDisposed( False )
{
#ifdef _DEBUG
	m_DebDrawLength = 1000.0f;
#endif //_DEBUG
}

DirectionalLight::~DirectionalLight( void )
{
}

void DirectionalLight::Dispose( void )
{
	m_bDisposed = True;
}

#ifdef _DEBUG

void DirectionalLight::Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, UInt32 flags )
{
	Mix::Matrix4x4 oldMat = pLineArt->GetMatrix();
	Mix::Vector4 oldColor = pLineArt->GetColor();

	if( MIX_TESTBIT( flags, Mix::Scene::DDF_DIRLIGHT_SHAPE ) == Mix::Scene::DDF_DIRLIGHT_SHAPE )
	{
		Mix::Vector3 pos = m_Dir * -m_DebDrawLength;

		pLineArt->SetMatrix( Mix::Matrix4x4::Identity() );
		pLineArt->SetColor( Mix::Scene::Common::Debug::GetDrawColor( Mix::Scene::DDC_LIGHT_SHAPE ) );
		pLineArt->AddLine( Mix::Vector3::Zero(), pos );
	}

	pLineArt->SetColor( oldColor );
	pLineArt->SetMatrix( oldMat );
}

#endif //_DEBUG

const Mix::Vector3& DirectionalLight::GetDirection( void ) const
{
	return m_Dir;
}

void DirectionalLight::SetDirection( const Mix::Vector3& dir )
{
	m_Dir = dir;
}

const Mix::Vector4& DirectionalLight::GetColor( void ) const
{
	return m_Color;
}

void DirectionalLight::SetColor( const Mix::Vector4& color )
{
	m_Color = color.ToSaturate();
}

Float32 DirectionalLight::Debug_GetDrawLength( void ) const
{
#ifdef _DEBUG
	return m_DebDrawLength;
#else //_DEBUG
	return 0.0f;
#endif //_DEBUG
}
void DirectionalLight::Debug_SetDrawLength( Float32 len )
{
#ifdef _DEBUG
	m_DebDrawLength = max( 0.0f, len );
#endif //_DEBUG
}

Boolean DirectionalLight::IsEnabled( void ) const
{
	return m_bEnabled;
}

void DirectionalLight::SetEnabled( Boolean state )
{
	m_bEnabled = state;
}

Boolean DirectionalLight::IsDisposed( void ) const
{
	return m_bDisposed;
}

Mix::Scene::IRendererObject::TYPE DirectionalLight::GetType( void ) const
{
	return Mix::Scene::IRendererObject::DIRECTIONAL_LIGHT;
}

}}}
