#pragma once

#include <vector>

#include "Mix/Geometry/Frustum.h"
#include "Mix/Scene/ICamera.h"
#include "Mix/Class/Scene/Common/RendererTypes.h"

namespace Mix{ namespace Scene{ namespace Common{

	class OctreeView;
	class Renderer;

	class Camera
	{
	public:
		enum PUBLIC_VALUE
		{
			LFT_MAX = 3, // YtA𑕏eNX`̐
			FI_MAX	= 3, // tB~bN̍ő吔( NONE ܂ )
		};

		struct INTERNAL_AMBIENT_OCCLUSION_SETTINGS
		{
			Float32 radius;
			Float32 threshold;
			Float32 depth;
		};

		struct INTERNAL_SHADOW_MAPPING_SETTINGS
		{
			Float32 depthBias;
			Float32 fadeOutStart;
			Float32 invFadeOutDist;
		};

		enum LUMINOSITY_ADAPTATION_TYPE
		{
			LUM_AD_SPECIFY	= 0,
			LUM_AD_FORCE	= 1,
			LUM_AD_SLOWLY	= 2,
		};

		struct INTERNAL_LIGHT_SHAFTS_SETTINGS
		{
			Float32 start;
			Float32 end;
			Float32 invDist;
		};

		struct INTERNAL_LENS_FLARE_SETTINGS
		{
			Mix::Vector3 distoVec;
			Mix::Matrix4x4 camMat;
		};

		struct INTERNAL_CHROMATISM_SETTINGS
		{
			Float32 fiStartZ;
			Float32 invDist;
		};

		struct INTERNAL_DOF_SETTINGS
		{
			float nearZ;
			float farZ;
			float invNearDist;
			float invFarDist;
			float invBlurThresholdN;
			float invBlurThresholdF;
		};

		struct INTERNAL_VIGNETTE_SETTINGS
		{
			Float32 start;
			Float32 invDist;
		};

	private:
		enum PRIVATE_VALUE
		{
			FI_SETTINGS_BUFF_SIZE = 32, //tB~bÑp[^i[obt@̃TCY
		};

	private:
		Mix::Scene::Common::Renderer* m_pRenderer;
		Mix::Scene::Common::OctreeView* m_pOctView;

		Boolean m_bAvailabled;

		Mix::Scene::CAMERA_CONFIG m_Config;
		UInt32 m_ModConfigCaps;

		Mix::Vector4 m_BGColor;

		Mix::Graphics::TEXTURE_FILTER_TYPE m_FilterType;

		Float32 m_FovY;
		Float32 m_Aspect;
		Float32 m_NearZ;
		Float32 m_FarZ;
		Mix::Matrix4x4 m_ProjMat;

		Mix::Geometry::Frustum m_Frustum;

		Mix::Vector3 m_ViewVec;
		Mix::Vector3 m_ViewForward;
		Mix::Vector3 m_ViewUpward;
		Mix::Vector3 m_ViewCrossDir;
		Mix::Matrix4x4 m_InvViewProjMat;
		Mix::Matrix4x4 m_BillboardMat;
		Mix::Matrix4x4 m_BillboardMatY;

		Mix::Scene::ICamera::LOCAL_LIGHT_SETTINGS m_LocalLightSettings;
		Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS m_ParticleSettings;
		Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS m_ActorModelSettings;
		Mix::Scene::ICamera::PLANTER_SETTINGS m_PlanterSettings;

		Boolean m_bAOEnabled;
		Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS m_AOSettings;
		Camera::INTERNAL_AMBIENT_OCCLUSION_SETTINGS m_InternalAOSettings;

		Boolean m_bSMEnabled;
		Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS m_SMSettings;
		Camera::INTERNAL_SHADOW_MAPPING_SETTINGS m_InternalSMSettings;

		Mix::Scene::ICamera::LUMINOSITY_SETTINGS m_LumSettings;
		UInt32 m_LumAdSuspendCount;
		Camera::LUMINOSITY_ADAPTATION_TYPE m_LumAdType;
		Float32 m_LumAdValue;

		Boolean m_bBloomEnabled;
		UInt32 m_BloomOverflowNum;
		std::vector<Mix::Scene::ICamera::BLOOM_OVERFLOW> m_BloomOverflows;
		Mix::Scene::ICamera::BLOOM_SETTINGS m_BloomSettings;

		Boolean m_bLightShaftsEnabled;
		Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS m_LightShaftsSettings;
		Camera::INTERNAL_LIGHT_SHAFTS_SETTINGS m_InternalLightShaftsSettings;

		Boolean m_bLensFlareEnabled;
		Mix::Scene::ICamera::LENS_FLARE_SETTINGS m_LensFlareSettings;
		Camera::INTERNAL_LENS_FLARE_SETTINGS m_InternalLensFlareSettings;
		Mix::Graphics::ITexture* m_pLensFlareTex[Camera::LFT_MAX];

		Mix::Scene::ICamera::FILMIC_TYPE m_FilmicType;
		UInt8 m_FilmicSettingsBuff[Camera::FI_SETTINGS_BUFF_SIZE];
		UInt32 m_FilmicSettingsSize;

		Boolean m_bGammaEnabled;
		Mix::Vector3 m_GammaValue;
		Mix::Vector3 m_InternalGammaValue;

		Boolean m_bChromatismEnabled;
		Mix::Scene::ICamera::CHROMATISM_SETTINGS m_ChromatismSettings;
		Camera::INTERNAL_CHROMATISM_SETTINGS m_InternalChromatismSettings;

		Boolean m_bDofEnabled;
		Mix::Scene::ICamera::DOF_SETTINGS m_DofSettings;
		Camera::INTERNAL_DOF_SETTINGS m_InternalDofSettings;

		Boolean m_bLensDistEnabled;
		Mix::Scene::ICamera::DISTORTION_SETTINGS m_LensDistSettings;

		Boolean m_bVignetteEnabled;
		Mix::Scene::ICamera::VIGNETTE_SETTINGS m_VignetteSettings;
		Camera::INTERNAL_VIGNETTE_SETTINGS m_InternalVignetteSettings;

		Mix::Scene::ICamera::ANTIALIASING_TYPE m_AAType;

		Boolean m_bUnderWater;

#ifdef _DEBUG
		Mix::String m_DebugName;
		Mix::Graphics::FILL_TYPE m_DebFillType;
		Mix::Scene::DEBUG_DRAW_METHOD m_DebDrawMethod;
		UInt32 m_DebDrawFlags;
		Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS m_DebDrawFilmicSettings;
#endif //_DEBUG

	protected:
		Mix::Vector3 m_Eye;
		Mix::Vector3 m_At;
		Mix::Matrix4x4 m_ViewMat;

	public:
		Camera( Mix::Scene::Common::Renderer* pRenderer, Mix::Scene::Common::OctreeView* pOctView );
		virtual ~Camera( void );

		Boolean Initialize( const Mix::Scene::CAMERA_CONFIG& config );

		UInt32 GetID( void ) const;

		Boolean IsAvailabled( void ) const;

		const Mix::Scene::CAMERA_CONFIG& GetConfig( void ) const;
		Boolean SetConfig( const Mix::Scene::CAMERA_CONFIG& config );
		void UpdateConfig( void );

		const Mix::Vector4& GetBackgroundColor( void ) const;
		void SetBackgroundColor( const Mix::Vector4& color );

		Mix::Graphics::TEXTURE_FILTER_TYPE GetFilterType( void ) const;
		void SetFilterType( Mix::Graphics::TEXTURE_FILTER_TYPE type );

		const Mix::Matrix4x4& GetProjectionMatrix( void ) const;
		void SetProjection( Float32 fovY, Float32 nearZ, Float32 farZ );
		void SetProjection( Float32 fovY, Float32 aspect, Float32 nearZ, Float32 farZ );
		void SetProjection( Float32 fovY, UInt32 width, UInt32 height, Float32 nearZ, Float32 farZ );
		Float32 GetFovY( void ) const;
		Float32 GetAspect( void ) const;
		Float32 GetNearZ( void ) const;
		Float32 GetFarZ( void ) const;

		const Mix::Vector3& GetEye( void ) const;
		const Mix::Vector3& GetAt( void ) const;
		const Mix::Vector3& GetViewVector( void ) const;
		const Mix::Vector3& GetViewForward( void ) const;
		const Mix::Vector3& GetViewUpward( void ) const;
		const Mix::Vector3& GetViewCrossDirection( void ) const;
		const Mix::Matrix4x4& GetViewMatrix( void ) const;

		const Mix::Geometry::Frustum& GetFrustum( void ) const;

		const Mix::Matrix4x4& GetViewProjectionMatrix( void ) const;
		const Mix::Matrix4x4& GetInvViewProjectionMatrix( void ) const;

		const Mix::Matrix4x4& GetBillboardMatrix( void ) const;
		const Mix::Matrix4x4& GetBillboardMatrixY( void ) const;

		Mix::Point Project( const Mix::Vector3& pos ) const;
		Mix::Point Project( const Mix::Point& screenPos, const Mix::Vector3& pos ) const;
		Mix::Point Project( const Mix::Rectangle& screenRect, const Mix::Vector3& pos ) const;

		Mix::Vector3 Unproject( const Mix::Point& pos, Float32 z ) const;
		Mix::Vector3 Unproject( const Mix::Point& screenPos, const Mix::Point& pos, Float32 z ) const;
		Mix::Vector3 Unproject( const Mix::Rectangle& screenRect, const Mix::Point& pos, Float32 z ) const;

		Boolean DragObject( const Mix::Point& pos );
		Boolean DragObject( const Mix::Point& screenPos, const Mix::Point& pos );
		Boolean DragObject( const Mix::Rectangle& screenRect, const Mix::Point& pos );

		Boolean IsUnderWater( void ) const;
		void SetUnderWater( Boolean state );

		void Update( void );
		Boolean Draw( void );

		Boolean IsDisposed( void ) const;
		void Dispose( void );

		const Mix::Scene::ICamera::LOCAL_LIGHT_SETTINGS& GetLocalLightSettings( void ) const;
		void SetLocalLightSettings( const Mix::Scene::ICamera::LOCAL_LIGHT_SETTINGS& settings );

		const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& GetParticleSettings( void ) const;
		void SetParticleSettings( const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& settings );

		const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& GetActorModelSettings( void ) const;
		void SetActorModelSettings( const Mix::Scene::ICamera::DRAW_OBJECT_SETTINGS& settings );

		const Mix::Scene::ICamera::PLANTER_SETTINGS& GetPlanterSettings( void ) const;
		void SetPlanterSettings( const Mix::Scene::ICamera::PLANTER_SETTINGS& settings );

		Boolean IsAmbientOcclusionAvailabled( void ) const;
		Boolean IsAmbientOcclusionEnabled( void ) const;
		void SetAmbientOcclusionEnabled( Boolean state );
		const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& GetAmbientOcclusionSettings( void ) const;
		const Camera::INTERNAL_AMBIENT_OCCLUSION_SETTINGS& GetInternalAmbientOcclusionSettings( void ) const;
		void SetAmbientOcclusionSettings( const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& settings );

		Boolean IsShadowMappingAvailabled( void ) const;
		Boolean IsShadowMappingEnabled( void ) const;
		void SetShadowMappingEnabled( Boolean state );
		const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& GetShadowMappingSettings( void ) const;
		const Camera::INTERNAL_SHADOW_MAPPING_SETTINGS& GetInternalShadowMappingSettings( void ) const;
		void SetShadowMappingSettings( const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& settings );

		Boolean IsLuminosityAvailabled( void ) const;
		const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& GetLuminositySettings( void ) const;
		void SetLuminositySettings( const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& settings );
		Boolean IsLuminosityAdaptationEnabled( void ) const;
		Camera::LUMINOSITY_ADAPTATION_TYPE GetLuminosityAdaptationType( void );
		Float32 GetLuminosityAdaptationValue( void ) const;
		UInt32 ResumeLuminosityAdaptation( void );
		UInt32 SusupendLuminosityAdaptation( void );
		UInt32 GetLuminosityAdaptationSuspendCount( void ) const;
		void ForceLuminosityAdaptation( void );
		void SetLuminosityAdaptation( Float32 lum );

		Boolean IsBloomAvailabled( void ) const;
		Boolean IsBloomEnabled( void ) const;
		void SetBloomEnabled( Boolean state );
		UInt32 GetBloomOverflowNum( void ) const;
		const Mix::Scene::ICamera::BLOOM_OVERFLOW& GetBloomOverflow( UInt32 index ) const;
		void SetBloomOverflow( UInt32 index, const Mix::Scene::ICamera::BLOOM_OVERFLOW& overflow );
		void ResizeBloomOverflows( UInt32 num );
		const Mix::Scene::ICamera::BLOOM_SETTINGS& GetBloomSettings( void ) const;
		void SetBloomSettings( const Mix::Scene::ICamera::BLOOM_SETTINGS& settings );

		Boolean IsLightShaftsAvailabled( void ) const;
		Boolean IsLightShaftsEnabled( void ) const;
		void SetLightShaftsEnabled( Boolean state );
		const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& GetLightShaftsSettings( void ) const;
		void SetLightShaftsSettings( const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& settings );
		const Camera::INTERNAL_LIGHT_SHAFTS_SETTINGS& GetInternalLightShaftsSettings( void ) const;

		Boolean IsLensFlareAvailabled( void ) const;
		Boolean IsLensFlareEnabled( void ) const;
		void SetLensFlareEnabled( Boolean state );
		const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& GetLensFlareSettings( void ) const;
		const Camera::INTERNAL_LENS_FLARE_SETTINGS& GetInternalLensFlareSettings( void ) const;
		void SetLensFlareSettings( const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& settings );
		Boolean GetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture** ppTexture );
		Mix::Graphics::ITexture* GetLensFlareTexturePtr( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type ) const;
		void SetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture* pTexture );

		Mix::Scene::ICamera::FILMIC_TYPE GetFilmicType( void ) const;
		Boolean GetFilmicSettings( void* pSettings, UInt32 size ) const;
		const void* GetFilmicSettingsBuff( UInt32 settingsSize ) const;
		Boolean SetFilmicType( Mix::Scene::ICamera::FILMIC_TYPE type, const void* pSettings, UInt32 size );

		Boolean IsGammaEnabled( void ) const;
		void SetGammaEnabled( Boolean state );
		const Mix::Vector3& GetGammaValue( void ) const;
		const Mix::Vector3& GetInternalGammaValue( void ) const;
		void SetGammaValue( const Mix::Vector3& value );
		void SetGammaValue( Float32 value );

		Boolean IsChromatismAvailabled( void ) const;
		Boolean IsChromatismEnabled( void ) const;
		void SetChromatismEnabled( Boolean state );
		const Mix::Scene::ICamera::CHROMATISM_SETTINGS& GetChromatismSettings( void ) const;
		const Camera::INTERNAL_CHROMATISM_SETTINGS& GetInternalChromatismSettings( void ) const;
		void SetChromatismSettings( const Mix::Scene::ICamera::CHROMATISM_SETTINGS& settings );

		Boolean IsDofAvailabled( void ) const;
		Boolean IsDofEnabled( void ) const;
		void SetDofEnabled( Boolean state );
		const Mix::Scene::ICamera::DOF_SETTINGS& GetDofSettings( void ) const;
		const Camera::INTERNAL_DOF_SETTINGS& GetInternalDofSettings( void ) const;
		void SetDofSettings( const Mix::Scene::ICamera::DOF_SETTINGS& settings );

		Boolean IsLensDistortionEnabled( void ) const;
		void SetLensDistortionEnabled( Boolean state );
		const Mix::Scene::ICamera::DISTORTION_SETTINGS& GetLendDistortionSettings( void ) const;
		void SetLendDistortionSettings( const Mix::Scene::ICamera::DISTORTION_SETTINGS& settings );

		Boolean IsVignetteEnabled( void ) const;
		void SetVignetteEnabled( Boolean state );
		const Mix::Scene::ICamera::VIGNETTE_SETTINGS& GetVignetteSettings( void ) const;
		const Camera::INTERNAL_VIGNETTE_SETTINGS& GetInternalVignetteSettings( void ) const;
		void SetVignetteSettings( const Mix::Scene::ICamera::VIGNETTE_SETTINGS& settings );

		Mix::Scene::ICamera::ANTIALIASING_TYPE GetAntiAliasingType( void ) const;
		void SetAntiAliasingType( Mix::Scene::ICamera::ANTIALIASING_TYPE type );

		void Debug_SetFillType( Mix::Graphics::FILL_TYPE type );
		Mix::Graphics::FILL_TYPE Debug_GetFillType( void ) const;

		void Debug_SetDrawMethod( Mix::Scene::DEBUG_DRAW_METHOD method );
		Mix::Scene::DEBUG_DRAW_METHOD Debug_GetDrawMethod( void ) const;

		void Debug_SetDrawFlags( UInt32 flags );
		UInt32 Debug_GetDrawFlags( void ) const;

		const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& Debug_GetDrawFilmicSettings( void ) const;
		void Debug_SetDrawFilmicSettings( const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& settings );

		UInt32 Debug_GetProfile( UInt32 type, void* pProf, UInt32 size ) const;

		UInt32 Debug_GetImageNum( UInt32 type ) const;
		Boolean Debug_GetImage( UInt32 type, UInt32 index, Mix::Graphics::ITexture** ppTexture );

#ifdef _DEBUG
		const wchar_t* Debug_GetName( void ) const;
		void Debug_SetName( const wchar_t* pName );
#endif //_DEBUG

	private:
		static const Float32 CA_MIN_DIST;

		static const UInt32 LF_MIN_GHOST;
		static const UInt32 LF_MAX_GHOST;
		static const Mix::Matrix4x4 LF_CAM_BIAS_MAT0;
		static const Mix::Matrix4x4 LF_CAM_BIAS_MAT1;

		static const Float32 VIGNETTE_LEN;
	};

}}}
