#pragma once

#include "Mix/Scene/IAtmosphereScatter.h"

namespace Mix{ namespace Scene{ namespace Common{

	class AtmosphereScatter : public Mix::Scene::IAtmosphereScatter
	{
	public:
		struct INTERNAL_SETTINGS
		{
			Mix::Vector4 sunColor;
			Mix::Vector4 nightColor;

			Mix::Vector3 hg;

			Mix::Vector4 betaDashR;
			Mix::Vector4 betaDashM;
			Mix::Vector4 betaRM;
			Mix::Vector4 oneOverBetaRM;

			Mix::Vector4 mulitpliers;
		};

	public:
		static AtmosphereScatter* CreateInstance( void );

	private:
		Float32 m_OuterRadius;
		Float32 m_InnerRadius;

		Mix::Vector3 m_BetaR;
		Mix::Vector3 m_BetaDashR;
		Mix::Vector3 m_BetaM;
		Mix::Vector3 m_BetaDashM;

		Mix::Scene::IAtmosphereScatter::DAY_SETTINGS m_DaySettings;
		Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS m_NightSettings;
		Float32 m_InvNPOffset;

		Mix::Vector3 m_SunPos;
		Mix::Vector3 m_SunDir;
		Mix::Vector3 m_SunColor;
		Mix::Vector4 m_SunLightColor;

		Mix::Vector4 m_NightColor;

		Boolean m_bDisposed;

	private:
		AtmosphereScatter( void );
		virtual ~AtmosphereScatter( void );

		void UpdateSun( void );
		void UpdateSunColor( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::AtmosphereScatter
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void UpdateHemisphere( Float32 radius, Float32 height, Float32 outerRadius, Float32 innerRadius );
		void UpdateSunPosition( const Mix::Vector3& pos );

		const Mix::Vector3& GetSunDir( void ) const;
		AtmosphereScatter::INTERNAL_SETTINGS GetInternalSettings( void ) const;

		// RGB=NIGHT_SETTINGS::cloudColor.rgb *NIGHT_SETTINGS::cloudColor.a
		// A=Nightness( 0.0f`1.0f )
		const Mix::Vector4& GetInternalNightColor( void ) const;

		void Dispose( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IAtmosphereScatter
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Scene::IAtmosphereScatter::DAY_SETTINGS& GetDaySettings( void ) const;
		virtual void SetDaySettings( const Mix::Scene::IAtmosphereScatter::DAY_SETTINGS& param );

		virtual const Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS& GetNightSettings( void ) const;
		virtual void SetNightSettings( const Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS& param );

		virtual const Mix::Vector3& GetSunColor( void ) const;
		virtual const Mix::Vector4& GetSunLightColor( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererResource
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsDisposed( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;

	private:
		static const Mix::Vector3 Y_AXIS;
		static const Mix::Vector3 BLACK;

	public:
		static const Float32 DEF_SD_RADIUS;
		static const Float32 DEF_SD_HEIGHT;
	};

}}}
