#pragma once

namespace Mix{ namespace Scene{ namespace Common{

	class ActorRevision
	{
	public:
		enum TYPE
		{
			CTRL_WORLD_MAT	= 0,
			WORLD_MAT		= 1,

			LOCAL_MAT		= 2,

			TYPE_MAX		= 4,	//32؂lɂ邱
		};

	private:
		UInt32* m_pFlags;
		UInt32* m_pCounter;
		UInt32 m_Mask;
		UInt32 m_Clear;
		UInt32 m_Table[ActorRevision::TYPE_MAX];

	private:
		ActorRevision( UInt32* pFlags, UInt32* pCounter, UInt32 mask, UInt32 clear, const UInt32* table );
		~ActorRevision( void );

	public:
		Boolean IsControlWorldTransform( void ) const;
		Boolean SetControlWorldTransform( void );
		Boolean IsWorldTransform( void ) const;
		void SetWorldTransform( void );

		Boolean IsLocalTransform( void ) const;
		Boolean SetLocalTransform( void );

		void Clear( void );

		friend class ActorModel;
	};

}}}
