#include "Mix/Class/Scene/Common/ActorConstraint.h"

namespace Mix{ namespace Scene{ namespace Common{

ActorConstraint* ActorConstraint::CreateInstance( const wchar_t* pName )
{
	return new ActorConstraint( pName );
}

ActorConstraint::ActorConstraint( const wchar_t* pName ) :
m_Name( pName )
{
}

ActorConstraint::~ActorConstraint( void )
{
}

const wchar_t* ActorConstraint::GetName( void ) const
{
	return m_Name.GetConstPtr();
}

void ActorConstraint::SetLocalMatrix( const Mix::Matrix4x4& mat )
{
	m_LocalMat = mat;
}

const Mix::Matrix4x4& ActorConstraint::GetLocalMatrix( void ) const
{
	return m_LocalMat;
}

const Mix::Matrix4x4& ActorConstraint::GetWorldMatrix( void ) const
{
	return m_WorldMat;
}

void ActorConstraint::Update( const Mix::Matrix4x4& mat )
{
	m_WorldMat = m_LocalMat * mat;
}

}}}
