#include "Mix/RectangleF.h"

using namespace Mix;

RectangleF::RectangleF( void ) :
x( 0.0f ),
y( 0.0f ),
width( 0.0f ),
height( 0.0f )
{
}

RectangleF::RectangleF( Float32 rx, Float32 ry, Float32 rw, Float32 rh ) :
x( rx ),
y( ry ),
width( rw ),
height( rh )
{
}

RectangleF::RectangleF( const Mix::RectangleF& rect ) :
x( rect.x ),
y( rect.y ),
width( rect.width ),
height( rect.height )
{
}

RectangleF::RectangleF( const Mix::Rectangle& rect ) :
x( static_cast<Float32>( rect.x ) ),
y( static_cast<Float32>( rect.y ) ),
width( static_cast<Float32>( rect.width ) ),
height( static_cast<Float32>( rect.height ) )
{
}

Boolean RectangleF::operator == ( const RectangleF& rect ) const
{
	if( ( MIX_FLOAT_EQUAL( x, rect.x ) == False ) ||
		( MIX_FLOAT_EQUAL( y, rect.y ) == False ) ||
		( MIX_FLOAT_EQUAL( width, rect.width ) == False ) ||
		( MIX_FLOAT_EQUAL( height, rect.height ) == False ) )
	{
		return False;
	}

	return True;
}

Boolean RectangleF::operator != ( const RectangleF& rect ) const
{
	if( ( MIX_FLOAT_EQUAL( x, rect.x ) == False ) ||
		( MIX_FLOAT_EQUAL( y, rect.y ) == False ) ||
		( MIX_FLOAT_EQUAL( width, rect.width ) == False ) ||
		( MIX_FLOAT_EQUAL( height, rect.height ) == False ) )
	{
		return True;
	}

	return False;
}

Mix::RectangleF& RectangleF::operator = ( const Mix::RectangleF& rect )
{
	x = rect.x;
	y = rect.y;
	width = rect.width;
	height = rect.height;

	return *this;
}

Mix::RectangleF& RectangleF::operator = ( const Mix::Rectangle& rect )
{
	x = static_cast<Float32>( rect.x );
	y = static_cast<Float32>( rect.y );
	width = static_cast<Float32>( rect.width );
	height = static_cast<Float32>( rect.height );

	return *this;
}

Boolean RectangleF::Contains( const Mix::Vector2& p ) const
{
	if( ( x > p.x ) ||
		( y > p.y ) ||
		( GetRight() < p.x ) ||
		( GetBottom() < p.y ) )
	{
		return False;
	}

	return True;
}

Boolean RectangleF::Contains( const Mix::RectangleF& rect, Mix::RectangleF* pOverlapRect ) const
{
	if( ( x > rect.GetRight() ) ||
		( y > rect.GetBottom() ) ||
		( GetRight() < rect.x ) ||
		( GetBottom() < rect.y ) )
	{
		return False;
	}

	if( pOverlapRect != NULL )
	{
		pOverlapRect->x = max( x, rect.x );
		pOverlapRect->y = max( y, rect.y );
		pOverlapRect->SetRight( min( GetRight(), rect.GetRight() ) );
		pOverlapRect->SetBottom( min( GetBottom(), rect.GetBottom() ) );
	}

	return True;
}

void RectangleF::SetRight( Float32 right )
{
	width = right - x + 1.0f;
}

Float32 RectangleF::GetRight( void ) const
{
	return x + width - 1.0f;
}

void RectangleF::SetBottom( Float32 bottom )
{
	height = bottom - y + 1.0f;
}

Float32 RectangleF::GetBottom( void ) const
{
	return y + height - 1.0f;
}
