#pragma once

namespace Mix{

	class Processor
	{
	private:
		LARGE_INTEGER m_Freq;
		Float64 m_InvFreqF64;
		LARGE_INTEGER m_PeriodCount;

		LARGE_INTEGER m_BeforeUpdateCount;
		LARGE_INTEGER m_ErrorSleepCount;
		Float32 m_SleepTimeCount;

		Int32 m_InsomniaFrameMax;
		Int32 m_InsomniaFrameCount;

		LARGE_INTEGER m_BeforeCount;
		Int32 m_FrameCount;
		Int32 m_BaseFPS;
		Float32 m_BaseET;
		Float32 m_FPS;
		Float32 m_ET;
		Float32 m_STPS;
		Int32 m_IFCPS;

	public:
		Processor( void );

	public:
		void Initialize( Int32 baseFPS, Int32 insomniaFrameMax );
		void Reset( void );
		void Update( void );

		Float32 GetSleepTimePerSec( void ) const;

		Int32 GetInsomniaFrameMax( void ) const;
		Int32 GetInsomniaFrameCountPerSec( void ) const;

		Int32 GetBaseFramesPerSec( void ) const;
		Float32 GetBaseElaspedTime( void ) const;

		Float32 GetFramesPerSec( void ) const;
		Float32 GetElaspedTime( void ) const;
	};
}
