#include "Mix/Class/Processor.h"

namespace Mix{

Processor::Processor( void )
{
	m_Freq.QuadPart = 0;
	m_InvFreqF64 = 0.0;
	m_PeriodCount.QuadPart = 0;
	m_BeforeCount.QuadPart = 0;
	m_BeforeUpdateCount.QuadPart = 0;
	m_ErrorSleepCount.QuadPart = 0;
	m_SleepTimeCount = 0.0f;
	m_InsomniaFrameMax = 16;
	m_InsomniaFrameCount = 0;
	m_FrameCount = 0;

	m_BaseFPS = 0;
	m_BaseET = 0.0f;
	m_FPS = 0.0f;
	m_ET = 0.0f;
	m_STPS = 0.0f;
	m_IFCPS = 0;
}

void Processor::Initialize( Int32 baseFPS, Int32 insomniaFrameMax )
{
	m_BaseFPS = max( 0, baseFPS );
	m_BaseET = MIX_FLOAT_RECIPROCAL( static_cast<Float32>( m_BaseFPS ) );
	m_InsomniaFrameMax = max( 0, insomniaFrameMax );

	Reset();
}

void Processor::Reset( void )
{
	::QueryPerformanceFrequency( &m_Freq );
	m_InvFreqF64 = ( m_Freq.QuadPart > 0l )? ( 1.0 / static_cast<Float64>( m_Freq.QuadPart ) ) : 0.0;
	m_PeriodCount.QuadPart = ( m_BaseFPS > 0 )? ( m_Freq.QuadPart / m_BaseFPS ) : 0;
	::QueryPerformanceCounter( &m_BeforeCount );
	m_BeforeUpdateCount.QuadPart = m_BeforeCount.QuadPart;
	m_ErrorSleepCount.QuadPart = 0;
	m_SleepTimeCount = 0.0f;
	m_InsomniaFrameCount = 0;
	m_FrameCount = 0;

	m_FPS = static_cast<Float32>( m_BaseFPS );
	m_ET = MIX_FLOAT_RECIPROCAL( m_FPS );
	m_STPS = 0.0f;
	m_IFCPS = 0;
}

void Processor::Update( void )
{
	LARGE_INTEGER currentCount;
	LARGE_INTEGER periodCount;

	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_BaseFPS > 0 )
	{
		LARGE_INTEGER afterUpdateCount;
		LARGE_INTEGER diffUpdateCount;

		::QueryPerformanceCounter( &afterUpdateCount );
		diffUpdateCount.QuadPart = ( afterUpdateCount.QuadPart - m_BeforeUpdateCount.QuadPart ) + m_ErrorSleepCount.QuadPart;

//		if( ( diffUpdateCount.QuadPart > 0 ) &&
//			( m_PeriodCount.QuadPart > diffUpdateCount.QuadPart ) )
//		{
		if( m_PeriodCount.QuadPart > diffUpdateCount.QuadPart )
		{
			LARGE_INTEGER sleepCount;
			UInt32 sleepTime;

			LARGE_INTEGER sleepBeginCount;
			LARGE_INTEGER sleepEndCount;
			LARGE_INTEGER sleepDiffCount;

			//X[vԂ߂
			sleepCount.QuadPart = m_PeriodCount.QuadPart - diffUpdateCount.QuadPart;
			sleepTime = static_cast<UInt32>( sleepCount.QuadPart * 1000 / m_Freq.QuadPart );

			//X[v
			::QueryPerformanceCounter( &sleepBeginCount );
			::Sleep( sleepTime );
			::QueryPerformanceCounter( &sleepEndCount );

			//ۂɃX[vԂ߂
			sleepDiffCount.QuadPart = sleepEndCount.QuadPart - sleepBeginCount.QuadPart;

			//X[vԂ̌덷
//			m_ErrorSleepCount.QuadPart = sleepCount.QuadPart - ( sleepEndCount.QuadPart - sleepBeginCount.QuadPart );
			m_ErrorSleepCount.QuadPart = sleepDiffCount.QuadPart - sleepCount.QuadPart;

			//X[vԂ̍v
//			m_SleepTimeCount += static_cast<Float32>( static_cast<Float64>( sleepDiffCount.QuadPart ) / static_cast<Float64>( m_Freq.QuadPart ) );
			m_SleepTimeCount += static_cast<Float32>( static_cast<Float64>( sleepDiffCount.QuadPart ) * m_InvFreqF64 );
		}
		else
		{
			if( m_InsomniaFrameCount >= m_InsomniaFrameMax )
			{
				LARGE_INTEGER sleepBeginCount;
				LARGE_INTEGER sleepEndCount;

				//ʃXbhɃ^CXCX
				::QueryPerformanceCounter( &sleepBeginCount );
				::Sleep( 0 );
				::QueryPerformanceCounter( &sleepEndCount );

				//X[vԂ̌덷͖
				m_ErrorSleepCount.QuadPart = 0;

				//X[vԂ̍v
//				m_SleepTimeCount += static_cast<Float32>( static_cast<Float64>( sleepEndCount.QuadPart - sleepBeginCount.QuadPart ) / static_cast<Float64>( m_Freq.QuadPart ) );
				m_SleepTimeCount += static_cast<Float32>( static_cast<Float64>( sleepEndCount.QuadPart - sleepBeginCount.QuadPart ) * m_InvFreqF64 );

				//X[vłȂt[̃JEgZbg
				m_InsomniaFrameCount = 0;
			}
			else
			{
				//X[vłȂt[̃JEg
				m_InsomniaFrameCount++;
			}
		}

		::QueryPerformanceCounter( &m_BeforeUpdateCount );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_FrameCount++;

	::QueryPerformanceCounter( &currentCount );
	periodCount.QuadPart = currentCount.QuadPart - m_BeforeCount.QuadPart;

	if( periodCount.QuadPart >= m_Freq.QuadPart )
	{
//		MIX_TRACELINE( L"Process : SleepTimeCount[%f] InsomniaCount[%d]", m_SleepTimeCount, m_InsomniaFrameCount );

		m_FPS = MIX_FLOAT_DIV( static_cast<Float32>( m_FrameCount ), static_cast<Float32>( currentCount.QuadPart - m_BeforeCount.QuadPart ) ) * m_Freq.QuadPart;
		m_ET = MIX_FLOAT_RECIPROCAL( m_FPS );
		m_STPS = m_SleepTimeCount;
		m_IFCPS = m_InsomniaFrameCount;

		::QueryPerformanceFrequency( &m_Freq );
		m_InvFreqF64 = ( m_Freq.QuadPart > 0l )? ( 1.0 / static_cast<Float64>( m_Freq.QuadPart ) ) : 0.0;
		m_PeriodCount.QuadPart = ( m_BaseFPS > 0 )? ( m_Freq.QuadPart / m_BaseFPS ) : 0;

		m_SleepTimeCount = 0.0f;
		m_InsomniaFrameCount = 0;
		m_FrameCount = 0;

		::QueryPerformanceCounter( &m_BeforeCount );
	}
}

Float32 Processor::GetSleepTimePerSec( void ) const
{
	return m_STPS;
}

Int32 Processor::GetInsomniaFrameMax( void ) const
{
	return m_InsomniaFrameMax;
}

Int32 Processor::GetInsomniaFrameCountPerSec( void ) const
{
	return m_IFCPS;
}

Int32 Processor::GetBaseFramesPerSec( void ) const
{
	return m_BaseFPS;
}

Float32 Processor::GetBaseElaspedTime( void ) const
{
	return m_BaseET;
}

Float32 Processor::GetFramesPerSec( void ) const
{
	return m_FPS;
}

Float32 Processor::GetElaspedTime( void ) const
{
	return m_ET;
}

}
