#pragma once

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ̒`
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _WIN32_WINNT
	//! @def _WIN32_WINNT
	//! @brief Windows̃o[W
	#define _WIN32_WINNT 0x0501	//WindowsXP SP2ȍ~
#endif //_WIN32_WINNT

#ifndef _WIN32_IE
	//! @def _WIN32_IE
	//! @brief IẼo[W
	#define _WIN32_IE 0x560		//IE5.6ȍ~
#endif //_WIN32_IE

#ifndef STRICT
	//! @def STRICT
	//! @brief XgNg
	#define STRICT
#endif //STRICT

#ifndef DIRECTINPUT_VERSION
	//! @def DIRECTINPUT_VERSION
	//! @brief DirectInput̃o[W
	#define DIRECTINPUT_VERSION 0x800
#endif

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CN[h
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <winsock2.h>
#include <winuser.h>
#include <typeinfo>
#include <memory>
#include <algorithm>
#include <time.h>
#include <math.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <msacm.h>
#include <process.h>
#include <shlobj.h>
#include <Imm.h>
#include <vector>

#include <ddraw.h>
#include <d3d9.h>
#include <d3dx9effect.h>

#include <d3d11.h>
#include <dxgi.h>
#include <d3dx11async.h>

#include <InitGuid.h>
#include <dinput.h>
#include <XInput.h>
#include <Xaudio2.h>
#include <X3daudio.h>
#include "Mix/Standard.h"
#include "Mix/Class/Logger.h"

#include "btBulletDynamicsCommon.h"
#include "BulletWorldImporter/btBulletWorldImporter.h"
#include "BulletCollision/CollisionDispatch/btGhostObject.h"
#include "BulletDynamics/Character/btKinematicCharacterController.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// `
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix
{
	class Engine;
	class Window;

	//G[
	enum ERR
	{
		ERR_GRAPHICS_DRIVERERROR	= 0,	//OtBbNX : OtBbNXhCoŃG[( I )
		ERR_GRAPHICS_CHANGEMODE		= 1,	//OtBbNX : [h̕ύXɎs( I )
	};

	//\EBhEbZ[W
	enum WINDOWMESSAGE
	{
		WM_MIX_INTERNALERROR = ( WM_APP + 100 ), //MixCu̓G[bZ[W( wParam G[^Cv(ERR) lParam Iꍇ True )
	};

	//Z[tl[( MIX_SAFE_NAME )
	static const wchar_t* STR_SAFE_NAME = L"Unknown";

	//ʂ̃bZ[W
	static const wchar_t* STR_ILLEGALARG = L"sȈn܂";
	static const wchar_t* STR_ERR_NOT_SUPPORT_VERSION = L"̃o[W̓T|[gĂ܂";
	static const wchar_t* STR_ILLEGALFORMAT = L"t@CtH[}bgsł";
	static const wchar_t* STR_OUTOFMEMORY = L"VXesĂ܂";
	static const wchar_t* STR_FILENOTFOUND = L"t@C܂";
	static const wchar_t* STR_RETERROR = L"G[Ԃ܂";
	static const wchar_t* STR_INITERROR = L"ɃG[܂";
	static const wchar_t* STR_NAME = L"Name";
	static const wchar_t* STR_DEBUGNAME = L"DebugName";

	//[U[`
	static const wchar_t* DEF_USERDIRECTORYNAME = L"mix\\";			//ftHg̃[U[tH_
	static const wchar_t* SYSTEM_FILENAME = L"mix_system.txt";		//VXet@C
	static const wchar_t* LOG_FILENAME = L"mix_log.txt";			//Ot@C

	template<typename T>
	Boolean Vector_Contains( const std::vector<T>& list, const T elm )
	{
		return ( std::find( list.begin(), list.end(), elm ) != list.end() );
	}

	template<typename T>
	void Vector_FirstErase( std::vector<T>& list, size_t index )
	{
		MIX_ASSERT( list.size() > index );

		size_t lastIndex = list.size() - 1;

		if( lastIndex > 0 )
		{
			T temp = list[index];
			list[index] = list[lastIndex];
			list[lastIndex] = temp;
		}

		list.pop_back();
	}

	template<typename T, class InputIterator>
	void Vector_FirstErase( std::vector<T>& list, InputIterator& it )
	{
		MIX_ASSERT( list.size() > 0 );

		size_t index = std::distance( list.begin(), it );
		size_t lastIndex = list.size() - 1;

		MIX_ASSERT( index <= lastIndex );

		if( lastIndex > 0 )
		{
			T temp = list[index];
			list[index] = list[lastIndex];
			list[lastIndex] = temp;
		}

		list.pop_back();
	}

	template<typename T>
	Boolean Vector_FirstErase( std::vector<T>& list, T obj )
	{
		size_t count = list.size();
		if( count == 0 )
		{
			return False;
		}

		size_t lastIndex = list.size() - 1;
		if( lastIndex > 0 )
		{
			std::vector<T>::iterator it = std::find( list.begin(), list.end(), obj );

			if( it != list.end() )
			{
				size_t index = std::distance( list.begin(), it );

				T temp = list[index];
				list[index] = list[lastIndex];
				list[lastIndex] = temp;
			}
			else
			{
				return False;
			}
		}

		list.pop_back();

		return True;
	}

	HINSTANCE GetInternalInstanceHandle( void );

	Mix::Engine* GetInternalEnginePtr( void );
	Mix::Window* GetInternalWindowPtr( void );
};

//t@C
namespace Mix{ namespace File{

	class Manager;

	static const UInt32 DIRECTORY_IDENT_MAX = 5; //fBNgʎq̍ő吔

	Mix::File::Manager* GetInternalManagerPtr( void );
}}

//Cvbg
namespace Mix{ namespace Input{

	class Manager;

	static const UInt32 DI_POV_MAX = 8;
	static const UInt32 DI_BUTTON_MAX = 32;
	static const UInt32 DI_BUTTON_MIN = 10;
	static const UInt32 DI_AXIS_MAX = 28;
	static const UInt32 DI_AXIS_MIN = 4;

	struct DI_GAMEPAD_DATA
	{
		UInt8 buttons[DI_BUTTON_MAX];
		Int32 axis[DI_AXIS_MAX];
		UInt32 pov;
	};

	static const UInt32 GAMEPAD_FINGER_MAX = 2;

	Mix::Input::Manager* GetInternalManagerPtr( void );
}}

//_Ci~NX
namespace Mix{ namespace Dynamics{

	class Manager;

	static const Mix::Dynamics::MATERIAL DEF_MATERIAL; //ftHg}eA
	static const UInt32 JOINT_TYPE_MAX = 5; //WCg^Cv̍ő
	static const UInt32 OBJECT_TYPE_MAX = 6; //IuWFNg^Cv̍ő
	static const UInt32 RB_STATUS_MAX = 3;	//Wbh{fB̃Xe[^X̍ő
	static const UInt32 DDC_MAX = 9; //fobO`F̍ő

	Mix::Dynamics::Manager* GetInternalManagerPtr( void );

}}

//OtBbNX
namespace Mix{ namespace Graphics{

	namespace Common
	{
		class Manager;
	}

	static const UInt32 SHADER_MODEL_MAX			= 3;	//VF[_[f̍ő吔
	static const UInt32 SHADER_TARGET_MAX			= 16;	//VF[_[^[Qbg̍ő吔
	static const UInt32 TARGET_MAX					= 4;	//^[Qbgő吔
	static const UInt32 VERTEX_ELEMENT_SEMANTIC_MAX	= 9;	//o[ebNXGg̃Z}eBbN^Cv̍ő吔
	static const UInt32 VERTEX_ELEMENT_FORMAT_MAX	= 14;	//o[ebNXGg̃tH[}bg̍ő吔
	static const UInt32 FILL_MAX					= 2;	//tB[hő吔
	static const UInt32 CULL_MAX					= 3;	//JO[hő吔
	static const UInt32 BLEND_MAX					= 6;	//uh[hő吔
	static const UInt32 COLOR_WRITE_MASK_MAX		= 3;	//J[݃}XNő吔
	static const UInt32 ZFUNC_MAX					= 8;	//Zt@NVő吔
	static const UInt32 TEXTURESTAGE_MAX			= 8;	//eNX`Xe[Wő吔
	static const UInt32 TEXTUREFILTER_MAX			= 3;	//eNX`tB^ő吔
	static const UInt32 TEXTUREADDRESS_MAX			= 2;	//eNX`[W̉@̍ő吔
	static const UInt32 CUBEMAP_FACE_MAX			= 6;	//L[u}bṽtFCXő吔
	static const UInt32 FMT_MAX						= 17;	//tH[}bgő吔
	static const UInt32 PT_MAX						= 5;	//v~eBu^Cv
	static const UInt32 QT_MAX						= 2;	//NG^Cv
	static const UInt32 IT_MAX						= 2;	//CfbNX^Cv

	//VF[_[^[Qbge[u
	static const char* SHADER_TARGET_TABLE[Mix::Graphics::SHADER_TARGET_MAX] =
	{
		"vs_3_0",
		"ps_3_0",

		"cs_4_0",
		"gs_4_0",
		"vs_4_0",
		"ps_4_0",

		"cs_4_1",
		"gs_4_1",
		"vs_4_1",
		"ps_4_1",

		"cs_5_0",
		"ds_5_0",
		"gs_5_0",
		"hs_5_0",
		"vs_5_0",
		"ps_5_0",
	};

	Mix::Graphics::Common::Manager* GetInternalManagerPtr( void );

}}

//OtBbNX( [eBeB )
namespace Mix{ namespace Graphics{ namespace Utility{

	static const UInt32 STR_TAB_COUNT = 4; //̃^ũJEg

	static const UInt32 MATERIAL_TRANSPARENCY_MAX		= 2;	//\bh̍ő吔
	static const UInt32 MOTION_DRIVE_AXIS_MAX			= 3;	//[VhCu̍ő吔
	static const UInt32 SCENE_TYPE_MAX					= 1;	//V[^Cv̍ő吔
	static const UInt32 SCENE_RENDERING_QUALITY_MAX		= 3;	//V[̃_Oiő吔
	static const UInt32 SCENE_SHADOW_QUALITY_MAX		= 3;	//V[̉eiő吔
	static const UInt32 SCENE_POSTEFFECT_QUALITY_MAX	= 3;	//V[̃|XgGtFNgiő吔

}}}

//TEh
namespace Mix{ namespace Sound{

	class Manager;

	Mix::Sound::Manager* GetInternalManagerPtr( void );

}}

//lbg[N
namespace Mix{ namespace Network{

	class Manager;

	Mix::Network::Manager* GetInternalManagerPtr( void );

}}

//V[
namespace Mix{ namespace Scene{

	namespace Common
	{
		class Manager;
	}

	//_Ci~NX : tB^[\
	struct DYNAMICS_FILTER
	{
		UInt16 group;	//O[v
		UInt16 mask;	//}XN
	};

	static const UInt32 MATERIAL_TRANSPARENCY_MAX		= 2;			//\bh̍ő吔

	static const UInt32 WCR_MAX							= 4;			//EH[^[茋ʂ̍ő吔

	static const UInt32 DKC_MAX							= 2;			//Ll}eBbNLN^[̃[h

	static const Float32 BRIGHT_PASS_MIN_OFFSET			= 0.0001f;		//uCgpX : ŏ̃ItZbg

	static const Int32 KS_BLUR_MIN_ITERATION			= 1;			//J[lTCYw肷^Cṽu[̍ŏJԂ
	static const Int32 KS_BLUR_MAX_ITERATION			= 16;			//J[lTCYw肷^Cṽu[̍őJԂ

	static const Float32 GAUSSIAN_BLUR_MIN_DISPERSION	= 000.0001f;	//KEVAu[̍ŏUl
	static const Float32 GAUSSIAN_BLUR_MAX_DISPERSION	= 128.0000f;	//KEVAu[̍ő啪Ul

	static const Int32 GAUSSIAN_BLUR_EX_MIN_RADIUS		= 4;			//KEVAu[EX̍ŏa
	static const Int32 GAUSSIAN_BLUR_EX_MAX_RADIUS		= 64;			//KEVAu[EX̍ő唼a

	static const UInt32 DDC_DYNAMICS_FIRST				= 0;			//fobO : `F : _Ci~NX̍ŏ
	static const UInt32 DDC_DYNAMICS_LAST				= 8;			//fobO : `F : _Ci~NX̍Ō
	static const UInt32 DDC_MAX							= 21;			//fobO : `F : ő吔

	static const wchar_t* STR_DISABLED_DYNAMICS			= L"_Ci~NXɂȂĂ܂B";

	Mix::Scene::Common::Manager* GetInternalManagerPtr( void );

}}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// }N
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//\̃oւ̃ItZbg擾
#define MIX_OFFSETOF( Class, Value ) static_cast<UInt16>( offsetof( Class, Value ) )

//l[ NULL nȂ悤ɂ邽߂̒`
//#define MIX_SAFE_NAME( name ) ( name != NULL )? name : L"UNKNOWN"
#define MIX_SAFE_NAME( name ) ( ( name == NULL ) || ( wcslen( name ) == 0 ) )? Mix::STR_SAFE_NAME : name

//̒擾
#define MIX_STR_LENGTH( str ) ( ( str != NULL )? ::wcslen( str ) : 0 )
//NULLłԂ悤
#define MIX_SAFE_STR( str ) ( ( str != NULL )? str : L"" )

//O : T|[g
#define MIX_LOG_STR( str ) ( str != NULL )? str : L"NULL"	//
#define MIX_LOG_PTR( ptr ) ( ptr != NULL )? L"" : L"~"	//|C^
#define MIX_LOG_BOOLEAN( state ) ( ( state ) == True )? L"" : L"~"	//Boolean

//O : 
#ifdef _DEBUG
	#define MIX_LOG_INFO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO, 0, format, __VA_ARGS__ )
	#define MIX_LOG_INFO_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO, Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
	#define MIX_LOG_INFO_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_INFO, Mix::Logger::F_NO_OVERLAP );
	#define MIX_LOG_INFO_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_INFO, Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
	#define MIX_LOG_INFO_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_INFO, Mix::Logger::F_NO_OVERLAP )
#else //_DEBUG
	#define MIX_LOG_INFO( format, ... )
	#define MIX_LOG_INFO_NO( format, ... )
	#define MIX_LOG_INFO_SL_NO()
	#define MIX_LOG_INFO_SECT_START( format, ... )
	#define MIX_LOG_INFO_SECT_END()
#endif //_DEBUG

//O : ( [Xło͂ )
#define MIX_LOG_INFO_F( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO_FORCE, 0, format, __VA_ARGS__ )
#define MIX_LOG_INFO_F_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO_FORCE, Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
#define MIX_LOG_INFO_F_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_INFO_FORCE, Mix::Logger::F_NO_OVERLAP );
#define MIX_LOG_INFO_F_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_INFO_FORCE, 0, format, __VA_ARGS__ )
#define MIX_LOG_INFO_F_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_INFO_FORCE, 0 )

//O : x
#define MIX_LOG_WARNING( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_WARNING, 0, format, __VA_ARGS__ )
#define MIX_LOG_WARNING_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_WARNING, Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
#define MIX_LOG_WARNING_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_WARNING, Mix::Logger::F_NO_OVERLAP );
#define MIX_LOG_WARNING_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_WARNING, 0, format, __VA_ARGS__ )
#define MIX_LOG_WARNING_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_WARNING, 0 )

//O : G[
#define MIX_LOG_ERROR( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_ERROR, 0, format, __VA_ARGS__ )
#define MIX_LOG_ERROR_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_ERROR, Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
#define MIX_LOG_ERROR_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_ERROR, Mix::Logger::F_NO_OVERLAP );
#define MIX_LOG_ERROR_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_ERROR, 0, format, __VA_ARGS__ )
#define MIX_LOG_ERROR_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_ERROR, 0 )

#ifdef _MIX_DEVELOP

	//O : (DEVELOP)
	#define MIX_LOG_DEV_INFO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_INFO_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_INFO, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_INFO_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_INFO, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP );
	#define MIX_LOG_DEV_INFO_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_INFO, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_INFO_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_INFO, Mix::Logger::F_DEVELOP )

	//O : x(DEVELOP)
	#define MIX_LOG_DEV_WARNING( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_WARNING, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_WARNING_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_WARNING, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_WARNING_SL_NO() Logger::Instance()->WriteSectionLine( Mix::Logger::L_WARNING, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP );
	#define MIX_LOG_DEV_WARNING_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_WARNING, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_WARNING_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_WARNING, Mix::Logger::F_DEVELOP )

	//O : G[(DEVELOP)
	#define MIX_LOG_DEV_ERROR( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_ERROR, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_ERROR_NO( format, ... ) Logger::Instance()->WriteText( Mix::Logger::L_ERROR, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_ERROR_SL_NO Logger::Instance()->WriteSectionLine( Mix::Logger::L_ERROR, Mix::Logger::F_DEVELOP | Mix::Logger::F_NO_OVERLAP )
	#define MIX_LOG_DEV_ERROR_SECT_START( format, ... ) Logger::Instance()->WriteSctionStart( Mix::Logger::L_ERROR, Mix::Logger::F_DEVELOP, format, __VA_ARGS__ )
	#define MIX_LOG_DEV_ERROR_SECT_END() Logger::Instance()->WriteSctionEnd( Mix::Logger::L_ERROR, Mix::Logger::F_DEVELOP )

#else //_MIX_DEVELOP

	//O : (DEVELOP)
	#define MIX_LOG_DEV_INFO( format, ... )
	#define MIX_LOG_DEV_INFO_NO( format, ... )
	#define MIX_LOG_DEV_INFO_SL_NO()
	#define MIX_LOG_DEV_INFO_SECT_START( format, ... )
	#define MIX_LOG_DEV_INFO_SECT_END()

	//O : x(DEVELOP)
	#define MIX_LOG_DEV_WARNING( format, ... )
	#define MIX_LOG_DEV_WARNING_NO( format, ... )
	#define MIX_LOG_DEV_WARNING_SL_NO()
	#define MIX_LOG_DEV_WARNING_SECT_START( format, ... )
	#define MIX_LOG_DEV_WARNING_SECT_END()

	//O : G[(DEVELOP)
	#define MIX_LOG_DEV_ERROR( format, ... )
	#define MIX_LOG_DEV_ERROR_NO( format, ... )
	#define MIX_LOG_DEV_ERROR_SL_NO
	#define MIX_LOG_DEV_ERROR_SECT_START
	#define MIX_LOG_DEV_ERROR_SECT_END()

#endif //_MIX_DEVELOP

//O : i
#define MIX_LOG_PAR_PLUS() Logger::Instance()->Par( +1 )
#define MIX_LOG_PAR_MINUS() Logger::Instance()->Par( -1 )
