#include "Mix/Class/PCH.h"
#include "Mix/Class/Engine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
// Global values
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix
{
	static HINSTANCE g_hInternalInstance = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// DLLMain
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved )
{
	switch( fdwReason )
	{
	case DLL_PROCESS_ATTACH:
		Mix::g_hInternalInstance = hinstDLL;
		break;
	}

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{

	HINSTANCE GetInternalInstanceHandle( void )
	{
		return g_hInternalInstance;
	}

	Mix::Engine* GetInternalEnginePtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance();
	}

	Mix::Window* GetInternalWindowPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalWindowPtr();
	}

}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::File
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace File{

	Mix::File::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalFileManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Input
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Input{

	Mix::Input::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalInputManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Dynamics
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Dynamics{

	Mix::Dynamics::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalDynamicsManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Graphics{

	Mix::Graphics::Common::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalGraphicsManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Sound
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Sound{

	Mix::Sound::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalSoundManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Network
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Network{

	Mix::Network::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalNetworkManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Scene{

	Mix::Scene::Common::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalSceneManagerPtr();
	}

}}
