#pragma once

#include "Mix/Network/ITcpServer.h"

#include "Mix/CriticalSection.h"
#include "Mix/Semaphore.h"
#include "Mix/Event.h"
#include "Mix/Event.h"
#include "Mix/Thread.h"

#include <list>

namespace Mix{ namespace Network{

	class Manager;
	class Session;
	class PacketSender;
	class PacketReceiver;

	class TcpServer : public Mix::Network::ITcpServer
	{
	private:
		//el
		enum VALUE
		{
			//CxgL[
			EVENTQUEUE_MAX		= 64,
			EVENTQUEUE_TIMEOUT	= 5000,

			//bXCxg
			LISTENEVENT_EXIT	= 0,
			LISTENEVENT_ACCEPT	= 1,
			LISTENEVENT_MAX		= 2,

			//̑
			ONSEC				= 1000,
		};

		//Cxg^Cvꗗ
		enum EVENTTYPE
		{
			//ʐMXbhJgXbh
			EVENTTYPE_NONE			= 0,
			EVENTTYPE_CONNECT		= 1,
			EVENTTYPE_DISCONNECT	= 2,
			EVENTTYPE_ERROR			= 3,
		};

		//Cxg
		struct EVENTARG
		{
			UInt32 type;

			union
			{
				struct
				{
					Mix::Network::Session* pSession;
					Mix::Network::PacketSender* pPacketSender;
					Mix::Network::PacketReceiver* pPacketReceiver;
				}conn;

				struct
				{
					Mix::Network::Session* pSession;
				}disconn;

				struct
				{
					Mix::Network::RESULT ret;
					Mix::Network::Session* pSession;
				}err;

				struct
				{
					Mix::Network::Session* pSession;
				}disconn_s;
			};

			EVENTARG( void ) :
			type( EVENTTYPE_NONE )
			{
				conn.pSession = NULL;
				conn.pPacketSender = NULL;
				conn.pPacketReceiver = NULL;
				disconn.pSession = NULL;
				err.pSession = NULL;
				err.ret = Mix::Network::OK;
			}
		};

		//CxgL[
		class EventQueue
		{
		private:
			Mix::CriticalSection m_Sync;
			Mix::Semaphore m_SemaEmpty;
			Mix::Semaphore m_SemaCount;
			EVENTARG m_Events[EVENTQUEUE_MAX];
			UInt32 m_ReadPos;
			UInt32 m_WritePos;
			EVENTARG m_Empty;

		public:
			EventQueue( void );

		public:
			void Push( const EVENTARG& arg );
			EVENTARG& Pop( void );
		};

		//ڑtOꗗ
		enum CONNECTIONFLAGS
		{
			CF_RECV_READ			= 0x00000001,	//Mv
			CF_RECV_PARSE			= 0x00000002,	//Mf[^̉͗v

			CF_CLOSE				= 0x00000004,	//N[Yv

			CF_NOCAPACITY_TEMPBUFF	= 0x00000008,	//e|Mobt@̋󂫗eʂs
			CF_NOCAPACITY_BUFF		= 0x00000010,	//Mobt@̋󂫗eʂs
		};

		//ڑ\
		struct CONNECTION
		{
			SOCKET sock;
			WSAEVENT sockEvent;
			SOCKADDR_IN sockAddr;

			UInt32 flags;

			UInt32 updateTime;
			UInt32 sendBytesPerSec;
			UInt32 receiveBytesPerSec;

			Mix::Network::Session* pSession;
			Mix::Network::PacketSender* pPacketSender;
			Mix::Network::PacketReceiver* pPacketReceiver;
		};

		//ڑXg
		typedef std::list<CONNECTION> ConnectionList;

		//|[IuWFNg\
		struct POLLOBJECT
		{
			Boolean bRecvEcho;
			UInt32 echoTime;
			Mix::Network::Session* pSession;
			Mix::Network::PacketReceiver* pPacketReceiver;
			Mix::Network::PacketSender* pPacketSender;
		};

		//|[IuWFNgXg
		typedef std::list<POLLOBJECT> PollObjectList;

	public:
		static TcpServer* CreateInstance( Mix::Network::Manager* pMgr, const wchar_t* debugName );

	private:
		Mix::Network::Manager* m_pMgr;

		Mix::String m_Name;

		UInt16 m_Port;
		UInt32 m_MaxConnection;
		Mix::Network::ITcpServerCallback* m_pCallback;
		UInt32 m_SleepTime;
		UInt32 m_EchoInterval;
		UInt32 m_TimeOut;
		UInt32 m_SendBuffSize;
		UInt32 m_ReceiveBuffSize;
		UInt32 m_ReceiveTempBuffSize;

		Boolean m_bInitialize;
		Mix::Thread m_Thread;
		Mix::Event m_EventDestroy;
		EventQueue m_EventQue;

		WSAEVENT m_hListenEventArray[LISTENEVENT_MAX];
		SOCKET m_ListenSocket;

		ConnectionList m_ConnectionList;
		PollObjectList m_PollObjectList;

	private:
		TcpServer( Mix::Network::Manager* pMgr, const wchar_t* name );
		virtual ~TcpServer( void );

		Boolean DoEvent( void );
		void DoEvent_Connect( EVENTARG& eventArg );
		void DoEvent_Disconnect( EVENTARG& eventArg );
		void DoEvent_Error( EVENTARG& eventArg );

		PollObjectList::iterator FindPollObject( Mix::Network::Session* pSession );

		void ThreadMain( void );
		Boolean ThreadMain_Initialize( void );
		void ThreadMain_Finalize( void );
		void ThreadMain_NewConnection( void );
		void ThreadMain_CloseConnection( ConnectionList::iterator& it );
		void ThreadMain_Error( Mix::Network::Session* pSession, Mix::Network::RESULT ret );

		static void __cdecl ThreadEntry( void* pArg );

	public:
		Boolean Initialize( const Mix::Network::TCP_SERVERCONFIG& cfg );
		const wchar_t* GetName( void ) const;

	public:
		virtual void Poll( void );

		virtual void Destroy( void );
		virtual Boolean IsDestroy( void ) const;

		virtual UInt32 SendAll( const void* pData, UInt32 dataSize );
		virtual UInt32 CloseAll( void );

		virtual UInt32 GetCount( void ) const;
	};

}}
