#pragma once

#include "Mix/Network/ITcpClient.h"
#include "Mix/CriticalSection.h"
#include "Mix/Semaphore.h"
#include "Mix/Thread.h"
#include "Mix/Event.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace Network{

	class Manager;
	class PacketSender;
	class PacketReceiver;

	class TcpClient : public Mix::Network::ITcpClient
	{
	private:
		enum VALUE
		{
			EVENTQUEUE_MAX = 4,
			ONSEC = 1000,
		};

		enum EVENTTYPE
		{
			EVENTTYPE_NONE			= 0x00000000,
			EVENTTYPE_CONNECT		= 0x00000001,
			EVENTTYPE_DISCONNECT	= 0x00000002,
			EVENTTYPE_ERROR			= 0x00000003,
			EVENTTYPE_EXIT			= 0x00000004,
		};

		struct EVENTARG
		{
			UInt32 type;
			Int32 opt;
		};

		class EventQueue
		{
		private:
			Mix::CriticalSection m_Sync;
			Mix::Semaphore m_SemaEmpty;
			Mix::Semaphore m_SemaCount;
			EVENTARG m_Events[EVENTQUEUE_MAX];
			UInt32 m_ReadPos;
			UInt32 m_WritePos;

		public:
			EventQueue( void );

		public:
			void Push( UInt32 type, Int32 opt = 0 );
			UInt32 Poll( Int32* opt = NULL );
		};

		enum SOCKFLAGS
		{
			SF_RECV_WRITE			= 0x00000001,	// M : e|ɏ
			SF_RECV_PARSE			= 0x00000002,	// M : e|͂

			SF_CLOSE				= 0x00000004,	// N[Y

			SF_NOCAPACITY_TEMPBUFF	= 0x00000008,	//e|Mobt@̋󂫗eʂs
			SF_NOCAPACITY_BUFF		= 0x00000010,	//Mobt@̋󂫗eʂs
		};

		struct THREADCONTEXT
		{
			SOCKET sock;
			WSAEVENT sockEvent;

			UInt32 sockFlags;
			Boolean bConnected;

			UInt32 updateTime;
			UInt32 sendBytesPerSec;
			UInt32 receiveBytesPerSec;
		};

		struct SHAREDATA
		{
			Mix::CriticalSection sync;
			UInt32 sendBytesPerSec;
			UInt32 receiveBytesPerSec;
		};

	public:
		static TcpClient* CreateInstance( Mix::Network::Manager* pMgr, const wchar_t* name );

	private:
		Mix::String m_Name;

	private:
		Mix::Network::Manager* m_pMgr;

		Mix::Network::ITcpClientCallback* m_pCallback;
		UInt32 m_EchoTime;
		Boolean m_bConnected;
		Boolean m_bInitialize;

		UInt16 m_Port;
		Mix::String m_Addr;
		Boolean m_bUseNagle;
		UInt32 m_SleepTime;
		UInt32 m_TimeOut;

		SHAREDATA m_ShareData;

		Mix::Thread m_Thread;
		Mix::Event m_EventDestroy;
		EventQueue m_EventToThread;
		EventQueue m_EventToCurrent;
		Mix::Network::PacketSender* m_pPacketSender;
		Mix::Network::PacketReceiver* m_pPacketReceiver;

	private:
		TcpClient( Mix::Network::Manager* pMgr, const wchar_t* debugName );
		virtual ~TcpClient( void );

		Boolean DoEvent( void );
		void DoEvent_Connect( void );
		void DoEvent_Disconnect( void );

		void ThreadMain( void );
		void ThreadMain_Connect( THREADCONTEXT& ctx );
		void ThreadMain_Disconnect( THREADCONTEXT& ctx );
		void ThreadMain_Error( Mix::Network::RESULT ret );

		static void __cdecl ThreadEntry( void* pArg );

	public:
		Boolean Initialize( const Mix::Network::TCP_CLIENTCONFIG& cfg );
		const wchar_t* GetName( void ) const;

	public:
		virtual void Poll( void );
		virtual void Destroy( void );
		virtual Boolean IsDestroy( void ) const;
		virtual void Connect( void );
		virtual void Disconnect( void );
		virtual Boolean IsConnected( void ) const;
		virtual Boolean Send( const void* pData, UInt32 dataSize );
		virtual UInt32 GetSendBytesPerSec( void ) const;
		virtual UInt32 GetReceiverBytesPerSec( void ) const;
	};

}}
