#pragma once

#include "Mix/Network/ISession.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace Network{

	class PacketSender;

	class Session : public Mix::Network::ISession
	{
	public:
		static Session* CreateInstance( const wchar_t* addr, Mix::Network::PacketSender* pPacketSender );

	private:
		Mix::String m_Addr;
		void* m_pUserData;

		Mix::CriticalSection m_Sync;
		Mix::Network::PacketSender* m_pPacketSender;
		Boolean m_bClose;
		UInt32 m_SendBytesPerSec;
		UInt32 m_ReceiveBytesPerSec;

	private:
		Session( const wchar_t* addr, Mix::Network::PacketSender* pPacketSender );
		virtual ~Session( void );

	public:
		//N[Y : XbȟĂяop
		void ForceClose( void );
		void SetPerSec( UInt32 sendBytes, UInt32 receiveBytes );

	public:
		virtual void Close( void );
		virtual Boolean IsClose( void ) const;
		virtual const wchar_t* GetClientAddr( void ) const;
		virtual UInt32 GetSendBytesPerSec( void ) const;
		virtual UInt32 GetReceiverBytesPerSec( void ) const;
		virtual void SetUserData( void* pData );
		virtual void* GetUserData( void ) const;
	};

}}
