#include "Mix/Class/Network/Session.h"
#include "Mix/Class/Network/PacketSender.h"

namespace Mix{ namespace Network{

Session* Session::CreateInstance( const wchar_t* addr, Mix::Network::PacketSender* pPacketSender )
{
	return new Session( addr, pPacketSender );
}

Session::Session( const wchar_t* addr, Mix::Network::PacketSender* pPacketSender ) :
m_Addr( addr ),
m_pUserData( NULL ),
m_pPacketSender( pPacketSender ),
m_bClose( False ),
m_SendBytesPerSec( 0 ),
m_ReceiveBytesPerSec( 0 )
{
	MIX_ASSERT( pPacketSender != NULL );
	if( m_pPacketSender != NULL )
	{
		m_pPacketSender->AddRef();
	}
}

Session::~Session( void )
{
	MIX_RELEASE( m_pPacketSender );
}

void Session::ForceClose( void )
{
	m_Sync.Enter();

	if( m_bClose == False )
	{
		m_pPacketSender->Disable( True );
		m_bClose = True;
		m_SendBytesPerSec = 0;
		m_ReceiveBytesPerSec = 0;
	}

	m_Sync.Leave();
}

void Session::SetPerSec( UInt32 sendBytes, UInt32 receiveBytes )
{
	m_Sync.Enter();

	m_SendBytesPerSec = sendBytes;
	m_ReceiveBytesPerSec = receiveBytes;

	m_Sync.Leave();
}

void Session::Close( void )
{
	m_Sync.Enter();

	if( m_bClose == False )
	{
		m_pPacketSender->Disable();
		m_bClose = True;
		m_SendBytesPerSec = 0;
		m_ReceiveBytesPerSec = 0;
	}

	m_Sync.Leave();
}

Boolean Session::IsClose( void ) const
{
	Boolean ret;

	m_Sync.Enter();
	ret = m_bClose;
	m_Sync.Leave();

	return ret;
}

const wchar_t* Session::GetClientAddr( void ) const
{
	return m_Addr.GetConstPtr();
}

UInt32 Session::GetSendBytesPerSec( void ) const
{
	UInt32 ret;

	m_Sync.Enter();
	ret = m_SendBytesPerSec;
	m_Sync.Leave();

	return ret;
}

UInt32 Session::GetReceiverBytesPerSec( void ) const
{
	UInt32 ret;

	m_Sync.Enter();
	ret = m_ReceiveBytesPerSec;
	m_Sync.Leave();

	return ret;
}

void Session::SetUserData( void* pData )
{
	m_pUserData = pData;
}

void* Session::GetUserData( void ) const
{
	return m_pUserData;
}

}}
