#pragma once

#include "Mix/Network/IPacketSender.h"
#include "Mix/CriticalSection.h"
#include "Mix/Event.h"

namespace Mix{ namespace Network{

	class PacketSender : public Mix::Network::IPacketSender
	{
	public:
		static PacketSender* CreateInstance( UInt32 buffSize );

	private:
		Mix::CriticalSection m_Sync;
		Mix::Event m_FullEvent;
		Mix::Event m_EmptyEvent;
		UInt8* m_pBuff;
		UInt32 m_BuffSize;
		UInt32 m_WriteCur;
		Boolean m_bValid;

	private:
		PacketSender( UInt32 buffSize );
		virtual ~PacketSender( void );

	private:
		Boolean WriteBuff( const void* pData, UInt32 size );

	public:
		Boolean Initialize( void );

		void Enable( void );
		void Disable( Boolean bForce = False );

		void WriteEcho( void );

		Int8* BeginRead( UInt32& size );
		void EndRead( void );

	public:
		virtual Boolean Write( const void* pData, UInt32 size );
	};

}}
