#include "Mix/Class/Network/PacketSender.h"
#include "Mix/Class/Network/PacketTypes.h"

namespace Mix{ namespace Network{

PacketSender* PacketSender::CreateInstance( UInt32 buffSize )
{
	return new PacketSender( buffSize );
}

PacketSender::PacketSender( UInt32 buffSize ) :
m_FullEvent( False ),
m_EmptyEvent( False ),
m_pBuff( NULL ),
m_BuffSize( buffSize ),
m_WriteCur( 0 ),
m_bValid( True )
{
	MIX_ASSERT( m_BuffSize > 0 );
}

PacketSender::~PacketSender( void )
{
	Mix::Memory::Free( m_pBuff );
}

Boolean PacketSender::Initialize( void )
{
	m_pBuff = static_cast<UInt8*>( Mix::Memory::Allocate( m_BuffSize ) );
	if( m_pBuff == NULL )
	{
		return False;
	}

	return True;
}

void PacketSender::Enable( void )
{
	m_Sync.Enter();
	m_bValid = True;
	m_Sync.Leave();
}

void PacketSender::Disable( Boolean bForce )
{
	m_Sync.Enter();

	m_bValid = False;
	if( bForce == True )
	{
		m_EmptyEvent.Set();
	}

	m_Sync.Leave();
}

void PacketSender::WriteEcho( void )
{
	UInt32 pk[4];

	//wb_
	pk[0] = PKVALUE_HEAD;
	pk[1] = PKTYPE_ECHO;
	pk[2] = 0;
	pk[3] = PKVALUE_TAIL;

	//݂Jn
	m_Sync.Enter();
	WriteBuff( pk, sizeof( pk ) );
	m_Sync.Leave();
}

Int8* PacketSender::BeginRead( UInt32& size )
{
	m_Sync.Enter();

	if( m_WriteCur == 0 )
	{
		m_Sync.Leave();
		size = 0;
		return NULL;
	}

	size = m_WriteCur;

	return reinterpret_cast<Int8*>( m_pBuff );
}

void PacketSender::EndRead( void )
{
	m_WriteCur = 0;

	if( m_FullEvent.Wait( 0 ) == True )
	{
		m_EmptyEvent.Set();
	}

	m_Sync.Leave();
}

Boolean PacketSender::Write( const void* pData, UInt32 size )
{
	if( size > m_BuffSize )
	{
		return False;
	}

	UInt32 pkh[3];
	UInt32 pkt;
	Boolean ret;

	//
	ret = False;

	//wb_
	pkh[0] = PKVALUE_HEAD;
	pkh[1] = PKTYPE_DATA;
	pkh[2] = size;

	//e[
	pkt = PKVALUE_TAIL;

	//݂Jn
	m_Sync.Enter();

	if( ( WriteBuff( pkh, sizeof( pkh ) ) == True ) &&
		( WriteBuff( pData, size ) == True ) &&
		( WriteBuff( &pkt, sizeof( pkt ) ) == True ) )
	{
		ret = True;
	}

	m_Sync.Leave();

	return ret;
}

Boolean PacketSender::WriteBuff( const void* pData, UInt32 size )
{
	UInt32 emptySize;
	UInt32 writeSize;
	const UInt8* ps;
	UInt8* pd;

	ps = static_cast<const UInt8*>( pData );
	pd = ( &( m_pBuff[0] ) + m_WriteCur );

	while( size > 0 )
	{
		if( m_WriteCur == m_BuffSize )
		{
			m_FullEvent.Set();

			m_Sync.Leave();
			m_EmptyEvent.Wait();
			m_Sync.Enter();
		}

		if( m_bValid == False )
		{
			break;
		}

		emptySize = ( m_BuffSize - m_WriteCur );
		writeSize = ( emptySize < size )? emptySize : size;

		Mix::Memory::Copy( pd, ps, writeSize );

		ps += writeSize;
		pd += writeSize;

		size -= writeSize;

		m_WriteCur += writeSize;
	}

	return m_bValid;
}

}}
