#pragma once

#include "Mix/Reference.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace Network{

	class PacketReceiver : public Mix::Reference
	{
	public:
		enum RESULT
		{
			OK						= 0,

			ERROR_PACKET_BLOKEN		= -1,
			ERROR_PACKET_LARGE		= -2,

			WARNING_BUFF_CAPACITY	= -3,
		};

	private:
		enum RECVBUFFSTATE
		{
			RBS_VERIFY_HEAD	= 0,	//wb_̊mF
			RBS_VERIFY_TAIL	= 1,	//eC̊mF
		};

	public:
		static PacketReceiver* CreateInstance( UInt32 dataBuffSize, UInt32 reciveBuffSize );

	private:
		RECVBUFFSTATE m_RecvBuffState;
		UInt8* m_pRecvBuff;
		UInt32 m_RecvBuffSize;
		UInt32 m_RecvBuffWrite;

		Mix::CriticalSection m_DataBuffSync;
		UInt8* m_pDataBuff;
		UInt32 m_DataBuffSize;
		UInt32 m_DataBuffWrite;
		UInt32 m_DataBuffRead;

	private:
		PacketReceiver( UInt32 dataBuffSize, UInt32 recvBuffSize );
		virtual ~PacketReceiver( void );

	public:
		Boolean Initialize( void );

	public:
		void ResetWrite( void );
		Int8* GetWrite( UInt32& size );
		void Write( UInt32 size );

		PacketReceiver::RESULT Parse( void );

	public:
		void BeginRead( void );
		Boolean Read( UInt32& packetType, void** ppData, UInt32& size );
		void EndRead( void );
	};

}}
