#include "Mix/Class/Network/PacketReceiver.h"
#include "Mix/Class/Network/PacketTypes.h"
#include "Mix/ScopedLock.h"

namespace Mix{ namespace Network{

PacketReceiver* PacketReceiver::CreateInstance( UInt32 dataBuffSize, UInt32 reciveBuffSize )
{
	return new PacketReceiver( dataBuffSize, reciveBuffSize );
}

PacketReceiver::PacketReceiver( UInt32 dataBuffSize, UInt32 recvBuffSize ) :
m_pRecvBuff( NULL ),
m_RecvBuffSize( recvBuffSize ),
m_RecvBuffWrite( 0 ),
m_RecvBuffState( RBS_VERIFY_HEAD ),
m_pDataBuff( NULL ),
m_DataBuffSize( dataBuffSize ),
m_DataBuffWrite( 0 ),
m_DataBuffRead( 0 )
{
}

PacketReceiver::~PacketReceiver( void )
{
	Mix::Memory::Free( m_pDataBuff );
	Mix::Memory::Free( m_pRecvBuff );
}

Boolean PacketReceiver::Initialize( void )
{
	m_pDataBuff = static_cast<UInt8*>( Mix::Memory::Allocate( m_DataBuffSize ) );
	if( m_pDataBuff == NULL )
	{
		return False;
	}

	m_pRecvBuff = static_cast<UInt8*>( Mix::Memory::Allocate( m_RecvBuffSize ) );
	if( m_pRecvBuff == NULL )
	{
		return False;
	}

	return True;
}

void PacketReceiver::ResetWrite( void )
{
	m_RecvBuffWrite = 0;
	m_RecvBuffState = RBS_VERIFY_HEAD;
}

Int8* PacketReceiver::GetWrite( UInt32& size )
{
	if( m_RecvBuffSize == m_RecvBuffWrite )
	{
		size = 0;
		return NULL;
	}

	size = ( m_RecvBuffSize - m_RecvBuffWrite );

	return reinterpret_cast<Int8*>( ( &( m_pRecvBuff[0] ) + m_RecvBuffWrite ) );
}

void PacketReceiver::Write( UInt32 size )
{
	UInt32 emptySize = ( m_RecvBuffSize - m_RecvBuffWrite );

	MIX_ASSERT( emptySize >= size );

	if( emptySize >= size )
	{
		m_RecvBuffWrite += size;
	}
	else
	{
		m_RecvBuffWrite = m_RecvBuffSize;
	}
}

PacketReceiver::RESULT PacketReceiver::Parse( void )
{
	PacketReceiver::RESULT ret = PacketReceiver::OK;
	UInt32* pkh = reinterpret_cast<UInt32*>( m_pRecvBuff );
	Boolean bLock = False;

	while( ret == 0 )
	{
		if( m_RecvBuffState == RBS_VERIFY_HEAD )
		{
			//wb_mF

			if( m_RecvBuffWrite >= PKVALUE_HEADSIZE )
			{
				if( pkh[0] == PKVALUE_HEAD )
				{
					if( pkh[1] < PKTYPE_MAX )
					{
						if( pkh[2] <= PKVALUE_DATASIZE_MAX )
						{
							//eC̊mFֈȍ~
							m_RecvBuffState = RBS_VERIFY_TAIL;
						}
						else
						{
							//f[^TCY傫
							ret = PacketReceiver::ERROR_PACKET_LARGE;
						}
					}
					else
					{
						//pPbgjĂ( T|[gȂ^Cv )
						ret = PacketReceiver::ERROR_PACKET_BLOKEN;
					}
				}
				else
				{
					//pPbgjĂ( wb_mFłȂ )
					ret = PacketReceiver::ERROR_PACKET_BLOKEN;
				}
			}
			else
			{
				//KvȗʂMĂȂ
				break;
			}
		}
		else if( m_RecvBuffState == RBS_VERIFY_TAIL )
		{
			//eCmF

			if( m_RecvBuffWrite >= ( PKVALUE_HEADSIZE + PKVALUE_TAILSIZE + pkh[2] ) )
			{
				UInt32 pos = ( PKVALUE_HEADSIZE + pkh[2] );
				UInt32* pkt = reinterpret_cast<UInt32*>( &( m_pRecvBuff[0] ) + pos );

				if( *pkt == PKVALUE_TAIL )
				{
					UInt32 dataSize;

					//f[^obt@bNĂȂꍇ́AbN
					if( bLock == False )
					{
						m_DataBuffSync.Enter();
						bLock = True;
					}

					//Mobt@Af[^obt@ɃRs[
					dataSize = ( pkh[2] + 8 );
					if( ( m_DataBuffSize - m_DataBuffWrite ) >= dataSize )
					{
						//f[^Rs[
						//Rs[f[^́Au^Cv(4Byte)vuTCY(4Byte)vuf[^(?Byte)v
						Mix::Memory::Copy( ( &( m_pDataBuff[0] ) + m_DataBuffWrite ), ( &( m_pRecvBuff[0] ) + 4 ), dataSize );
						m_DataBuffWrite += dataSize;

						//Mobt@̎c擪Ɉړ
						pos += PKVALUE_TAILSIZE;
						if( m_RecvBuffWrite > pos )
						{
							m_RecvBuffWrite -= pos;
							Mix::Memory::Copy( m_pRecvBuff, ( &( m_pRecvBuff[0] ) + pos ), m_RecvBuffWrite );
						}
						else
						{
							m_RecvBuffWrite = 0;
						}

						//wb_̊mFֈȍ~
						m_RecvBuffState = RBS_VERIFY_HEAD;
					}
					else
					{
						//Mobt@̋󂫗eʂsĂ
						ret = PacketReceiver::WARNING_BUFF_CAPACITY;
					}
				}
				else
				{
					//pPbgjĂ(eCmFłȂ)
					ret = PacketReceiver::ERROR_PACKET_BLOKEN;
				}
			}
			else
			{
				//KvȗʂMĂȂ
				break;
			}
		}
	}

	if( bLock == True )
	{
		m_DataBuffSync.Leave();
	}

	return ret;
}

void PacketReceiver::BeginRead( void )
{
	m_DataBuffSync.Enter();
}

Boolean PacketReceiver::Read( UInt32& packetType, void** ppData, UInt32& size )
{
	if( m_DataBuffWrite == m_DataBuffRead )
	{
		return False;
	}

	UInt32* ps = reinterpret_cast<UInt32*>( &( m_pDataBuff[0] ) + m_DataBuffRead );

	packetType = *ps;
	size = *( ps + 1 );
	( *ppData ) = ( ps + 2 );

	m_DataBuffRead += ( size + 8/*pPbg^Cv[4]  f[^TCY[4]*/ );

	return True;
}

void PacketReceiver::EndRead( void )
{
#ifdef _DEBUG
	MIX_ASSERT_EX( ( m_DataBuffWrite == m_DataBuffRead ), L"PacketReceiver : f[^obt@ׂēǂݎKv܂" );
#endif //_DEBUG

	m_DataBuffWrite = 0;
	m_DataBuffRead = 0;

	m_DataBuffSync.Leave();
}

}}
