#pragma once

#include <map>
#include "Mix/Network/IManager.h"

namespace Mix{ namespace Network{

	class Manager : public Mix::Network::IManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZEWINSOCK2;
		static const wchar_t* FAILED_GETLOCALIPADDR;
		static const wchar_t* FAILED_CREATETCPSERVER;
		static const wchar_t* FAILED_CREATETCPCLIENT;

		static const wchar_t* g_WSResultTextTable[13];

	public:
		struct PORTARGS
		{
			enum FLAGS
			{
				TCP_SERVER = 0x00000001,
				TCP_CLIENT = 0x00000002,
				UDP_CLIENT = 0x00000004,
			};

			UInt32 flags;

			PORTARGS( void ) :
			flags( 0 )
			{
			}
		};

	private:
		typedef std::map<UInt16, PORTARGS> PortMap;

	public:
		static Manager* CreateInstance( void );

	private:
		Mix::String m_LocalIPAddr;
		PortMap m_PortMap;

	private:
		Manager( void );
		virtual ~Manager( void );

		PORTARGS* GetPortArgs( UInt16 port );

	public:
		Boolean Initialize( void );

		//utypev́uPORTARGS::FLAGSv̂ǂꂩw肷
		void Remove( UInt16 port, UInt32 type );
		const wchar_t* GetWSResultText( Int32 ret );

	public:
		virtual Boolean CreateTcpServer( const Mix::Network::TCP_SERVERCONFIG& cfg, Mix::Network::ITcpServer** ppTcpServer, const wchar_t* debugName );
		virtual Boolean CreateTcpClient( const Mix::Network::TCP_CLIENTCONFIG& cfg, Mix::Network::ITcpClient** ppTcpClient, const wchar_t* debugName );
		virtual const wchar_t* GetLocalIPAddr( void ) const;
	};

}}
