#include "Mix/Class/Network/Manager.h"
#include "Mix/Class/Network/TcpServer.h"
#include "Mix/Class/Network/TcpClient.h"

namespace Mix{ namespace Network{

const wchar_t* Manager::FAILED_INITIALIZEWINSOCK2 = L"Winsock2̏Ɏs";
const wchar_t* Manager::FAILED_GETLOCALIPADDR     = L"[JIPAhX̎擾Ɏs";
const wchar_t* Manager::FAILED_CREATETCPSERVER    = L"TCPT[o[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATETCPCLIENT    = L"TCPNCAg̍쐬Ɏs";

const wchar_t* Manager::g_WSResultTextTable[13] =
{
	L"ʐM̏łĂ܂",
	L"vꂽo[W̓T|[gĂ܂",
	L"\PbgĂяoubNĂ܂",
	L"\Pbg̎ɂđΉĂ^XNEɒB܂",
	L"ȃ|C^n܂",
	L"uWSAStartupvĂяoĂȂAsĂ܂",
	L"lbg[NTuVXëُo܂",
	L"T[o[܂",
	L"T[o[̉܂",
	L"f[^x[XɒvIȃG[܂",
	L"vꂽO͗LłAvꂽ^Cṽf[^͌܂ł",
	L"ubLOIy[V́uWSACancelBlockingCallv̌ĂяoɂĒf܂",
	L"ʐMG[(%d)",
};

Manager* Manager::CreateInstance( void )
{
	return new Manager();
}

Manager::Manager( void )
{
}

Manager::~Manager( void )
{
	::WSACleanup();
}

Boolean Manager::Initialize( void )
{
	Int32 ret;
	Int8 name[128];
	WSADATA data;
	hostent* phe;

	//Winsock2̏
	ret = ::WSAStartup( MAKEWORD( 2, 0 ), &data );
	if( ret != 0 )
	{
		MIX_LOG_ERROR( L"%s : WSAStartup %s : Result[%s]", FAILED_INITIALIZEWINSOCK2, Mix::STR_RETERROR, GetWSResultText( ret ) );
		return False;
	}

	//[JIPAhX擾
	ret = ::gethostname( name, sizeof( name ) );
	if( ret != SOCKET_ERROR )
	{
		phe = ::gethostbyname( name );
		if( phe != NULL )
		{
			in_addr addr;

			Mix::Memory::Copy( &addr, phe->h_addr_list[0], sizeof( in_addr ) );
			m_LocalIPAddr = ::inet_ntoa( addr );
		}
		else
		{
			MIX_LOG_ERROR( L"%s : gethostbyname %s : Result[%s]", FAILED_GETLOCALIPADDR, Mix::STR_RETERROR, GetWSResultText( ::WSAGetLastError() ) );
			return False;
		}
	}
	else
	{
		MIX_LOG_ERROR( L"%s : gethostname %s : Result[%s]", FAILED_GETLOCALIPADDR, Mix::STR_RETERROR, GetWSResultText( ret ) );
		return False;
	}

	return True;
}

void Manager::Remove( UInt16 port, UInt32 type )
{
	PORTARGS* pPortArgs = GetPortArgs( port );

	if( MIX_TESTBIT( pPortArgs->flags, type ) == type )
	{
		MIX_RESETBIT( pPortArgs->flags, type );
	}
}

const wchar_t* Manager::GetWSResultText( Int32 ret )
{
	static wchar_t temp[256];

	switch( ret )
	{
	case WSASYSNOTREADY:
		return g_WSResultTextTable[0];
	case WSAVERNOTSUPPORTED:
		return g_WSResultTextTable[1];
	case WSAEINPROGRESS:
		return g_WSResultTextTable[2];
	case WSAEPROCLIM:
		return g_WSResultTextTable[3];
	case WSAEFAULT:
		return g_WSResultTextTable[4];
	case WSANOTINITIALISED:
		return g_WSResultTextTable[5];
	case WSAENETDOWN:
		return g_WSResultTextTable[6];
	case WSAHOST_NOT_FOUND:
		return g_WSResultTextTable[7];
	case WSATRY_AGAIN:
		return g_WSResultTextTable[8];
	case WSANO_RECOVERY:
		return g_WSResultTextTable[9];
	case WSANO_DATA:
		return g_WSResultTextTable[10];
	case WSAEINTR:
		return g_WSResultTextTable[11];
	}

	::wsprintfW( temp, g_WSResultTextTable[12], ret );

	return temp;
}

Boolean Manager::CreateTcpServer( const Mix::Network::TCP_SERVERCONFIG& cfg, Mix::Network::ITcpServer** ppTcpServer, const wchar_t* debugName )
{
	Mix::String name = MIX_SAFE_NAME( debugName );

	if( ( cfg.pCallback == NULL ) ||
		( cfg.receiveBuffSize == 0 ) ||
		( cfg.sendBuffSize == 0 ) ||
		( cfg.timeOut <= cfg.echoInterval ) )
	{
		MIX_LOG_ERROR( L"%s : TCP_SERVERCONFIG ̐ݒ肪ُ : Name[%s]", FAILED_CREATETCPSERVER, name.GetConstPtr(), cfg.port );
		return False;
	}

	Manager::PORTARGS* pPortArgs;
	Mix::Network::TcpServer* pTcpServer;
	
	pPortArgs = GetPortArgs( cfg.port );
	if( MIX_TESTBIT( pPortArgs->flags, PORTARGS::TCP_SERVER ) == PORTARGS::TCP_SERVER )
	{
		MIX_LOG_ERROR( L"%s : |[g͂łɎgpĂ܂ : Name[%s] Port[%d]", FAILED_CREATETCPSERVER, name.GetConstPtr(), cfg.port );
		return False;
	}

	pTcpServer = Mix::Network::TcpServer::CreateInstance( this, name.GetConstPtr() );
	if( pTcpServer == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATETCPSERVER, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	if( pTcpServer->Initialize( cfg ) == True )
	{
		//|[ggpɂ
		MIX_SETBIT( pPortArgs->flags, PORTARGS::TCP_SERVER );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : Initialize %s : Name[%s]", FAILED_CREATETCPSERVER, Mix::STR_RETERROR, name.GetConstPtr() );
		MIX_RELEASE( pTcpServer );
		return False;
	}

	( *ppTcpServer ) = pTcpServer;

	MIX_LOG_INFO( L"TCPT[o[쐬 : Name[%s] Port[%d] MaxConnection[%d]", name.GetConstPtr(), cfg.port, cfg.maxConnection );

	return True;
}

Boolean Manager::CreateTcpClient( const Mix::Network::TCP_CLIENTCONFIG& cfg, Mix::Network::ITcpClient** ppTcpClient, const wchar_t* debugName )
{
	Mix::String name = MIX_SAFE_NAME( debugName );

	if( ( cfg.pCallback == NULL ) ||
		( cfg.receiveBuffSize == 0 ) ||
		( cfg.sendBuffSize == 0 ) ||
		( cfg.timeOut == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : TCP_CLIENTCONFIG ̐ݒ肪ُł : Name[%s]", FAILED_CREATETCPCLIENT, name.GetConstPtr() );
		return False;
	}

	Manager::PORTARGS* pPortArgs;
	Mix::Network::TcpClient* pTcpClient;
	
	pPortArgs = GetPortArgs( cfg.port );
	if( MIX_TESTBIT( pPortArgs->flags, PORTARGS::TCP_CLIENT ) == PORTARGS::TCP_CLIENT )
	{
		MIX_LOG_ERROR( L"%s : w肳ꂽ|[g͂łɎgpĂ܂ : Name[%s] Port[%d]", FAILED_CREATETCPCLIENT, name.GetConstPtr(), cfg.port );
		return False;
	}

	pTcpClient = Mix::Network::TcpClient::CreateInstance( this, name.GetConstPtr() );
	if( pTcpClient == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : Name[%s]", FAILED_CREATETCPCLIENT, Mix::STR_OUTOFMEMORY, name.GetConstPtr() );
		return False;
	}

	if( pTcpClient->Initialize( cfg ) == True )
	{
		//|[ggpɂ
		MIX_SETBIT( pPortArgs->flags, PORTARGS::TCP_CLIENT );
	}
	else
	{
		MIX_RELEASE( pTcpClient );
		MIX_LOG_ERROR( L"%s : Initialize %s : Name[%s]", FAILED_CREATETCPCLIENT, Mix::STR_RETERROR, name.GetConstPtr() );
		return False;
	}

	( *ppTcpClient ) = pTcpClient;

	MIX_LOG_INFO( L"TCPNCAg쐬 : Name[%s] Port[%d] ServerIPAddr[%s]", name.GetConstPtr(), cfg.port, cfg.pServerIPAddr );

	return True;
}

const wchar_t* Manager::GetLocalIPAddr( void ) const
{
	return m_LocalIPAddr.GetConstPtr();
}

Manager::PORTARGS* Manager::GetPortArgs( UInt16 port )
{
	PortMap::iterator it;
	
	//݂Ă|[gT
	it = m_PortMap.find( port );
	if( it == m_PortMap.end() )
	{
		//VK|[gǉ
		m_PortMap.insert( std::pair<UInt16, Manager::PORTARGS>( port, Manager::PORTARGS() ) );
		it = m_PortMap.find( port );
	}

	return &( it->second );
}

}}
